<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage core
*//** */

/**
* Extended from CI to enforce a limit on how long a log entry can be.  This will default to 10KB, but can be altered by setting 
* LOG_ENTRY_MAX_LENGTH_IN_BYTES (which is determined by .ini entries at the time of this writing in order to make it easy to configure
* this on an environment level).  This prevents things like extremely large SQL queries from being dumped into the log and reduces
* the chance that it will become so large as to be basically unopenable.
*
* @package vler
* @subpackage core
*/
class VLER_Log extends CI_Log {

	public function write_log($level, $msg){
		if ($this->_enabled === FALSE)
			return FALSE;

		$this->truncate_message_if_needed($msg);
		
		return parent::write_log($level, $msg);
	}
	
	//public so that VLER_Exceptions can also use this and we only have this logic in one place
	public function truncate_message_if_needed(&$message){
		$max_length = (defined('LOG_ENTRY_MAX_LENGTH_IN_BYTES') && is_numeric(LOG_ENTRY_MAX_LENGTH_IN_BYTES)) ? LOG_ENTRY_MAX_LENGTH_IN_BYTES : 10240; //default to 10KB if this constant wasn't set up
		
		//make sure we don't get giant amounts of data written to the logs all at once (like the insert statement for a 70 MB file transfer if something goes wrong with the query execution)
		$message_length = mb_strlen($message, '8bit');
		if($message_length > $max_length){
			$message = substr($message, 0, $max_length).' ... [Remaining data redacted to avoid filling up the logs. Change LOG_ENTRY_MAX_LENGTH_IN_BYTES if you need to adjust this behavior.]';
		}
	}
}