//document ready function
$(function() {

	$(".ttFocus").tipTip({activation: "focus", delay:0, edgeOffset:0});
	$(".ttHover").tipTip({delay:100});
	$(".ttTopHover").tipTip({defaultPosition:"top",delay:100});
	
	//ajax form for the regenerate keys on the application list
	$(".keyForm").ajaxForm({  
		type: "POST",  
		url: "/applications/update_key/",  
		success: function(data, status, jqXHR) {
			if ($.parseJSON(data)['success']){
				$('#message-success').html($.parseJSON(data)['message']).slideDown(500).delay(5000).slideUp(500);
				$('#message-success').focus();
				$('#public-modal'+$.parseJSON(data)['id']).html($.parseJSON(data)['public']);
				$('#private-modal'+$.parseJSON(data)['id']).html($.parseJSON(data)['private']);
			}else{
				$('#error').html($.parseJSON(data)['message']).slideDown(500).delay(5000).slideUp(500);
				$('#error').focus();
			}
		},
		error: function (jqXHR, textStatus, errorThrown) {
			$('#message-error').html($.parseJSON(jqXHR.responseText)['message']).slideDown(500).delay(5000).slideUp(500);
		}
	});

	//Accessibility Related Items
	$('.hidden_context.hidden_link').focus(function(e) {
		$(e.target).addClass('visible');
	});
	$('.hidden_context.hidden_link').blur(function(e) {
		$(e.target).removeClass('visible');
	});
	$('ul.nav > li.menu > ul > li > a').focus(function(e) {
		$(e.target).parent().parent().addClass('visible');
	});
	$('ul.nav > li.menu > ul > li > a').blur(function(e) {
		$(e.target).parent().parent().removeClass('visible');
	});
	
	//workaround for webkit/opera bug that prevents skip nav links from working correctly
	var is_webkit = navigator.userAgent.toLowerCase().indexOf('webkit') > -1;
	var is_opera = navigator.userAgent.toLowerCase().indexOf('opera') > -1;
	var is_IE = navigator.userAgent.toLowerCase().indexOf('msie') > -1;
	if(is_webkit || is_opera || is_IE)
	{
		var target = document.getElementById('mainContent');
		if(target != null) {
			target.href="#mainContent";
			target.innerText="";
			var skipNav = document.getElementById('skipNav');
			if(skipNav != null) {
				skipNav.setAttribute("onclick" , "document.getElementById('mainContent').setAttribute('tabindex' , '0'); document.getElementById('mainContent').focus();");
			}
		}
		 		
		var target = document.getElementById('nav_tab_holder');
		if(target != null) {
			target.href="#nav_tab_holder";
			var skipNav = document.getElementById('skip_nav');
			if(skipNav != null) {
				skipNav.setAttribute("onclick" , "document.getElementById('nav_tab_holder').setAttribute('tabindex' , '0'); document.getElementById('nav_tab_holder').focus();");
			}
		}
		
		var target = document.getElementById('reportFilter');
		if(target != null) {
			target.href="#reportFilter";
			target.innerText="Report Filter";
			var skipNav = document.getElementById('skipReportMenu');
			if(skipNav != null) {
				skipNav.setAttribute("onclick" , "document.getElementById('reportFilter').setAttribute('tabindex' , '0'); document.getElementById('reportFilter').focus();");
			}
		}
		var target = document.getElementById('reportContent');
		if(target != null) {
			target.href="#reportContent";
			target.innerText="Report Content";
			var skipNav = document.getElementById('skipReportFilter');
			if(skipNav != null) {
				skipNav.setAttribute("onclick" , "document.getElementById('reportContent').setAttribute('tabindex' , '0'); document.getElementById('reportContent').focus();");
			}
		}
	}
});
function update_folders(){
	$.ajax({
		url : '/global_search/update_folders/'+ $('#mailbox').val() + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data,statusText,xhr) {
			var data_arr = $.parseJSON(data);
			$("#folder").empty();
			 $('#folder').append($('<option>', { 
			        value: "ALL",
			        text : "(ALL)" 
			}));
			$.each(data_arr, function(key, value) {
				 $('#folder').append($('<option>', { 
				        value: key,
				        text : value 
				}));
			});
		}
	});
}
$(".message_error").ready(function(){
	setTimeout(function(){
	var message = $(".message_error").html();
	if(message != null){
		$('#StatusUpdater').text(strip(message));
	}
	},10);
});
$(".message_success").ready(function(){
	setTimeout(function(){
	var message = $(".message_success").html();
	if(message != null){
		$('#StatusUpdater').text(strip(message));
	}
	},10);
});
$(".message_info").ready(function(){
	setTimeout(function(){
	var message = $(".message_info").html();
	if(message != null){
		$('#StatusUpdater').text(strip(message));
	}
	},10);
});
function strip(html)
{
   var tmp = document.createElement("DIV");
   tmp.innerHTML = html;
   return tmp.textContent || tmp.innerText || "";
}

function checkBeforeAfterDates(start_date_id, end_date_id, message) {
	var startDate = -1;
	if($('#' + start_date_id).datepicker('getDate') != null) { 
		startDate = $('#' + start_date_id).datepicker('getDate').getTime();
	}
	var endDate = -1;
	if($('#' + end_date_id).datepicker('getDate') != null) { 
		endDate = $('#' + end_date_id).datepicker('getDate').getTime();
	}
	//assign a value that's smaller than the endDate to startDate when it's left blank and the endDate is before 1/1/1970
	if(endDate < -1 && startDate == -1) {
		startDate = endDate - 1;
	}
	var dateErrorMessage = document.getElementById('date_error_message');
	var filterButton = document.getElementById('filter_button');
	if(endDate < startDate && endDate != -1) {
		if(dateErrorMessage.innerHTML.indexOf(message) < 0) {
			dateErrorMessage.innerHTML += message + '<br>';
		}
		if(dateErrorMessage.innerHTML != '') {
			$( "#date_error_message" ).fadeIn('slow');
			filterButton.disabled = true;
			filterButton.className = 'gray-button';
		}
	}	
	else {
		if(dateErrorMessage.innerHTML.indexOf(message) >= 0) {
			dateErrorMessage.innerHTML = dateErrorMessage.innerHTML.replace(message + '<br>', '');
		}
		if(dateErrorMessage.innerHTML == '') {
			$( "#date_error_message" ).fadeOut('slow');
			filterButton.disabled = false;
			filterButton.className = 'blue-button';
		}
		
	}
}

function countCharInTextField(fieldId, characterLimit) {
    var inputLength = $('#' + fieldId).val().length;
	if(inputLength > characterLimit){
		$('#' + fieldId).val($('#' + fieldId).val().substring(0, characterLimit));
		inputLength = $('#' + fieldId).val().length;
	}
    var characterLeft = characterLimit - inputLength;
    if(characterLeft > 1) {
    	$('#char_num_' + fieldId).text(characterLeft + ' characters left');
    }
    else {
    	$('#char_num_' + fieldId).text(characterLeft + ' character left');
    }
}

/*function printByElementId_not_working_for_IE(elementId) {
	window.frames["print_frame"].document.body.innerHTML = document.getElementById(elementId).innerHTML;
    window.frames["print_frame"].window.focus();
    window.frames["print_frame"].window.print();
}
*/
function printByElementId(elementId) {
	var printContent = document.getElementById(elementId);
    var windowUrl = 'print_job';
    var uniqueName = new Date();
    var windowName = 'Print' + uniqueName.getTime();
    var printWindow = window.open(windowUrl, windowName, 'left=50000,top=50000,width=0,height=0');
    printWindow.document.write(printContent.innerHTML);
    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
    printWindow.close();
}


function clearMessage(elementId){
	if($('#' + elementId) != null) {
		$('#' + elementId).value = '';
		$('#' + elementId).hide(500);
	}
}