<?php 
/**
* @package exercisedesigndashboard
* @subpackage views
*/

//todo - buttons
//todo - links in feedback messages
//todo - tables

/** */

?>
<style>
	.pattern {padding: 2em 0; border-bottom: 1px dotted #ccc;}
</style>
<p>This is a demo page of the basic styling of elements on the site, and some common CSS patterns throughout the site.  The base code for this primer is  borrowed from <a href="http://adactio.com/journal/5028/" target="_blank">Jeremy Keith's</a> <a href="https://github.com/adactio/Pattern-Primer/tree/master/patterns" target="_blank">pattern primer.</a>  Note that these styles are only available on pages that use the main template for the site (views/template).

In addition to site-specific stylesheets, the this site makes use of Twitter's <a href="https://github.com/twitter/bootstrap/" target="_blank">Bootstrap framework</a> (documented <a href="http://twitter.github.com/bootstrap/base-css.html" target="_blank">here</a>).  There are many Bootstrap features not demonstrated here, so please check the Bootstrap documentation to see if you can use one of their patterns before writing new CSS.  

We use a customized version of Bootstrap.  You can retrieve our json custom configuration by going to the gist url listed on our bootstrap CSS.  Many Bootstrap settings can be tweaked using the Bootstrap customizer, and this is preferable to overriding their styles in our local stylesheets when you want to make a systemic change.

<p><strong>Primary CSS contributors / People to ask questions of:</strong>  Margaret Gibbs.</p>
<hr />
<?php
$files = get_filenames(APPPATH.'views/style_guide/patterns/');
sort($files);

//put any patterns that you want to make sure are easily visible here, in the order that they should appear
$order = array('text.html', 'links.html', 'heading-1.html', 'heading-2.html', 'heading-3.html', 'heading-4.html', 'heading-5.html', 'heading-6.html',  'list-unordered.html', 'list-ordered.html', 'list-unordered-indented.html', 'list-unordered-unstyled.html', 'table.html' );
$files = array_unique(array_merge($order, $files));

foreach ($files as $file):
    echo '<div class="pattern row">';
    echo '<div class="display col-sm-7">';
    include('patterns/'.$file);
    echo '</div>';
    echo '<div class="source col-sm-5"">';
    echo '<textarea rows="6" cols="30" class="form-control col-md-12">';
    echo htmlspecialchars(file_get_contents(APPPATH.'views/style_guide/patterns/'.$file));
    echo '</textarea>';
    echo '<p><a href="patterns/'.$file.'">'.$file.'</a></p>';
    echo '</div>';
    echo '</div>';
endforeach;


?>
<hr />
<h2>Form Markup Generator Library</h2>
<p>For the patterns below, we're running through each of the <a href="http://dev.ds.src.bah.com/docs/tfg.bah.com/frame/icarus/libraries/Field_markup_generator.html">markup generator types</a> in the Icarus Form Markup Generator library.  Not all of these types are currently used on the site, but ideally we'll have the CSS set up in advance so that we can use new field types as needed without having to worry about CSS.</p>
<?php

require_library('form_markup_generator');

$files = get_filenames(VLER_DIRECTORY.'application/libraries/form_markup_generator/field_markup_generators/');
$application_files = get_filenames(APPPATH.'libraries/form_markup_generator/field_markup_generators/');
if(!empty($application_files))
	$files = array_merge($files, $application_files);

sort($files);


$fields = array();
foreach($files as $file){ 
	$type = strip_from_end('.php', $file);
	$name = $type.'_example';
	if($type == 'field_group' || $type == 'time' || $type == 'rich_text_area' || $type == 'tiny_rich_text_area') continue; //field_group is abstract
	$fields[$name] = array('type' => $type);
	if(in_array($type, array('dropdown', 'checkbox_group', 'radio_button_group')))
		$fields[$name]['options'] = array('one' => 'Option One', 'two' => 'Option Two', 'three' => 'Option Three');
	if($type == 'checkbox_group')
		$fields[$name]['comment'] = 'Please select one or more of the options below.';
		
	//make some fields required, semi-randomly
	if(string_begins_with('u', $name)){
		$fields[$name]['required'] = true;
		$fields[$name]['attributes']['placeholder'] = strip_from_end('/', site_url());
	}
	
	//show what it looks like when fields have an error	
	if(string_begins_with('y', $name))
		$fields[$name]['has_error'] = true;
}

$form_generator = new Form_markup_generator($fields, array('use_grid' => true));

foreach($form_generator->fields as $field):
	$human_readable_settings = "'".$field->type."'";
	if($field->property_exists('options'))
		$human_readable_settings = "array('type' => ".$human_readable_settings.", 'options' => array('".key_value_implode($field->options, "' => '", "', '" )."'))"; 
	
	$code = '$form = new Form_markup_generator()'."\n";
	$code .= '$form->use_grid = true;'."\n";
	$code .= '$form->set_field(\''.$field->name.'\', '.$human_readable_settings.');'."\n";
	$code .= 'echo $form->markup();';

    echo '<div class="pattern row">';
    echo '<div class="display col-sm-7 form-horizontal">';
 	echo $field->markup();
    echo '</div>';
    echo '<div class="source col-sm-5">';
    echo '<textarea rows="6" cols="30" class="form-control col-md-12">';
    echo htmlspecialchars($code);
    echo '</textarea>';
    echo '</div>';
    echo '</div>';
endforeach;  

 
?>