<?php
/**
 * @package direct-as-a-service
 * @subpackage views
 * @filesource
 */ /** */

$this->load->view('api/header');
$this->load->view('api/nav');
?>
<h1><a href="/onboarding/documentation/" class="underline">Documentation</a> &rarr; /direct/automatic_reply/retrieve - GET</h1>
<p>
    The Automatic Reply service allows authorized applications to retrieve an “Out of Office” message for a mailbox and can accessed by sending a GET request to direct/automatic_reply/find
</p>
<h3>Authentication</h3>
<p>
    The API authentication utilized is based upon hash message authentication code (HMAC). HMAC is an authentication method that combines a cryptographic hash function with a secret cryptographic key. After the successful registration of an application on the API, a public and private key like the example below will be provisioned for its use.
</p>
<p class="code">
    Public Key: eca415a13daaec88cabba68b81a2149c97800864acd9ef0e15b5b8426de2464d
    <br/>Private Key: 0097cd109a3b72df1f988e4a6e3e344ecc02cdab9a03736bc12463b7d1b889a8
</p>
<p>
    On every request that an application sends to the API they must include an Authorization header. The authorization header is a string that the API will utilize to confirm the identity, and the message content, of the sender. The authorization header consists of three parts. The first part is the API identifier, represented by the word "DAAS", which stands for Direct as a Service. The API identifier is followed by a space that separates it from the identifying content. The identifying content consists of the unique public key and the base64 encoded HMAC hash generated by the request content and the private key, delimited by a colon. An example of the authorization header is below.
</p>
<p class="code">
    Authorization: DAAS eca415a13daaec88cabba68b81a2149c97800864acd9ef0e15b5b8426de2464d: Y2UwOTMwNGRmYzhlNTQ0YTZiODlmMDkwYWQzOWY1ODZmNzI4OTE5NTc3ZTYyYWE2M2EwNThlMGIzMTZkZTZlZA==
</p>
<p>
    The HMAC string is generated by running an HMAC hash function on a plain text string and the application's private key. The plain text string that must be hashed using HMAC is constructed as follows:
<ul>
    <li>HTTP Request Type</li>
    <li>Date</li>
    <li>Content-MD5 (Optional)</li>
    <li>Content Type (Not including boundary)</li>
    <li>URI</li>
</ul>
These values are separated by new line characters ("\n"). An example of the plain text string is below:
</p>
<p class="code">
    GET\n06/03/2013 12:13:56 EST\niB94gawbwUSiZy5FuruIOQ==\n/direct/automatic_reply/retrieve/format/json?mailbox=1
</p>
<p>
    The string above is hashed with the application's private key using the SHA-256 algorithm. A snippet of JavaScript code showing an example of this is shown below:
</p>
<p class="code">
    var hashString = CryptoJS.HmacSHA256("GET\n06/03/2013 12:13:56 EDT\niB94gawbwUSiZy5FuruIOQ==\n/direct/automatic_reply/retrieve/format/json?mailbox=1,"0097cd109a3b72df1f988e4a6e3e344ecc02cdab9a03736bc12463b7d1b889a8");
    <br/>var base64 = encode64(""+hashString);
    <br/>var authorization = "DAAS eca415a13daaec88cabba68b81a2149c97800864acd9ef0e15b5b8426de2464d:"+base64;
</p>
<p>
    In the example above the Content MD5 is provided but this is an optional field. If the Content MD5 header is not specified then the hash should not have the MD5 specified either.
</p>
<h3>Headers</h3>
<div class="column">
    <div class="left">
        <ul>
            <li>Authorization</li>
            <p>
                The first required header is the Authorization header covered in the Authentication section at the top of this page.
            </p>
            <li>Date or X-Daas-Date</li>
            <p>
                The second required header that must be included is the Date header. Some browsers will not let an application specify the Date header programmatically, so in this case it is also acceptable to use the X-Daas-Date header as the API will interpret them interchangeably. This header should be populated with the current date and time, in any standard format (including time zone information if not time zone agnostic), when the POST request is submitted. The value supplied in the Date header must match the value used in the creation of the hash string for the Authorization header.
            </p>
        </ul>
    </div>
    <div class="right">
        <ul>
            <li>Content-Type</li>
            <p>
                The final required header for POST requests is the Content-Type. The Content-Type header must match the Content-Type provided in the hash string for the Authorization header except the hash string does not include the boundary parameter of the Content-Type if there is one (i.e. application/x-www-form-urlencoded Content-Type).
            </p>
            <li>Content-Md5</li>
            <p>
                The optional header is the Content-Md5 header. This header should contain an MD5 hash of the entire POST body. If this header is specified then it must also be included in the hash string for the Authorization header. When provided, this serves as an extra security precaution above and beyond TLS to ensure the POST request sent has not been modified in transit.
            </p>
        </ul>
    </div>
</div>
<h3>Arguments</h3>
<p>
    There are 4 arguments that can be sent to the retrieve automatic reply web service.
</p>
<div class="column">
    <div class="left">
        <ul>
            <li>Mailbox</li>
            <p>
                Mailbox	This is a required field which identifies which mailbox’s messages should be returned. This is the local portion of the Direct address, i.e., test.user@direct.DOMAIN.EXT is the Direct address so that passed value you would test.user.
            </p>
            <li>Content</li>
            <p>
                Content This is a required field which is the message body of the Automatic Reply messages.
            </p>
        </ul>
    </div>
    <div class="right">
        <ul>
            <li>Start_at</li>
            <p>
                This is an optional field which includes the current start date/time or later date/time in order to send the automatic reply message to users.
            </p>
            <li>End_at</li>
            <p>
                This is an optional field which includes the current end date/time or date/time after the start date in order to send the automatic reply messages to users.
            </p>
        </ul>
    </div>
</div>
<h3>Example Response</h3>
<ul>
    <li>Success</li>
    <ul>
        <li>HTTP-200, {“request_id”:4, “content”: “sample message for automatic reply”,“mailbox_id”:”2”,”start_at”: “1403203517”,”end_at”:” 1403203533”}
        </li>
    </ul>
    <li>Error</li>
    <ul>
        <li>
            HTTP-401, {"request_id":5,"message":"Access Denied. Use Not Authorized."}
        </li>
        <li>
            HTTP-403, {"request_id":5,"message":"Access Denied. Use Not Authorized."}
        </li>
        <li>
            HTTP-403, {"request_id":6,"message":"Access Denied. User Not Authorized."}
        </li>
        <li>
            HTTP-422, {"request_id":"886","fields":["content"],"message":"'content' is a required field."}
        </li>
        <li>
            HTTP-422, {"request_id":"894","message":"'start_at' contains invalid input","fields":["start_at"]}
        </li>
    </ul>
</ul>
<h3>Sample Code</h3>
<p>
    Please click <a href="/onboarding/documentation/validate_example">here</a> to be taken to some sample code snippets for the validate web service.
</p>
</div>
<?PHP $this->load->view('api/footer'); ?>
</div>
</body>
</html>