<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

?>
<div class="container-fluid">
<?php if($account_request && ($account_request->is_denied() || $account_request->user_is_deactivated())):?>
	<?php echo dismissable_alert('<strong>Your account is disabled.</strong> Please contact an administrator to request access.', 'danger') ?>
<?php endif ?>
	<div class="col-xs-12 col-md-6">
		<h3 class="h4">The Direct Project</h3>
		<p>
			The Direct Project is an open government initiative sponsored by the Office of the 
			National Coordinator for Health Information Technology (ONC) under the Department of Health 
			and Human Services (HHS). ONC developed the Direct specification for a simple, secure, 
			scalable and standards-based protocol to send encrypted, electronic health information 
			directly to known, trusted recipients over the internet. The Meaningful Use Stage 2 Final 
			Rule, released in September 4, 2012, requires support for Direct Project to qualify for 
			federal Electronic Health Record (EHR) certification; 49 State Health Information Exchanges 
			(HIEs) have planned support for Direct Project as part of the federal State HIE grant 
			program. These two factors make the Direct Project a major focus of the national HIE 
			strategy and could lead to ubiquitous use among Network Providers in the near future.
		</p>
		<h3 class="h4">Application Programming Interface (API) Documentation</h3>
		<p>The documentation, provided below, contains all the information necessary to 
			connect an application to the API and use <?php echo PRODUCT_NAME;?> web services.</p>
		<p class="text-center">
			<?php echo link_to_as_button('onboarding/documentation', 'View Documentation') ?>
		</p>
		<p>
			<?PHP echo PRODUCT_NAME;?> provides the centralized management of the security, trust and 
			routing of Direct messages for the VA. This gives applications the ability to leverage 
			the Direct messaging protocol without having to develop any new infrastructure.  
			<?PHP echo PRODUCT_NAME;?> provides VA clinical systems access to the Direct Architecture via common, 
			secure web services. 
		</p>
	</div>
	
	<div class="col-xs-12 col-md-6">
		<?PHP if(User::is_an_entity($user) && $user->is_active()) { ?>
			<h3 class="h4">Application Registration</h3>
			<p>
				Registered applications will be able to access and use <?PHP echo PRODUCT_NAME;?> web services. To 
				request application access, click on the "Request Application Access" button and provide the 
				information on the request form.
			</p>
			<p class="text-center">
				<?php echo link_to_as_button('onboarding/request', 'Request Application Access') ?>
			</p>
			<p>
				Once the application request form has been submitted, <?PHP echo PRODUCT_NAME;?> administrators will 
				be notified of pending requests awaiting approval. When the administrator approves the 
				application request, an email will be generated and sent to the Point of Contact (POC) noted 
				on the application request submission, indicating the application has received access to use 
				<?PHP echo PRODUCT_NAME;?> web services.
			</p>
			<p>
				If further information is needed to approve the application request, the <?PHP echo PRODUCT_NAME;?> 
				administrator will deny the request and provide a reason for denial and/or request further 
				information. An email notification will be sent to the requester to resubmit. A request may be 
				resubmitted, by navigating to the "Denied" tab on the application page. The application request 
				should be updated with the requested changes and resubmitted for review.
			</p>
		<?PHP } else {
			if ($status === 'Approved' || (Account_request::is_an_entity($account_request) && ($account_request->is_denied() || $account_request->user_is_deactivated()))) { ?>
				<h3 class="h4">Contact Administrators</h3>
				<?PHP if(isset($error_message)) { echo '<div class="alert alert-error">'.$error_message.'</div>'; } ?>
				<?PHP if(isset($success_message)) { echo '<div class="alert alert-success">'.$success_message.'</div>'; } ?>
				<?php if (!$sent_message) { ?>
					<p>
						If you have questions about the application or your account, you can contact the administrators using the form below. An administrator will reach out to you for follow-up.
					</p>
					<?PHP echo form_open('/support/save',array('id'=>'contactForm')); ?>
						<div class="well">
							<?PHP echo form_hidden('type', $category); ?>
							<div class="form-group">
								<label for="support_message">Message:</label>
								<textarea class="form-control" id="support_message" name="support_message"></textarea>
							</div>
						</div>
						<div class="pull-right"><input class="btn btn-default btn-sm" type="submit" value="Save"/></div>	
					<?PHP echo form_close(); ?>
				<?php } else { ?>
					<div class="message">You have already sent a message within the past 24 hours. If you are not contacted by the end of the 24 hours you will be able to submit a new message.</div>
				<?php } ?>
			<?php } else { ?>
				<h3 class="h4">User Registration</h3>
				<p>
					To create an account to the Direct Project API Admin Panel, select the link below titled, 
					"Request Account."  Registered users of the API Admin Panel will have the ability to request 
					access to the API web services for their application. In addition, the Direct Project API 
					Admin Panel allows users to manage application credentials, view application reports and usage 
					statistics, and request new application keys.
				</p>
				<p class="text-center">
				<?php if($account_request): ?>
					<?php echo link_to_as_button('onboarding/request', 'Check Account Request Status') ?>
				<?php else: ?>
					<?php echo link_to_as_button('onboarding/request', 'Request Account') ?>
				<?php endif ?>
				</p>
				<p>
					Once a user request form has been submitted, the <?PHP echo PRODUCT_NAME;?> administrators will be 
					notified of a pending account request awaiting approval. When an administrator approves the 
					account, an email will be sent indicating account access has been approved.
				</p>
				<p>
					If further information is needed to approve the user account request, the <?PHP echo PRODUCT_NAME;?> 
					administrator will deny the request and provide a reason for denial and/or request further 
					information. An email notification will be sent to the user to resubmit a request. A request 
					may be resubmitted, by simply, clicking the button titled, "Request Account Access". The 
					request will be resubmitted for review to the <?PHP echo PRODUCT_NAME;?> administrators.
				</p>
		<?PHP } //end if status approved
				} // end if registered ?>
		<h3 class="h4">Widgets</h3>
		<p>
			Widgets are an easy way to add light-weight, compact interfaces onto any page. The iframe-based
			embeddable widgets display valuable information or actions the user can make without leaving
			the target page.  Widgets are available to any application within the VA network.
		</p>
		<p class="text-center">
			<?php echo link_to_as_button('onboarding/widgets', 'View Widgets') ?>
		</p>
	</div>
</div>