<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */


?>	
<div id="denied">
	<p>This table lists the applications that have been denied access to the API services.</p>
	<?php if(empty($denied_list)): ?>
		<div class="message">There are currently no application requests that have been denied.</div>
	<?php else: ?>
		<br/>
		<table id="denied_table" class="display">
			<caption class="hidden_context">Denied Application Requests</caption>
			<thead>
				<tr class="gridheader">
					<th align="center" scope="col">Application</th>
					<th scope="col">POC</th>											
					<th scope="col">Requested Date</th>
					<th scope="col">Denial Reason</th>
				</tr>
			</thead>
			<?php foreach($denied_list as $request): ?>
				<tr id="<?php echo $request->id; ?>row">
					<td class="approve_or_deny_application_request_name">
						<?php echo $request->name; ?>&nbsp;
						<?php if($request->url): ?>
							<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
						<?php endif ?>
						<?php if($request->description): ?>
							<br/><?php echo $request->description; ?>&nbsp;
						<?php endif ?>
					</td>
					<td class="approve_or_deny_application_request_poc">
						<?php if($request->poc_name): ?>
							<?php echo $request->poc_name; ?>&nbsp;
						<?php endif ?>
						<?php if($request->poc_email): ?>
							<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
						<?php endif ?>
						<?php if($request->poc_phone): ?>
							<br/><?php echo $request->poc_phone; ?>&nbsp;
						<?php endif ?>
					</td>
					<td class="approve_or_deny_application_request_date"><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
					<td class="approve_or_deny_application_request_approve_or_deny_date">
						<?php echo $request->denial_reason; ?>&nbsp;
					</td>
				</tr>
			<?php endforeach ?>
		</table>
	<?php endif ?>
</div>