<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models-folder
* @filesource
*/

/** */
require_model('entity');

/**
* @package direct-as-a-service
* @subpackage models
*/
class Service_permission extends DAAS_Entity {
	static $table = 'mailbox_settings';
	protected static $_relationships = array('application' => array('type' => 'belongs_to'),
											 'mailbox' => array('type' => 'belongs_to'),
											 'service' => array('type' => 'belongs_to', 'related_foreign_key' => 'web_service_id' ));
	

	//could just add the default fields to the select here as far as user_settings is concerned - would that work for permissions?
	public static function set_up_service_join(){ //we should really be able to use the normal relationship join for this, but it's not written as static right now
		require_model('service');
		$table = Service::$table;
		$primary_key = Service::$primary_key;
		static::db()->select($table.'.name, '.$table.'.description');
		static::db()->select(static::default_fields());
		static::db()->join($table, static::related_foreign_key('service', true).'='.$table.'.'.$primary_key);
	} 

}