<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models-folder
* @filesource
*/

/** */
require_model('entity');

/**
* @package direct-as-a-service
* @subpackage models
*/
class Application_request extends DAAS_Entity {
	static $table = 'application_request';	
	protected static $_relationships = array( 'requestor_user'  => array( 'type' => 'belongs_to', 'model' => 'user', 'related_foreign_key' => 'requestor', 'key_for_relationship' => 'user_id'));

	public function approve(){
		$this->approved_date = now();
		if($this->save()){				
			$CI = get_instance();			
			$CI->external_email->to($CI->usersmodel->get_request_emails($this->id)); 
			
			$CI->external_email->subject('Request for application "'.$this->name.'" has been approved.'); 
			$CI->external_email->message("All,\r\n\r\nYour application has been approved for access. Please access the following link to find your public and private keys:\r\n\r\nhttps://".API_ADMINPANEL_DOMAIN."/applications/list\r\n\r\nThank you,\r\n\r\n".EMAIL_SIGNATURE);
			$CI->external_email->send();
			return true;
		}
		
		return false;
		
	}

	public function deny($reason){
		$CI = get_instance();
		
		if(!$this->is->nonempty_string($reason)) return $this->error->should_be_a_nonempty_string($reason);
		$this->denied = 1;
		$this->denial_reason = $reason;
		
		if($this->save()){
			$mail_subject = 'Request for application "'.$this->name.'" has been denied.';
			$mail_message = "All,\r\n\r\nYour application has been denied access. Please access the following link and click on the denied tab. Then update the request and resubmit.\r\n\r\nhttps://".API_ADMINPANEL_DOMAIN."/applications/list\r\n\r\nThank you,\r\n\r\n".EMAIL_SIGNATURE;
			$emails = $CI->usersmodel->get_request_emails($this->id);
					
			$CI->external_email->to($emails);
			$CI->external_email->subject($mail_subject); 
			$CI->external_email->message($mail_message); 
			$CI->external_email->send();
			return true;
		}
						
		return false;
	}
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////
	
	public static function count_pending($id_or_conditions = array()){
		static::db()->where('requested_date is NOT NULL');	
		static::db()->where('approved_date IS NULL');
    	static::db()->where('(denied IS NULL or denied = 0)');
		return static::count($id_or_conditions);
	}
	
	public static function count_approved($id_or_conditions = array()){
		static::db()->where('requested_date is NOT NULL');	
		static::db()->where('approved_date is NOT NULL');
		return static::count($id_or_conditions);
	}
	
	public static function count_denied($id_or_conditions = array()){
		static::db()->where('requested_date is NOT NULL');
		static::db()->where('approved_date is NULL');
		static::db()->where('denied', 1);
		return static::count($id_or_conditions);	
	}
	
	public static function find_pending($id_or_conditions = array()){
		static::db()->where('requested_date is NOT NULL');	
		static::db()->where('approved_date IS NULL');
    	static::db()->where('(denied IS NULL or denied = 0)');
		return static::find($id_or_conditions);
	}
	
	public static function find_approved($id_or_conditions = array()){
		static::db()->where('requested_date is NOT NULL');	
		static::db()->where('approved_date is NOT NULL');
		return static::find($id_or_conditions);
	}
	
	public static function find_denied($id_or_conditions = array()){
		static::db()->where('requested_date is NOT NULL');
		static::db()->where('approved_date is NULL');
		static::db()->where('denied', 1);
		return static::find($id_or_conditions);	
	}
	
}