<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models-folder
* @filesource
*/

/** */
require_model('entity');

/**
* @package direct-as-a-service
* @subpackage models
*/
class Application extends DAAS_Entity {
	static $table = 'application';	
	protected static $_relationships = array( 'account' => array('type' => 'has_many', 'model' => 'application_account', 'foreign_key' => 'app_id'),
											  'request' => array('type' => 'has_many'),
											  'service_permission' => array('type' => 'has_many'));
	
	
	
	public function find_account_by_organization_id($org_id){
		$app_id = $this->id;
		$unique_id = hash_hmac('sha256', $org_id, $this->private_key);
		Application_account::db()->order_by('created_at', 'desc'); //usually we don't code this into a find method, but in this case it's required and developers may not realize that
		Application_account::db()->where(compact('app_id'))->group_start()->or_where(compact('unique_id', 'org_id'))->group_end();
		$account = Application_account::find_one();		
		
		//fix for past bug -- sometimes we don't have an org id set even though we clearly know what it is since it's in the hash.  fix it!
		if(Application_account::is_an_entity($account) && $account->property_is_empty('org_id')){
			$user = User::find_one(array('user_org_id' => $org_id));
			if(User::is_an_entity($user)){
				$account->org_id = $org_id;
				$account->save();
			}
		}
		
		return $account;
	}
	
}