<?php 
/**
 * This file is for any functions that will be used only by the hook system.
 * 
 * @see http://codeigniter.com/user_guide/general/hooks.html
 * @author M. Gibbs <gibbs_margaret@bah.com>
 * @package direct-as-a-service
 * @subpackage hooks
 */

/**
* Runs any system-wide code based on the constants file.
* For example, the timezone needs to be set to the default timezone for this instance of Direct.
*/
function set_system_defaults(){
	date_default_timezone_set(ENVIRONMENT_TIMEZONE); //this instance of Direct will be configured with a default timezone, we want it set as early as possible
}


/**
* Actions which should take place after the instantiation of *all* the controllers.
*/
function post_controller_constructor(){
	get_instance()->load->library('Validator', array(), 'is');	
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ACCESSORS FOR PERFORMANCE LOGGING DEPENDENCIES
// Since hook methods need to be in APPPATH, we can't just reference Benchmark or the API library directly in the hook 
// configuration, unless maybe we think of a clever way later.  For now, this will do.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//set a benchmark for each of our hooks
function add_benchmark($hook_name){
	$BM =& load_class('Benchmark', 'core'); //controller won't be instantiated for our first hook, so need to load the same way the core/CI script does it
	$BM->mark($hook_name);
}

//on the last hook, write the benchmarks to a CSV so that we can parse the data easily
function write_benchmarks_to_log(){
	$CI =& get_instance();
	$CI->benchmark->write_to_csv();
}

function write_api_calls_to_log(){
	$CI =& get_instance();
	if(!$CI->load->is_loaded('api')) return; //nothing to do if the API library isn't up and running in the application   
	$CI->api->write_performance_log_to_csv();
}


/* End of file hook_functions.php */
/* Location: ./application/hooks/hook_functions.php */
