<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/admin/Reports.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Group_summary_report_controller extends Reports{

    //function for Group Activity Summary
    public function index($adhoc_report_id=null){
        //page set up
        $all_report = FALSE;
        if($this->has_access('group_activity_summary_report_all')){
            $all_report = TRUE;
            $facility_id = null;
        }
        else {
            $mailbox = Mailbox::find_one(array('name'=>$this->user->username));
            $facility_id = $mailbox->facility_id;
            $data['facility_id'] = $facility_id;
        }
        $data['all_report'] = $all_report;
       $selected = null;
    
        //Declaring Summary Array
        $SummaryListing =  array();
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("group_activity_summary_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $is_active = null;
        $default_active = 1;
        //gets selected facility
        $facility_selected = $this->input->post('whichfacility',TRUE);
        $export_file_name = $this->input->post('export_file_name',TRUE);
    
        if(!$all_report){
            $facility_selected = $facility_id;
        }
        //checks to see if there is an facility selected.  This shows whether or not this is the first time the page has loaded.
        if(($facility_selected || !$all_report)  && $adhoc_report_id == ''){
            $is_group_active = $this->input->post('group_status_type',TRUE);
            //if user_status_type has no value or false, assign (ALL)
            if($is_group_active === false) {
                $is_group_active = '(ALL)';
            }
    
            $selector = array(
                    'F.id' => ($facility_selected),
                    'M.is_active' => $is_group_active,
            );
            //POST information
            $items = array(
                    'M.name' => $this->search_type($this->input->post('text_group_name',TRUE),$this->input->post('group_name_type',TRUE)),
                    //'user_ext_mail' => $this->search_type($this->input->post('txtDirectAddress',TRUE),$this->input->post('direct_address_type',TRUE)),
            );
                
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
    
            $between = array(
                    'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            //get direction (desc/asc)and if it is being exported
            $order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'facilityName';
            $dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            //calls helper to get data
            $response = $this->reports_helper('group_activity_summary',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);
            $size = $response['size'];
            $group_activity_list = $response['response'];
            $counter = 0;
            //merge arrays
            foreach ($group_activity_list as $group_info){
                
                $groupName = $group_info->group_name;
                $groupID = $group_info->id;
                $groupFacilityName = $group_info->Name;
                $groupNumber_of_sent = $group_info->Number_of_sent;
                $groupNumber_of_seen = $group_info->Number_of_seen;
                $groupTotal_of_messages = $group_info->Total_messages;
                $groupIsActive = $group_info->is_active;
                //Get LDAP Information
                $resultArray = $this->groupsmodel->get_ldap_request($group_info->group_name);
                
                //checking that LDAP Results are not null
                
                if (isset ($resultArray[0]['mail'][0])){
                    $groupMail = $resultArray[0]['mail'][0];
                }
                else{ $groupMail = ''; }
                
                if (isset ($resultArray[0]['cn'][0])){
                    $groupDisplayName = $resultArray[0]['cn'][0];
                }
                else{ $groupDisplayName = ''; }
                    
                if($groupIsActive == 1){
                    $groupActiveText = 'Active';
                } else {
                    $groupActiveText = 'Inactive';
                }
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->groupName = $groupName;
                $SummaryListingObjects->displayName = $groupDisplayName;
                $SummaryListingObjects->groupMail = $groupMail;
                $SummaryListingObjects->facilityName = $groupFacilityName;
                $SummaryListingObjects->groupStatus = $groupActiveText;
                $SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
                $SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
                $SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
                array_push($SummaryListing, $SummaryListingObjects);
    
                
    
            }
            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['order'] = $order;
            //$form_data['group_status_type'] = $is_group_active;
            if(!$all_report){
                $form_data['group_name'] =   $this->input->post('text_group_name',TRUE);
                
                $form_data['text_group_name'] =   $this->input->post('text_group_name',TRUE);
                $form_data['group_name_type'] =   $this->input->post('group_name_type',TRUE);
                $form_data['txtDirectAddress'] =   $this->input->post('txtDirectAddress',TRUE);
                $form_data['direct_address_type'] =  $this->input->post('direct_address_type',TRUE);
                $form_data['group_status_type'] = $is_group_active;
                $form_data['whichfacility'] = $facility_id;
                //$form_data['end_date'] =   $this->input->post('end_date',TRUE);
                //$form_data['start_date'] =   $this->input->post('start_date',TRUE);
            }

            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);
    
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            //set form data and send form_data
            $form_data['items_per_page'] = $this->items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
            $form_data['pages'] = $this->pages;
            $data['form_data'] = $form_data;
                
            //Sorting Array
            $ldapfilters = array();
            //Converting to array for sorting
            $new_array = $this->object_to_array($SummaryListing);
            //filter_sn
            $sn_filter = $this->input->post('txtSN',TRUE);
            if($sn_filter != ""){
                $sn_filter_type = $this->input->post('last_name_type',TRUE);
                array_push($ldapfilters, 'Last Name ' . mb_strtolower($data['compare'][$sn_filter_type]). ': ' . $sn_filter);
                //setting filter type
                $search_sn = $this->search_type_for_array($sn_filter,$sn_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userSN', $search_sn);
            }
            //filter_given_name
            $givenname_filter = $this->input->post('txtGivenname',TRUE);
            if($givenname_filter != ""){
                $givenname_filter_type = $this->input->post('first_name_type',TRUE);
                array_push($ldapfilters, 'First Name ' . mb_strtolower($data['compare'][$givenname_filter_type]). ': ' . $givenname_filter);
                //setting filter type
                $search_givenname = $this->search_type_for_array($givenname_filter,$givenname_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'userGivenname', $search_givenname);
            }
            //filter_va_address
            $direct_address_filter = $this->input->post('txtDirectAddress',TRUE);
            if($direct_address_filter != ""){
                    
                $direct_address_filter_type = $this->input->post('direct_address_type',TRUE);
                array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_type]). ': ' . $direct_address_filter);
    
                //setting filter type
                $search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'groupMail', $search_direct_address);
            }
            
            $SummaryListingExport = new stdClass;
            $SummaryListingExport = $this->array_to_object($SummaryListing);
                
            unset($SummaryListing);
            $SummaryListing = $this->array_to_object(array_slice($new_array, ($this->destination_page-1)*$this->items_per_page, $this->items_per_page));
            $data['summary_list'] = $SummaryListing;
                
            $SummaryListingExport_2 = new stdClass;
            $SummaryListing_2 = $this->array_to_object(array_slice($new_array, ($this->destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $SummaryListingExport_2 = $this->array_to_object($SummaryListing_2);
                
    
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
            
            if($selector['M.is_active'] == '(ALL)'){
                $selected = '';
            }
            else if($selector['M.is_active'] == '1'){
                $selected = 'Group Status: Active, ';
            }
            else {
                $selected = 'Group Status: Inactive, ';
            }
            if($selector['F.id'] != '(ALL)') {
                 $selected .= 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name;
            }
            //pagination setup
            $this->pages->items_total = count($new_array);
            $this->pages->current_page = $this->destination_page;
            $this->pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }
                else { $data['facility'] = 'No facility set'; }
            }
            $data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
            //Adhoc_Report
            $response_adhoc = $this->reports_helper_adhoc('group_activity_summary',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);
        } else if (!empty($adhoc_report_id)){
            /*Adhoc Report - Starts Here*/
                
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            $adhoc_report_data = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"group_activity_summary")->result();
            //Filters and Data from db
            if(!isset($adhoc_report_data[0])){
                show_404();
            }
            $report_selector = $adhoc_report_data[0]->report_selector;
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);
            
            $facility_selected = $filters_used['facility_id'];
            if (mb_strtolower ($facility_selected) == "(all)"){
                $facility_selected ="";
            }
            $selector = array(
                    'F.id' => ($facility_selected),
            );
            
            //Date information
            $is_group_active =  $filters_used['group_status_type'];
            if(mb_strtolower($is_group_active) == "(all)"){
                $items = array(
                        'M.name' => $this->search_type( $filters_used['group_name'], $filters_used['group_name_type']),
                        //'group_ext_mail' => $this->search_type ($filters_used['txtvaemailaddress'], $filters_used['va_email_type']),
                );
            } else {
                $items = array(
                        'M.name' => $this->search_type( $filters_used['group_name'], $filters_used['group_name_type']),
                        //'group_ext_mail' => $this->search_type( $filters_used['txtvaemailaddress'], $filters_used['va_email_type']),
                        'M.is_active' =>  $filters_used['group_status_type'],
                );
            }
            
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
            //From Adhoc Form
            $diff_time_period =  $this->input->post('time_period',TRUE);
            
            //Get Date information
            $time_period_field = $adhoc_report_data[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];
            
            if(!empty($diff_time_period)){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report_data[0]->report_query_generator;
            
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
            
                //Date information
                $items = array();
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report_data[0]->report_query_generator;
            
                //Date information
                $items = array();
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
            
            }
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            //Setting exports
            
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
            $page =1;
            $this->items_per_page = 10;
            $between = array(
                    'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            
            //get direction (desc/asc)and if it is being exported
            
            $order_search = $adhoc_report_data[0]->report_order_by ." " .$adhoc_report_data[0]->report_order_by_direction.",id ".$adhoc_report_data[0]->report_order_by_direction;
            $order = $adhoc_report_data[0]->report_order_by;
            $dir = $adhoc_report_data[0]->report_order_by_direction;
            
            //calls helper to get data
            //Checking role permissions
            if(!$all_report){
                $sql_permission = '';
                $i = 0;
                $sql_queries_by_part = explode("AND", $sql);
                foreach ($sql_queries_by_part as $id){
                    if ($i > 0){
                        $sql_permission .=" AND ";
                    }
                    if (string_contains('F.id', $id)) {
                        $sql_permission .= "(F.id like '%".$facility_id."%')";
                    } else {
                        $sql_permission .= $id;
                    }
                    $i++;
                }
                //assigning new query to $sql
                $sql = $sql_permission;
            }
            //sql query that excludes the date filter to include groups who had no acitivity during the time period specified
#TODO - this is unnecessarily complicated.  at some point when we refactor this code, we should make sure that we have a more straightforward way of getting this data.
            $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
            $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
            
            $size = $this->groupsmodel->activity_summary_count($sql_date_filter_excluded);
            $groups_facility_list = $this->groupsmodel->get_request_filter_group_activities($sql,$sql_date_filter_excluded,$order_search,$this->db->escape($page),$this->items_per_page);
            //Adhoc_Report
            if(!$facility_selected) {
                $response_adhoc = "(F.id like '%' OR F.id IS NULL)";
            } else {
                $response_adhoc = $this->reports_helper_adhoc('group_activity_summary',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);
            }
            $counter = 0;
            //merge arrays
            foreach ($groups_facility_list as $group_info){
                //print_r($group_info);
            
                $group_name = $group_info->group_name;
                $groupID = $group_info->id;
                $groupFacilityName = $group_info->Name;
                $groupNumber_of_sent = $group_info->Number_of_sent;
                $groupNumber_of_seen = $group_info->Number_of_seen;
                $groupTotal_of_messages = $group_info->Total_messages;
                $groupIsActive = $group_info->is_active;
                //Get LDAP Information
                $resultArray = $this->groupsmodel->get_ldap_request($group_info->group_name);
            
                //checking that LDAP Results are not null
            
                if (isset ($resultArray[0]['cn'][0])){
                    $displayName = $resultArray[0]['cn'][0];
                }else { $displayName = ''; }
            
                if (isset ($resultArray[0]['mail'][0])){
                    $groupMail = $resultArray[0]['mail'][0];
                }else{
                    $groupMail = "not found";
                }
            
                if($groupIsActive == 1){ $groupActiveText = 'Active'; }
                else { $groupActiveText = 'Inactive'; }
            
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->groupName = $group_name;
                $SummaryListingObjects->displayName = $displayName;
                $SummaryListingObjects->groupMail = $groupMail;
                $SummaryListingObjects->facilityName = $groupFacilityName;
                $SummaryListingObjects->groupStatus = $groupActiveText;
                $SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
                $SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
                $SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
                array_push($SummaryListing, $SummaryListingObjects);
            
            }
            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['order'] = $order;
            
            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            //set form data and send form_data
            $form_data['items_per_page'] = $this->items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
            
            //Form Data from DB
            $form_data['txtDirectAddress'] =   $filters_used['txtdirectaddress'];
            $form_data['direct_address_type'] =   $filters_used['direct_address_type'];
            $form_data['text_group_name'] =   $filters_used['group_name'];
            $form_data['group_name_type'] =   $filters_used['group_name_type'];
            $form_data['group_status_type'] =   $filters_used['group_status_type'];
            $form_data['whichfacility'] =   $filters_used['facility_id'];
            $form_data['end_date'] =  $end_date;
            $form_data['start_date'] =  $start_date;
            $form_data['facility_id'] = $facility_id;
            $form_data['pages'] = $this->pages;
            
            //Display Information
            $form_data['report_created_time']= $adhoc_report_data[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report_data[0]->report_name;
            $form_data['report_description'] = $adhoc_report_data[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report_data[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
            $data['form_data'] = $form_data;
            
            //Sorting Array
            $ldapfilters = array();
            //Converting to array for sorting
            $new_array = $this->object_to_array($SummaryListing);
            
            //filter_va_address
            $direct_address_filter =  $filters_used['txtdirectaddress'];
            if($direct_address_filter != ""){
                $direct_address_filter_Type =  $filters_used['direct_address_type'];
                array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_Type]). ': ' . $direct_address_filter);
                //setting filter type
                $search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_Type);
                //Search on array for true values
                $new_array = $this->array_multi_search_filter($new_array, 'groupMail', $search_direct_address);
            }
            
            unset($SummaryListing);
            $SummaryListing = $this->array_to_object(array_slice($new_array, ($this->destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $this->items_per_page));
            $data['summary_list'] = $SummaryListing;
            
            $SummaryListingExport = $SummaryListing;
            $SummaryListingExport_2 = $SummaryListing;
            
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
            
            
            if(mb_strtolower ($selector['F.id']) != "(all)" && $selector['F.id'] != ''){ $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['F.id'])->result()[0]->name; }
            //pagination setup
            $this->pages->items_total = count($new_array);
            $this->pages->current_page = $this->destination_page;
            $this->pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }
                else { $data['facility'] = 'No facility set'; }
            }
            $data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
    
        } else {
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
                
            $group_activity_list = $this->groupsmodel->get_first_group_activities($this->items_per_page)->result();
            foreach ($group_activity_list as $group_info){
                $groupName = $group_info->group_name;
                $groupID = $group_info->id;
                $groupFacilityName = $group_info->Name;
                $groupNumber_of_sent = $group_info->Number_of_sent;
                $groupNumber_of_seen = $group_info->Number_of_seen;
                $groupTotal_of_messages = $group_info->Total_messages;
                $groupIsActive = $group_info->is_active;
                //Get LDAP Information
                $resultArray = $this->groupsmodel->get_ldap_request($group_info->group_name);
                //checking that LDAP Results are not null
                if (isset ($resultArray[0]['cn'][0])){
                    $groupDisplayName = $resultArray[0]['cn'][0];
                }
    
                if (isset ($resultArray[0]['mail'][0])){
                    $groupMail = $resultArray[0]['mail'][0];
                }
                else { $groupMail = 'not found'; }
    
                if($groupIsActive == 1){ $groupActiveText = 'Active'; }
                else { $groupActiveText = 'Inactive'; }
    
                $SummaryListingObjects = new stdClass;
                $SummaryListingObjects->groupName = $groupName;
                $SummaryListingObjects->displayName = $groupDisplayName;
                $SummaryListingObjects->groupMail = $groupMail;
                $SummaryListingObjects->facilityName = $groupFacilityName;
                $SummaryListingObjects->groupStatus = $groupActiveText;
                $SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
                $SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
                $SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
    
                array_push($SummaryListing, $SummaryListingObjects);
                    
            }
                
            $size = $this->groupsmodel->activity_summary_count();
			
            $form_data = array(
                    'direction' => 'DESC',
                    'order' => 'facilityName',
                    'cur_page' => '1',
            );
            //set options for comparing
            $data['compare'] = array(
                    'equals' => 'Equals',
                    'contains' => 'Contains',
                    'starts' => 'Starts With',
                    'ends' => 'Ends With'
            );
            //Adhoc Report
            $between = array ("ms.timestamp" => Array("start"=>"", "end" =>""));
            $response_adhoc = "(F.id like '%' OR F.id IS NULL)";
            $dir = "DESC";
            $order = "facilityName";
            //set blank filters
            $form_data['txtDirectAddress'] = "";
            $form_data['direct_address_type'] = "";
            $form_data['text_group_name'] =  "";
            $form_data['group_name_type'] = "";
            $form_data['group_status_type'] = "(ALL)";
            $form_data['whichfacility'] = "(ALL)";
            $form_data['end_date'] = "";
            $form_data['start_date'] = "";
            $data['form_data'] = $form_data;
            $data['filters'] = ' ';
                
            //pagination setup
            $this->pages->items_total = $size;
            $this->pages->current_page = $this->destination_page;
            $this->pages->paginate();
            $form_data['pagination_bar'] = $this->pages->display_pages();
            $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();
            $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
            $form_data['items_per_page'] = $this->items_per_page;
            $data['items_per_page'] = $this->items_per_page;
            $form_data['pages'] = $this->pages;
            $data['form_data'] = $form_data;
            $data['summary_list'] = $SummaryListing;
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            //Export Settings
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            $data['is_export'] = FALSE;
            //Adding VA Totals
            $users_facility_list_totals = $this->groupsmodel->get_first_group_activities($this->pages->items_total)->result();
            $summary_listing_totals = array();
                
            foreach ($users_facility_list_totals as $group_info_total){
                $group_number_of_sent = $group_info_total->Number_of_sent;
                $group_number_of_seen = $group_info_total->Number_of_seen;
                $group_total_of_messages = $group_info_total->Total_messages;
                $summary_listing_objects_totals = new stdClass;
                //Adding to Original Array
                $summary_listing_objects_totals->groupNumber_of_sent = $group_number_of_sent;
                $summary_listing_objects_totals->groupNumber_of_seen = $group_number_of_seen;
                $summary_listing_objects_totals->groupTotal_of_messages = $group_total_of_messages;
                array_push($summary_listing_totals, $summary_listing_objects_totals);
            }
            //Adding to SummaryListing_Totals
            $new_summary_array = array();
            $new_summary_array = $summary_listing_totals;
            $summary_listing_totals = new stdClass;
            $summary_listing_totals_array = $this->array_to_object(array_slice($new_summary_array, (1-1)*ITEMS_PER_PAGE_DEFAULT, $size));
            $summary_listing_totals = $this->array_to_object($summary_listing_totals_array);
        }
    
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "group_activity_summary";
        //set form data and send form_data
        //$form_data['items_per_page'] = $this->items_per_page;
        $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
        //$form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
    
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        //Set view or export view
        if($export){
            //Setting Excel
            if (!empty($SummaryListingExport_2)){
                $SummaryListingExport = $SummaryListingExport_2;
            }else{
                $SummaryListingExport = $SummaryListingExport;
            }
            $totalCount = count((array)$SummaryListingExport);
            $newRowNumber = $totalCount + 1;
            $SummaryListingExport->$totalCount = new StdClass;
            $SummaryListingExport->$totalCount->groupName = '';
            $SummaryListingExport->$totalCount->groupMail = '';
            $SummaryListingExport->$totalCount->facilityName = '';
            $SummaryListingExport->$totalCount->groupStatus = '';
            $SummaryListingExport->$totalCount->group_ext_mail = 'VA Total:';
            $SummaryListingExport->$totalCount->groupNumber_of_sent = $this->sum_by_object_name((array)$SummaryListingExport, 'groupNumber_of_sent');
            $SummaryListingExport->$totalCount->groupNumber_of_seen = $this->sum_by_object_name((array)$SummaryListingExport, 'groupNumber_of_seen');
            $SummaryListingExport->$totalCount->groupTotal_of_messages = $this->sum_by_object_name((array)$SummaryListingExport, 'groupTotal_of_messages');
            $this->export(array('Group Name', 'Display Name','Direct Address','VA Facility','Group Status', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListingExport,$export_file_name,$items,$between,$selected,$ldapfilters);
        }
        else if($export_pdf) {
            if (!empty($SummaryListingExport_2)){
                $data['export_summary_list'] = $SummaryListingExport_2;
            }
            $html = $this->load->view('api/reports/result_tables/result_group_activity_summary', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($SummaryListingExport_2)){
                $data['export_summary_list'] = $SummaryListingExport_2;
            }
            $data['print_page'] = true;
            $this->load->view('api/reports/group_activity_summary', $data);
        }
        else{
            $data['summary_list_totals'] = $summary_listing_totals;
            $this->load->view('api/reports/group_activity_summary', $data);
        }
    
    }

}