<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/admin/Reports.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Event_report_controller extends Reports{
	
    public function index($adhoc_report_id = null){

        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("events_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $response_export_list = $event_list = array();
        $selected = array();

        if(!$data['show']['reports']) { show_error('Forbidden',403); }
        $target_type = $this->input->post('target_type',TRUE);//gets selected
        $export_file_name = $this->input->post('export_file_name',TRUE);
        //if $adhoc_report_id is not empty, do adhoc report
        if($adhoc_report_id != ''){
            /*Adhoc Reports Starts Here....*/
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"events")->result();
            //Diff time period
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;
            $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
            $time_start_check = $selected_filter_array['start_date'];
            $time_end_check = $selected_filter_array['end_date'];

            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;

            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator = $adhoc_report[0]->report_query_generator;

                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);

                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;

                //Date information
                $end_date = $selected_filter_array['end_date'];
                $start_date = $selected_filter_array['start_date'];
            }
            //Selector
            $selector = array(
                'success' =>  $selected_filter_array['successful'],
            );

            $items = array(
                'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
                'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
            );
            $extra_items = array(
                'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
                'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
                'actor' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
                'target' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
            );
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                'event_date' => $this->check_paired_dates($start_date,$end_date),
            );

            $typesearch = array (
                'actor_id'    => array (
                    'typesql' => 'actor_type',
                    'name' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
                    'type' => $selected_filter_array['acting_type'],
                ),
                'target_id' => array(
                    'typesql' => 'target_type',
                    'name' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
                    'type' => $selected_filter_array['target_type'],
                ),
            );
            //set options for comparing
            $data['compare'] = array(
                'equals' => 'Equals',
                'contains' => 'Contains',
                'starts' => 'Starts With',
                'ends' => 'Ends With'
            );

            //get direction and if it is supported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;
            $page = 1;
            $this->destination_page = $selected_filter_array['adhoc_report_destination_page'];
            $this->pages->items_per_page = $selected_filter_array['adhoc_report_items_per_page'];

            //Get Size
            Event::db()->where($sql, NULL, FALSE); //TODO - refactor this so that we don't need to escape the SQL
            $size = Event::count();

            //Get Event List
            Event::db()->where($sql, NULL, FALSE)->order_by($order)->limit($this->items_per_page, $page-1);
            $event_list = Event::find();

            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('event',$items,$between,$selector,$typesearch,$order,$dir,$this->destination_page,$export,$this->items_per_page);
            //For ExportPDF, PRINT
            if($is_export === 'print' || $is_export === 'pdf') {
                $response_export = $this->reports_helper('event',$items,$between,$selector,$typesearch,$order,$dir,$this->destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($extra_items, $between, $selected, null);
            }

            //set form data
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $form_data['successful'] = $selected_filter_array['successful'];
            $form_data['event_id'] = $selected_filter_array['event_id'];
            $form_data['event_id_type'] = $selected_filter_array['event_id_type'];
            $form_data['action'] = $selected_filter_array['action'];
            $form_data['action_type'] = $selected_filter_array['action_type'];
            $form_data['acting_type'] = $selected_filter_array['acting_type'];
            $form_data['target_type'] = $selected_filter_array['target_type'];
            $form_data['acting_user'] = $selected_filter_array['acting_user'];
            $form_data['acting_user_type'] = $selected_filter_array['acting_user_type'];
            $form_data['target_user'] = $selected_filter_array['target_user'];
            $form_data['target_user_type'] = $selected_filter_array['target_user_type'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
        }
        else if($target_type){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                'success' =>  $this->input->post('successful',TRUE),
            );

            $items = array(
                'id' => $this->search_type($this->input->post('event_id',TRUE),$this->input->post('event_id_type',TRUE)),
                'action' => $this->search_type($this->input->post('action',TRUE),$this->input->post('action_type',TRUE)),
            );
            $extra_items = array(
                'id' => $this->search_type($this->input->post('event_id',TRUE),$this->input->post('event_id_type',TRUE)),
                'action' => $this->search_type($this->input->post('action',TRUE),$this->input->post('action_type',TRUE)),
                'actor' => $this->search_type($this->input->post('acting_user',TRUE),$this->input->post('acting_user_type',TRUE)),
                'target' => $this->search_type($this->input->post('target_user',TRUE),$this->input->post('target_user_type',TRUE)),
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date= $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                'event_date' => $this->check_paired_dates($start_date,$end_date),
            );

            $typesearch = array (
                'actor_id'    => array (
                    'typesql' => 'actor_type',
                    'name' => $this->search_type($this->input->post('acting_user',TRUE),$this->input->post('acting_user_type',TRUE)),
                    'type' => $this->input->post('acting_type',TRUE),
                ),
                'target_id' => array(
                    'typesql' => 'target_type',
                    'name' => $this->search_type($this->input->post('target_user',TRUE),$this->input->post('target_user_type',TRUE)),
                    'type' => $this->input->post('target_type',TRUE),
                ),
            );
            //set options for comparing
            $data['compare'] = array(
                'equals' => 'Equals',
                'contains' => 'Contains',
                'starts' => 'Starts With',
                'ends' => 'Ends With'
            );
            //get direction and if it is supported
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $order = $this->input->post('order',TRUE);
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;

            //get data
            $response = $this->reports_helper('event',$items,$between,$selector,$typesearch,$order,$dir,$this->destination_page,$export,$this->items_per_page);
            $event_list = $response['response'];
            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('event',$items,$between,$selector,$typesearch,$order,$dir,$this->destination_page,$export,$this->items_per_page);

            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
            if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
            else if(mb_strtoupper($selector['success']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Success: False'); }
            if(isset($typesearch['actor_id']['type']) && mb_strtoupper($typesearch['actor_id']['type']) == '(ALL)') array_push($selected, null);
            else { array_push($selected, 'Actor Type: '. $this->get_type($typesearch['actor_id']['type'])); }
            if(isset($typesearch['target_id']['type']) && mb_strtoupper($typesearch['target_id']['type']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Target Type: '. $this->get_type($typesearch['target_id']['type'])); }

            //For ExportPDF, PRINT
            if($is_export === 'print' || $is_export === 'pdf') {
                $response_export = $this->reports_helper('event',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($extra_items, $between, $selected, null);
            }
        }
        else { //if this is the first time you have loaded the page (ie no filters have fields)
            Event::db()->order_by('event_date', 'DESC')->limit($this->items_per_page);
            $event_list = Event::find();
            //set defaults
            $form_data = array(
                'direction' => 'DESC',
                'order' => 'event_date',
                'cur_page' => '1',
            );
            //get number of items in log
            $size = Event::count();
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            //Adhoc Report
            $between = array ("event_date" => Array("start"=>"", "end" =>""));
            $response_adhoc_sql = " id like '%' ";
            $dir = "DESC";
            $order = "event_date";
            //initiate form data for adhoc report
            $form_data['successful'] = '(ALL)';
            $form_data['event_id'] = '';
            $form_data['event_id_type'] = '';
            $form_data['action'] = '';
            $form_data['action_type'] = '';
            $form_data['target_user'] = '';
            $form_data['target_user_type'] = '';
            $form_data['acting_user'] = '';
            $form_data['acting_user_type'] = '';
            $form_data['target_type'] = '(ALL)';
            $form_data['acting_type'] = '(ALL)';
            $form_data['start_date'] = '';
            $form_data['end_date'] = '';
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
            'equals' => 'Equals',
            'contains' => 'Contains',
            'starts' => 'Starts With',
            'ends' => 'Ends With'
        );

        //pagination setup
        $this->pages->items_total = $size;
        $this->pages->current_page = $this->destination_page;
        $this->pages->paginate();
        $form_data['pagination_bar'] = $this->pages->display_pages();
        $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();

        //gets image for asc or desc
        if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
        else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }

        $form_data['num_pages'] = ceil($size/$this->items_per_page); //num of log pages
        $form_data['items_per_page'] = $this->items_per_page;
        $form_data['pages'] = $this->pages;
        $data['form_data'] = $form_data;
        $data['event_list'] = $event_list;

        //loop through both export and normal responses to report query to convert values as needed
        $lists = array($event_list, $response_export_list);
        foreach($lists as $list) {
            if(isset($list)) {
                foreach($list as $event) {
                    //converts actor and target ids into their display names
                    $value = $this->id_to_name($event->actor_type,$event->actor_id);
                    $event->actor_type=$value['type'];
                    $event->actor_id=$value['id'];
                    $value = $this->id_to_name($event->target_type,$event->target_id);
                    $event->target_type=$value['type'];
                    $event->target_id=$value['id'];
                    //changes success integer into true, false or unauth
                    if($event->success === 1) { $event->success = 'TRUE'; }
                    else if($event->success === 2){ $event->success = 'UNAUTH'; }
                    else{ $event->success = 'FALSE'; }

                    //change date into readable
                    $event->event_date = date('m/d/Y h:i:s A',$event->event_date);
                }
            }
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc_sql;
        $data['adhoc_report_type'] = "Events";
        $data['adhoc_report_destination_page'] = $this->destination_page;
        $data['adhoc_report_items_per_page'] = $this->items_per_page;
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        //if export
        if($export){
            $this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$event_list,$export_file_name,$extra_items,$between,$selected,null);
        }
        else if($export_pdf) {
            if (!empty($response_export)) {
                $data['export_event_list'] = $response_export_list;
            }
            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_events', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($response_export)){
                $data['export_event_list'] = $response_export_list;
            }
            $data['print_page'] = true;
            $form_data['page_select'] = $this->destination_page;
            $this->load->view('api/reports/events', $data);
        }
        else{
            $this->load->view('api/reports/events', $data);
        }

    }

}