<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */


// This can be removed if you use Modular Extensions
require_once APPPATH.'/libraries/REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Support extends CI_Controller
{
	public function __construct(){
		parent::__construct();
		$this->load->library(array('eventlog'));
		$this->load->model('applicationmodel');
		

	}
	
	public function save(){
		$this->load->library('form_validation');
		
		$user = User::find_from_session();
		if(!User::is_an_entity($user))
			show_404();  //tickets can only be created for users who are logged in
		
		$message = $this->input->post('support_message', TRUE);
		$type = $this->input->post('type', TRUE);
		
		$this->form_validation->set_rules('support_message','Message','required|max_length[4000]');
		
		if($this->form_validation->run() === TRUE) {
			$ticket = Ticket::create(array('user_id' => $user->id, 'message' => $message, 'category_id' => $type));
			if(Ticket::is_an_entity($ticket))
				$this->session->set_flashdata('success_message', 'Your message has been sent to the Administrators.');
			else
				$this->session->set_flashdata('error_message', 'An error occurred and your message could not be saved.  Please try again in a moment, and contact the site administrators if the problem persists.');
		}else{
			$this->session->set_flashdata('error_message',validation_errors());
			$this->session->set_flashdata('post_data_from_last_request', $this->input->post());
		}
		
		redirect('onboarding');
	}
}