<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/admin/admin_controller.php';
require_once APPPATH.'/libraries/REST_Controller.php';
require_once APPPATH.'/third_party/Paginator.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Applications extends Admin_controller{
	
	public function index() {
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$show = $this->show;
 		if(isset($show['applications']) && $show['applications']) { $this->application_list(); }
		else { redirect('onboarding'); }
	}
	
		/* -----------------------------*
	 *  APPLICATIONS TAB FUNCTIONS  *
	 * -----------------------------*/
	
	/*
	 * Application List loads the application list view for the application administrator. 
	 */
	public function application_list()
	{		
                if (isset($this->show['acct_group_maint']) && true === $this->show['acct_group_maint'] ) { 
                    redirect('onboarding');
                }
		$data['title'] = 'Direct API: Application List';
		$data['active_tab'] = array('applications'=>true);
		
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
	
		//get user id from session to get permissions
		$user_id = $this->user->id();
		$permissions = $this->account_permissions;
		//grab a list of applications the user has access to
		$app_access = $this->permissions->get_application_permission($permissions, 'admins');
		
		$data['show'] = $this->show;

		$prefix = 'active_';
		//push back the page number and items per page on the active tab from the attempt to edit and save an application
		$active_page_select_from_application_save = $this->session->flashdata('active_page_select_from_application_save');
		$active_items_per_page_from_application_save = $this->session->flashdata('active_items_per_page_from_application_save');
		if($active_page_select_from_application_save) {
			$active_destination_page = $active_page_select_from_application_save;
		}
		if($active_items_per_page_from_application_save) {
			$active_items_per_page = $active_items_per_page_from_application_save;
		}
		
		$active_pages = new Paginator($prefix);
		$active_pages->page_setup($active_bar_page, $active_jump_page, $active_items_per_page, $active_destination_page);
		
		
		$prefix = 'denied_';
		//push back the page number and items per page on the denied tab from the attempt to edit and save an application
		$denied_page_select_from_application_save = $this->session->flashdata('denied_page_select_from_application_save');
		$denied_items_per_page_from_application_save = $this->session->flashdata('denied_items_per_page_from_application_save');
		if($denied_page_select_from_application_save) {
			$denied_destination_page = $denied_page_select_from_application_save;
		}
		if($denied_items_per_page_from_application_save) {
			$denied_items_per_page = $denied_items_per_page_from_application_save;
		}
		
		$denied_pages = new Paginator($prefix);
		$denied_pages->page_setup($denied_bar_page, $denied_jump_page, $denied_items_per_page, $denied_destination_page);
			
		
		$prefix = 'pending_';
		//push back the page number and items per page on the pending tab from the attempt to edit and save an application
		$pending_page_select_from_application_save = $this->session->flashdata('pending_page_select_from_application_save');
		$pending_items_per_page_from_application_save = $this->session->flashdata('pending_items_per_page_from_application_save');
		if($pending_page_select_from_application_save) {
			$pending_destination_page = $pending_page_select_from_application_save;
		}
		if($pending_items_per_page_from_application_save) {
			$pending_items_per_page = $pending_items_per_page_from_application_save;
		}
		
		$pending_pages = new Paginator($prefix);
		$pending_pages->page_setup($pending_bar_page, $pending_jump_page, $pending_items_per_page, $pending_destination_page);
		
		if($permissions['API']['admins']) {
			
			$application_list = $this->applicationmodel->get_applications(null);
			$application_list_size = $this->applicationmodel->get_app_list_size(null);
			
			$denied_list = Application_request::find_denied();
			$denied_list_size = Application_request::count_denied();

			$pending_list = Application_request::find_pending();
			$pending_list_size = Application_request::count_pending();
		}else{
			//if you have apps that you have access too
			if (isset($app_access) && count($app_access) > 0){
				$application_list = $this->applicationmodel->get_applications($app_access);
				$application_list_size = $this->applicationmodel->get_app_list_size($app_access);
			}else{
				//if you have no app access look for applications with negative id (won't exist)
				$application_list = $this->applicationmodel->get_applications(array(-1));
				$application_list_size = $this->applicationmodel->get_app_list_size(array(-1));
			}
			$denied_list = Application_request::find_denied(array('requestor' => $user_id));
			$denied_list_size = Application_request::count_denied(array('requestor' => $user_id));
			
			$pending_list = Application_request::find_pending(array('requestor' => $user_id));
			$pending_list_size = Application_request::count_pending(array('requestor' => $user_id));
		}
		
		//the active applications list
		if ($application_list) {
			
			$data['active_list'] = $application_list->result();
			//pagination setup
			$data['active_items_per_page'] = $active_items_per_page;
			$application_list_size = $application_list_size[0]->count;
			$data['active_num_pages'] = ceil($application_list_size / $active_items_per_page);
			$data['active_cur_page'] = $active_destination_page;
			$active_pages->items_total = $application_list_size;
			$active_pages->current_page = $active_destination_page;
			$active_pages->paginate();
			$data['active_pagination_bar'] = $active_pages->display_pages();
			$data['active_items_per_page_dropdown'] = $active_pages->display_items_per_page();
			$data['active_size'] = $application_list_size;
		}
		else {
			$data['active_list'] = array();
		}
		//list of requests that have been denied
		if ($denied_list) {
			$data['denied_list'] = $denied_list;
			//pagination setup
			$data['denied_items_per_page'] = $denied_items_per_page;
			$data['denied_num_pages'] = ceil($denied_list_size / $denied_items_per_page);
			$data['denied_cur_page'] = $denied_destination_page;
			$denied_pages->items_total = $denied_list_size;
			$denied_pages->current_page = $denied_destination_page;
			$denied_pages->paginate();
			$data['denied_pagination_bar'] = $denied_pages->display_pages();
			$data['denied_items_per_page_dropdown'] = $denied_pages->display_items_per_page();
			$data['denied_size'] = $denied_list_size;
		}
		else {
			$data['denied_list'] = array();
		}
		//list of requests that are pending approval
		if ($pending_list) {
			
			$data['pending_list'] = $pending_list;
			//pagination setup
			$data['pending_items_per_page'] = $pending_items_per_page;
			$data['pending_num_pages'] = ceil($pending_list_size / $pending_items_per_page);
			$data['pending_cur_page'] = $pending_destination_page;
			$pending_pages->items_total = $pending_list_size;
			$pending_pages->current_page = $pending_destination_page;
			$pending_pages->paginate();
			$data['pending_pagination_bar'] = $pending_pages->display_pages();
			$data['pending_items_per_page_dropdown'] = $pending_pages->display_items_per_page();
			$data['pending_size'] = $pending_list_size;
		}
		else {
			$data['pending_list'] = array();
		}
		
		if(isset($_POST['prefix'])) {
			$data['anchor'] = $_POST['prefix'] . 'link';
		}
		//assign form values
		$form_values = array();
		$form_values['active_page_select'] = $active_destination_page;
		$form_values['active_items_per_page'] = $active_items_per_page;
		$form_values['pending_page_select'] = $pending_destination_page;
		$form_values['pending_items_per_page'] = $pending_items_per_page;
		$form_values['denied_page_select'] = $denied_destination_page;
		$form_values['denied_items_per_page'] = $denied_items_per_page;
		$data['form_values'] = $form_values;
		
		if($data['show']['applications']) { $this->load->view('api/application/application_list', $data); }
		else { show_error('Forbidden',403); }
	}
	
	/* 
	 * Application edit is the edit page for changing meta-data about the application. 
	 */
	public function application_edit($id = null, $active_cur_page = null, $active_items_per_page = null,
			$pending_cur_page = null, $pending_items_per_page = null, $denied_cur_page = null, $denied_items_per_page = null)
	{
		//set current page and items per page on the sub-tabs
		$data['active_cur_page'] = $active_cur_page;
		$data['active_items_per_page'] = $active_items_per_page;
		$data['pending_cur_page'] = $pending_cur_page;
		$data['pending_items_per_page'] = $pending_items_per_page;
		$data['denied_cur_page'] = $denied_cur_page;
		$data['denied_items_per_page'] = $denied_items_per_page;
		
		if(is_null($id)) { return $this->application_list(); } //if no id is set, go back to application list
		$data['title'] = 'Direct API: Application Edit';
		$data['active_tab'] = array('applications'=>true);
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['api_admins'] = $permissions['API']['admins'];
		if(!$permissions['API']['admins'] && !isset($permissions['Application'][$id]) && !$permissions['Application'][$id][LDAP_APPLICATION_ADMIN_GROUP_NAME]) 
			show_error('Forbidden',403);
			
			
		//add the validation errors
		if(!empty($this->session->flashdata('error_message'))) { 
			$data['error_message'] = $this->session->flashdata('error_message'); 
			$form_data = $this->session->flashdata('post_data_from_last_request');
		}
		
		if(!$data['show']['applications']) show_error('Forbidden',403);
		if(!isset($id) || !is_numeric($id)) show_404();
		 
		$app = $this->applicationmodel->get_application($id)->result();
		if(!$app) show_404(); //if not valid id or no result, show 404
		$data['app'] = $app = $app[0];
		
		if(empty($form_data)){
			$form_data = array();
			$form_data['app_name'] = $app->name;
			$form_data['app_url'] = $app->url;
			$form_data['app_desc'] = $app->description;
			$form_data['poc_name'] = $app->poc_name;
			$form_data['poc_email'] = $app->poc_email;
			$form_data['poc_phone'] = $app->poc_phone;	
		}
		
		$data['form_data'] = $form_data;
		$data['direct_api_permission'] = $this->applicationmodel->get_direct_api_authorization($id);
		$data['admin_api_permission'] = $this->applicationmodel->get_admin_api_authorization($id);
		$data['disclosure_api_permission'] = $this->applicationmodel->get_disclosure_api_authorization($id);
		$this->load->view('api/application/application_edit', $data);
	}	
	
	/* 
	 * Application save handles the storing of values into the database. 
	 */
	public function application_save(){
		$this->load->library('form_validation');
		
		//push back the page number and items per page from the attempt to edit an application
		$this->session->set_flashdata('active_page_select_from_application_save',$this->input->post('active_page_select_from_application_save',TRUE));
		$this->session->set_flashdata('active_items_per_page_from_application_save',$this->input->post('active_items_per_page_from_application_save',TRUE));
		$this->session->set_flashdata('pending_page_select_from_application_save',$this->input->post('pending_page_select_from_application_save',TRUE));
		$this->session->set_flashdata('pending_items_per_page_from_application_save',$this->input->post('pending_items_per_page_from_application_save',TRUE));
		$this->session->set_flashdata('denied_page_select_from_application_save',$this->input->post('denied_page_select_from_application_save',TRUE));
		$this->session->set_flashdata('denied_items_per_page_from_application_save',$this->input->post('denied_items_per_page_from_application_save',TRUE));
		
		//retrieve the application id
		$id = $this->input->post('app_id',TRUE);
		//use permissions to determine whether to allow function call at all
		$user_id = User::organization_id_from_session();
		$cur_id=$this->user->id();
		$permissions = $this->account_permissions;
		$message = '';
		if($permissions['API']['admins'] || (isset($permissions['Application'][$id]) && $permissions['Application'][$id][LDAP_APPLICATION_ADMIN_GROUP_NAME])) {
			//test if the id has been passed and if it is a valid number
			if(empty($id) || !$this->is->nonzero_unsigned_integer($id)){
				$this->session->set_flashdata('error_message', 'No application id specified. To request a new application please follow the link on the onboarding tab.'); 
				redirect('applications/list');
			}
			else {
				//retrieve the application from the database from its id
				$app_arr = $this->applicationmodel->get_application($id)->result();
				//if the application exists
				if($app_arr) {
					$app = $app_arr[0];
					$existing_name = $app->name;
					//grab the other form values that have been passed
					$name = $this->input->post('app_name',TRUE);
					$url = $this->input->post('app_url',TRUE);
					$desc = $this->input->post('app_desc',TRUE);
					$poc_name = $this->input->post('poc_name',TRUE);
					$poc_email = $this->input->post('poc_email',TRUE);
					$poc_phone = $this->input->post('poc_phone',TRUE);
					$app_request_id = $this->input->post('app_request_id',TRUE);
					$direct_api_permission = $this->input->post('direct_api_permission',TRUE);
					$admin_api_permission = $this->input->post('admin_api_permission',TRUE);
					$disclosure_api_permission = $this->input->post('disclosure_api_permission',TRUE);
					
					//set required fields for validation
					if ($existing_name === $name)
						$this->form_validation->set_rules('app_name','Application Name','required|max_length[100]');
					else
						$this->form_validation->set_rules('app_name','Application Name','required|is_unique[application.name]|max_length[100]');
					$this->form_validation->set_rules('app_url','Application URL','required|max_length[1000]');
					$this->form_validation->set_rules('app_desc','Application Description','required|max_length[4000]');
					$this->form_validation->set_rules('poc_name','POC Name','required|max_length[500]');
					$this->form_validation->set_rules('poc_email','POC Email','required|valid_email|max_length[100]');
					$this->form_validation->set_rules('poc_phone','POC Phone','required|validate_phone|max_length[20]');
					
					if($this->form_validation->run() === TRUE) {
						if($this->applicationmodel->save_application($id, $app->public_key, $app->private_key, $name, $url, $desc, $poc_name, $poc_email, $poc_phone, $app_request_id, $direct_api_permission, $admin_api_permission, $disclosure_api_permission)) {
							$message = 'Application "'.$name.'" has been saved successfully.';
							$this->eventlog->create_event( 2,$id,3 ,$cur_id, "Edit application", time(), 1);
						}
						else { 
							$error_message = 'Application "'.$name.'" failed to save.'; 
							$this->eventlog->create_event( 2,$id,3 ,$cur_id, "Edit application", time(), 0);
						}
					}
					else {
						$this->session->set_flashdata('error_message',validation_errors());
						$this->session->set_flashdata('post_data_from_last_request', $this->input->post());
						if(!empty(trim($id))){
							redirect('applications/edit/'.$id); 
						}else{
							$this->session->set_flashdata('message', 'No application id specified. To request a new application please follow the link on the onboarding tab.'); 
							redirect('applications/list'); 
						}
					}
				}
				//if no application exists in the database return to the edit screen
				else {
					$this->session->set_flashdata('error_message', 'No application exists for id '.$id.'. Please select another application to edit.'); 
					redirect('applications/list');
				}
			}
			$this->session->set_flashdata('success_message',$message);
			if(isset($error_message)) { $this->session->set_flashdata('error_message',$error_message); }
			redirect('applications/list');
			
		}
		else { show_error('Forbidden', 403); }
	}
	
	
	/*
	 * Update key regenerates the public and private keys for an application. 
	 */
	public function update_key()
	{
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$app_id = $this->input->post('app_id', TRUE);
		$user_id=$this->user->id();
		//use permissions to determine whether to allow function call at all
		if($permissions['API']['admins'] || (isset($permissions['Application'][$app_id]) && $permissions['Application'][$app_id][LDAP_APPLICATION_ADMIN_GROUP_NAME])) {
			if(!empty(trim($app_id))) {
				$this->load->model('applicationmodel');
				$name = NULL;
				$app = $this->applicationmodel->get_application($app_id);
				if($app) {
					$app_array = $app->row_array();
					$name = $app_array["name"];
					$url = $app_array['url'];
					$desc = $app_array['description'];
					$poc_name = $app_array['poc_name'];
					$poc_email = $app_array['poc_email'];
					$poc_phone = $app_array['poc_phone'];
					$request_id = $app_array['app_request_id'];

					//create new keys
					$public_exist = true;
					$private_exist = true;
					
					//while the public key exists in db generate a new one
					while ($public_exist){
						$public = hash('sha256', openssl_random_pseudo_bytes(32));
						$query = $this->applicationmodel->get_application_from_public($public);
						if ($query !== false && $query->num_rows() === 0){
							$public_exist = false;
						}
					}
					
					//while the private key exists in the db generate a new one
					while ($private_exist){
						$private = hash('sha256', openssl_random_pseudo_bytes(32));
						$query = $this->applicationmodel->get_application_from_private($private);
						if ($query !== false && $query->num_rows() === 0){
							$private_exist = false;
						}
					}

					//save values to the database
					$this->applicationmodel->save_application($app_id, $public, $private, $name, $url, $desc, $poc_name, $poc_email, $poc_phone, $request_id, null, null, null);
					$result = array('success'=>true,'message'=>'Application keys have been generated successfully for "'.$name.'".','public'=>$public,'private'=>$private,'id'=>$app_id);
					//log
					$this->eventlog->create_event( 2,$app_id,3 ,$user_id, "Updated key", time(), 1);
				
				}
				//no application exists for the id
				else {
					$this->eventlog->create_event( 2,$app_id,3 ,$user_id, "Updated key", time(), 0);
					$result = array('succes'=>false,'message'=>'No application exists for id "'.$app_id.'".');
				}
			}
			//no id was specified
			else {
				$this->eventlog->create_event( 2,$app_id,3 ,$user_id, "Updated key", time(), 0);
				$result = array('success'=>false,'message'=>'Application id is a required field.');
			}
			
			echo $this->json->encode($result); 
		}
		else {$this->eventlog->create_event( 2,$app_id,3 ,$user_id, "Updated key", time(), 2); show_error('Forbidden',403); }
	}
}
