<?PHP 
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

$defaults = array('send_automatic_replies' => 0,
				  'send_within_time_period' => 0,
				  'start_date' => '',
				  'start_time' => '',
				  'end_date' => '',
				  'end_time' => '',
				  'content' => '');
				  
foreach($defaults as $var => $default_value){
	if(!isset($$var)) $$var = $default_value;
}
	
		
$this->load->view('header/header_settings');
$this->load->view('message_modal');
echo $this->load->view('settings/_tabs.php', array(), TRUE);
?>
<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
<div class="content_settings automatic-replies">						
	<div class="settings">
	<?php if(!empty($validation_errors)): ?>
		<div class="bootstrap">
			<div class="alert alert-danger">
				<button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button>	
				<?php echo implode_nonempty('<br>', $validation_errors) ?>					
			</div>
		</div>
	<?php endif ?>

		<h2>Automatic Replies (Out of Office)</h2>
		<p>Use automatic replies to let others know that you are out of the office or not available to respond to messages.</p>
		<div class="bootstrap">
		<?php //todo - shouldn't be using the form-dialog class for forms that are not in a dialog ?>
                    <div class="form-dialog">
			<?PHP  echo form_open('/settings/automatic_replies', array('class' => 'form-horizontal')); ?>
				<div class="form-group">
					<div class="radio">
					  <label>
						<?php echo form_radio('send_automatic_replies', 0, empty($send_automatic_replies)) ?>
						Do not send automatic replies
					  </label>
					</div>
				</div>
				<div class="form-group">
					<div class="radio">
					  <label>
						<?php echo form_radio('send_automatic_replies', 1, !empty($send_automatic_replies))  ?>
						Send automatic replies
					  </label>
					</div>
				</div>
				<fieldset class="automatic-reply-fields"<?php if(empty($send_automatic_replies)): ?> style="display: none;"<?php endif ?>>
                                    <legend class="sr-only">Send Automatic Replies</legend>
					<div class="form-group">
						<div class="checkbox col-sm-offset-1">
							<label>
								<?php echo form_checkbox('send_within_time_period', 1, !empty($send_within_time_period)); ?>
								Only send automatic replies within this time period:
							</label>
						</div>
					</div>
					<div class="form-group form-inline">
						<label for="start-date" class="col-sm-2 col-md-offset-1 control-label">Start Date</label>
						<div class="col-sm-7">
							<?php echo form_input('start_date', $start_date, 'id="start-date" class="form-control date-field calendar-field" maxlength="14" size="14"'); ?>
							<label for="start-time" class="sr-only">Start Time</label>
							<?php echo form_dropdown('start_time', $time_options, $start_time, 'id="start-time" class="form-control date-field"') ?>
						</div>
					</div>
					<div class="form-group form-inline">
						<label for="end-date" class="col-sm-2 col-md-offset-1 control-label">End Date</label>
						<div class="col-sm-7">
							<?php echo form_input('end_date', $end_date, 'id="end-date" class="form-control date-field calendar-field" maxlength="14" size="14"'); ?>
							<label for="end-time" class="sr-only">End Time</label>
							<?php echo form_dropdown('end_time', $time_options, $end_time, 'id="end-time" class="form-control date-field"') ?>
						</div>
					</div>
					<div  class="form-group">
						<label for="content-field">Reply with this message:</label>
						<?php echo form_textarea('content', $content, 'id="content-field" class="form-control rich-text-editor"') ?>
					</div>
				</fieldset>
				<?php echo form_submit('save', 'Save', 'class="btn btn-default"') ?>
			<?php echo form_close() ?>
		</div>
            </div>
	</div>
</div>

			<?php echo $this->load->view("footer", array(), TRUE); ?>
		</div>
		<script>		
			$( window ).load(function(){
				
				//check all of the fields and see which ones need to be disabled
				function manageHiddenFields(){				
					if($('input[name="send_automatic_replies"]:checked').val() != '1'){
						$('.automatic-reply-fields').hide();
						return; //if send automatic replies is turned off, none of the rest of the fields matter
					}
					
					if($('.automatic-reply-fields').css('display') == 'none'){
						$('#tinyeditorframe').height(100);
						$('.automatic-reply-fields').show();
					}
					
					if($('input[name="send_within_time_period"]').is(':checked')){
						$('.date-field').prop('disabled', false);
					}else{
						$('.date-field').prop('disabled', 'true');
					}			
				}				
				
				
				//make sure that fields get disabled every time we click on a radio button or checkbox
				$('input[type="radio"], input[type="checkbox"]').click(function() {
				  manageHiddenFields();
				});
				
				manageHiddenFields();
				
				//make sure that the actual textarea gets populated from the value of the WYSIWG editor
				$('textarea.rich-text-editor').closest('form').submit(function( event ) {
					$('.rich-text-editor').val(editor.getEditorContent());
				});
				
				//add js calendars to the date fields
				$('.calendar-field').datetimepicker({ currentText: "Today",dateFormat: 'D mm/dd/yy', showTime: false,minDate: new Date(),showTimepicker: false});
				$('#start-date').find("ui-datepicker-buttonpane").removeClass("ui-priority-secondary").addClass("ui-priority-primary");
				$('.calendar-field').css({"position": "relative","z-index": 999999});
			});
		</script>		
		<script type="text/jaDNS  ipt" src="/jscripts/dpii.admin.compose.js"></script>
	</body>
</html>