<?PHP
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

if(!isset($CI)) $CI = get_instance();

//allow $feedback_message and $feedback_class to just be passed to this view.  If they aren't, default to the flashdata.
//these vars used to be called $message and $message_class respectively, but this caused naming collisions when we needed to pass Message objects to the page - seemed easiest to rename this. -- MG 2014-04-18
if(empty($feedback_message) && empty($feedback_class)){
	$feedback_message = $CI->session->flashdata('message');
	if($CI->json->is_valid($feedback_message))
		$feedback_message = $CI->json->decode($feedback_message); //for some reason, we're json-encoding this - easiest to just decode it
	$feedback_class = (!empty($CI->session->flashdata('message_class'))) ? $CI->session->flashdata('message_class') : 'info';
}
if(empty($timeout)) $timeout = 10000; //5 seconds is too short to read - upping it to ten seconds.  User can close out of message early if desired.

?>
<?PHP if(!empty($feedback_message) && is_string($feedback_message)): //If message exists (above conditions are met), shoot out the message with a timeout of 5sec. Click to close. ?>
	<script>
		var nth = noty({
			text: '<?PHP echo str_replace("'", "\'", str_replace("\n", ' ',  str_replace("\r", ' ', strip_tags($feedback_message)))); ?>',
	  		type: '<?PHP echo $feedback_class; ?>',
			timeout: <?php echo $timeout; ?>
		}); 
	</script>
<?PHP endif ?>