<?PHP
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

$CI = get_instance(); //the controller is not always available as $this, so we'll grab the controller via get_instance() instead

$theme_css = element('theme_css_name', $CI->user_theme);

?>
<!doctype html>
<html>
	<head>
		<title><?PHP echo $title;?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
		<link rel="icon" href="/favicon.ico" type="image/x-icon" />
		<link rel="stylesheet" type="text/css" href="/css/main.css" />
		<link rel="stylesheet" type="text/css" href="/css/jquery.lightbox-0.5.css" />
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui.min.css" />
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui.structure.min.css" />
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui.theme.min.css" />
		<link rel="stylesheet" type="text/css" href="/jscripts/fancybox/jquery.fancybox-1.3.4.css" media="screen" />
		<link rel="stylesheet" type="text/css" href="/css/tinyeditor.css" />
		<link rel="stylesheet" type="text/css" href="/css/token-input-dpii.css" />
		<link rel="stylesheet" href="/css/multiselect/common.css" type="text/css" />
		<link type="text/css" href="/css/multiselect/ui.multiselect.css" rel="stylesheet" />
		<link rel="stylesheet" href="/css/qtip/jquery.qtip.min.css" type="text/css" />
		<link rel="stylesheet" href="/css/qtip/jquery.qtip.css" type="text/css" />
		<link rel="stylesheet" href="/css/jquery.dropdown.css" type="text/css" />
		<link rel="stylesheet" href="/css/chosen.min.css" type="text/css" />
		<?PHP if(isset($theme_css) && strlen(trim($theme_css)) > 0) { echo '<link rel="stylesheet" type="text/css" href="/css/themes/' . $theme_css . '.css" />'; } ?>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.min.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.migrate.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.lightbox-0.5.min.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/fancybox/jquery.fancybox-1.3.4.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/fancybox/jquery.mousewheel-3.0.4.pack.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.tipTip.minified.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/libraryfunctions.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/headerfunctions.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/bootstrap-3.2.2.min.js"></script>	
		<script type="text/jaDNS  ipt" src="/jscripts/jquery-ui.min.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.jeditable.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.form.js"></script> 
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.filedrop.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.autogrow.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/tinyeditor.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/ui.multiselect.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/qtip/jquery.qtip.min.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/qtip/jquery.qtip.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/qtip/imagesloaded.pkg.min.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.dropdown.js"></script>
		<!-- View that displays jQuery message slideout whenever there is a user action performed.
			Uses jquery.noty.js library. 
			http://needim.github.com/noty/
		 -->
		<script type="text/jaDNS  ipt" src="/jscripts/noty/jquery.noty.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/noty/layouts/top.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/noty/layouts/topLeft.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/noty/layouts/topRight.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/noty/layouts/inline.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/noty/themes/default.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/noty/themes/inline.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/jquery.tokeninput.js"></script>
		<script type="text/jaDNS  ipt" src="/jscripts/chosen.jquery.min.js"></script>
                <script type="text/jaDNS  ipt" src="/jscripts/xss.js"></script>
		<!--[if lte IE 8]><script type="text/jaDNS  ipt" src="/jscripts/css3-mediaqueries.js"></script><![endif]-->
	</head>
	<body>
	
	<?php if($CI->session->userdata('is_loggedin') === 'true') { $CI->load->view('options_bar'); } ?>
	<div id="wrapper">
		<?PHP  /*make sure csrf token is on the page for AJAX requests (GET as well as POST) */
			echo form_hidden($CI->security->get_csrf_token_name(),$CI->security->get_csrf_hash(),$CI->security->get_csrf_token_name(),'token'); 
		?>
		<?PHP 
			if($CI->session->userdata('just_logged_in')) {
				if(isset($first_login_message)) echo $first_login_message;
				$CI->session->set_userdata('just_logged_in',FALSE);
			}
		?>
		<?PHP echo form_open_multipart('inbox/form_check', array('id' => 'main_form')); ?>
		<div id="header" class="inbox">
			<?PHP $CI->load->view('header/banner'); ?>
            <a style="display: block; top: 0; width: 100px; height: 100px; position: absolute; font-size: 0; line-height: 0; color: transparent;" title="Inbox" href="/inbox">Logo and Link to Inbox</a>
            <?php if($CI->session->userdata('is_loggedin') === 'true' && $CI->router->class == 'inbox'): ?>
            	<div id="version_container"><?php echo 'Version ' . APPLICATION_BUILD_VERSION;?></div>
			<div id="search">
				<?PHP echo form_label('Search Input','search_input',array('class' => 'hidden_context')); ?>
                <?PHP echo form_input(array('name' => 'search_input','id' => 'search_input', 'required'=>'required')); ?>
                <button class="minimal minimal-short" id="search_btn" name="search" type="submit" onClick="$(this).attr('clicked','true');">Search</button>
            </div>
            <?php endif ?>