<?PHP 
/**
* @package direct-project-innovation-initiative
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('header/header_admin');
	$this->load->view('message_modal');
	
	$CI = get_instance();
	if(!isset($group_notify)) $group_notify = false; //avoid notices by making sure this is set
?>
		</div>
			<?PHP $this->load->view('adminpanel/admin_nav',array('item' => 'manage_groups')); ?>
			<div id="tabs">
				<div class="tab<?php if($is_active): ?> active-tab<?php endif ?>"><a href="/adminpanel/manage_groups/">Manage Groups</a></div>
				<div class="tab long-tab <?php if(!$is_active): ?> active-tab<?php endif ?>"><a href="/adminpanel/manage_groups/removed">Manage Removed Groups</a></div>
				<?PHP if($CI->has_permission('manage_groups_create')):?><div class="tab"><a href="/adminpanel/manage_groups/create">Create Group</a></div><?PHP endif?>
			</div>
			<div id="content_wrapper" class="groups edit-group">
				<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
				<div id="content">
					<div id="manage_groups">
						<h2 class="line">
							<div class="unit size3of4">
								<?php if($is_active): ?>
									<a href="/adminpanel/manage_groups/">Manage Groups</a> 
								<?php else: ?>
									<a href="/adminpanel/manage_groups/removed/">Manage Removed Groups</a> 
								<?php endif ?>
								&#8594; <a href="<?php echo current_url() ?>"><?PHP echo $group_name; ?></a>
							</div>
							<button type="button" id="change_service_permission" class="minimal unit unit-right size1of4" onclick="jaDNS  ipt:getWebservicePermission('<?PHP echo $group_name;?>',1);">
								Change Service Permissions
							</button>
						</h2>							
					<?php if(!$management): ?>	
						<h3>This application does not have permission to change this group's information.</h3>
						<p>You can grant the application permission by clicking on the Change Service Permission button and selecting the "manage" service.</p>
					<?php else: ?>
						<?PHP echo form_open(current_url(), 'class="form-horizontal" role="form"'); ?>	
							<div class="line bootstrap">
								<div class="unit unit-right size1of4"><span class="req">*</span> indicates required field.</span></div>
								<div class="form-horizontal group-metadata unit size3of4">
								<?php foreach(array('display_name', 'description') as $field): ?>
									<div class="form-group">					
										<label for="<?php echo $field ?>" class="control-label col-sm-2"><?php echo humanize($field) ?> <span class="req">*</span></label>
										<div class="col-sm-9">
										<?php if(!empty($validation_errors[$field])): ?>
											<div class="validation_error">
												<div class="validation_error message absolute top"><a href="#"><?php echo $validation_errors[$field] ?></a></div>	
										<?php endif ?>																																	
												<input type="text" name="<?php echo $field ?>" id="<?php echo $field ?>" class="text" value="<?php echo $form_values[$field] ?>">										
											<?php if(!empty($validation_errors['display_name'])): ?></div><?php endif ?>	
										</div>																		
									</div>								
								<?php endforeach ?>
									<div class="form-group">
										<label for="facility_id" class="control-label col-sm-2">Facility <span class="req">*</span></label>
										<div class="col-sm-9">
											<?php echo form_dropdown('facility_id', 
																	 $facilities, 
																	 $form_values['facility_id'], 
																	 'id="facility_id" data-placeholder="Choose a Facility" style="width: 100%;"'); ?>
										</div>
									</div>
									<div class="checkbox form-group no-label">
										<label for="group_notify">
											<?PHP echo form_checkbox(array('name'=>'group_notify','id'=>'group_notify'), 1, (bool)$form_values['group_notify']); ?>
											Send External Notifications? 
										</label>
									</div>
									<div class="form-group no-label buttons">
										<button type="submit" name="update<?php if(!$is_active): ?>_removed<?php endif?>" class="minimal">Update Information</button>
									<?php if($is_active): ?>
										<button type="submit" name="remove" class="minimal warning" onclick="return confirm('Are you sure you wish to remove this group?');">Remove Group</button>
									<?php else: ?>
										<button type="submit" name="restore" class="minimal" onclick="confirm('Are you sure you wish to restore this group?');">Restore Group</button>									
									<?php endif ?>
									</div>
								</div>
							</div>
							<h3 class="unit size3of4"><label for="group_users">Group Members</label></h3>
							<div class="group-members line">
								<div class="unit">
									<select name="group_users" id="group_users" size="20" style="width: 305px;">
								<?PHP foreach($members as $member):
											echo '<option value="'.$member['uid'].'">' . $member['displayname'] . ' ('.$member['uid'].')'. '</option>';
										endforeach;	?>
									</select>	
								</div>
								<div class="unit">
									<button type="button" class="minimal" onclick="addUserToGroup('<?PHP echo addslashes($group_name);?>',<?php if($is_active): ?>'TRUE'<?php else: ?>'FALSE'<?php endif ?>);" >Add User</button><?php /* 2017-07-07: Myke Carter - addslashes() added to support group names having apostrophes */ ?>
									<button name="remove_user" class="minimal">Remove User</button>
								</div>
							</div>
							<?PHP echo form_hidden('management', ($management)?"TRUE":"FALSE"); ?>
							<?PHP echo form_hidden('group', $group_name); ?>
							<?PHP echo form_hidden('active', ($is_active) ? 'TRUE' : 'FALSE'); ?>
						<?PHP echo form_close(); ?>
					<?php endif ?>						
					</div>
				</div>
			</div>
			<?PHP $this->load->view("footer"); ?>
		</div>
	</body>
</html>
<script>
	$('#facility_id').ready(function(){
		$('#facility_id').chosen();
	});
</script>
