<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/** Include the parent model */

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Response_model extends CI_Model {
	
	public function check_response($id ,$mailbox){
		if(!Message::formatted_like_an_id($id)) return $this->error->should_be_a_message_id($id);
		if(!$this->is->nonempty_string($mailbox)) return $this->error->should_be_a_mailbox_name($mailbox);
		$response = first_element($this->db->select('parent_id, type')->where('message_id', $id)->limit(1)->get('response')->result_array());
		if(is_array($response)) {
			$this->post_email_flag($response['parent_id'],$response['type'],$mailbox);
		}
	}
	
	public function set_response_flag($id,$parent_id,$type){
		if(!Message::formatted_like_an_id($id)) return $this->error->should_be_a_message_id($id);
		if(!Message::formatted_like_an_id($parent_id)) return $this->error->should_be_a_message_id($parent_id);
		if(!in_array($type, array('replyall', 'reply', 'forward'))) return $this->error->should_be_a_known_flag($type);
		$data = array(
				'message_id' => $id,
				'parent_id' => $parent_id,
				'type' => $type 
		);
		//Check if already set
		$this->db->where($data);
		$response = $this->db->get('response');
		if($response->num_rows() == 0){
			$this->db->insert('response',$data);
		}
	}
	
	
	#TODO - THIS BELONGS ON THE MESSAGE CONTROLLER (OR WHICHEVER CONTROLLER WE EVENTUALLY MOVE SAVE/SEND TO)
	/** This function sets a flag for the email for reply, replyall, or forward*/
	protected function post_email_flag($id, $text, $mailbox) {
		if(!Message::formatted_like_an_id($id)) return $this->error->should_be_a_message($id);
		if(!$this->is->nonempty_string($mailbox)) return $this->error->should_be_a_mailbox_name($mailbox);
	
		if(!in_array($text, array('replyall', 'reply', 'forward'))) return $this->error->should_be_a_known_flag($text);
	
		$criteria = compact('id', 'mailbox'); //we know id and mailbox will be set - if they're not, we shouldn't waste resources on an API call that will fail.
		$criteria['part'] = 'flags'; //THIS IS NOT THE THE NORMAL WAY TO GET MESSAGES.  THERE IS NO OTHER WAY TO GET ONLY FLAGS AND NOT THE WHOLE MESSAGE.
	
		$message = element($id, $this->mailbox->messages($criteria));
		if(!Message::is_an_entity($message)) return $this->error->warning('There is no message with id '.$id.' in mailbox '.$mailbox);
	
		if($message->property_is_empty('flags')){
			$text = "\\".ucfirst($text);
		}else{
			/* NOTE - We didn't previously force messages to only have one flag for replyall/reply/forward - are we sure we want to do this?  Why do we want to wipe any record of it having been replied to/forwarded/etc?  -- MG 2014-05-15 */
			//remove old and new replyall, reply, and forward
			$unique_flags = array("replyall","reply","forward","\\Replyall","\\Reply","\\Forward");
			$text = str_replace($unique_flags, "", $message->flags)."\\".ucfirst($text);
		}
		$text = urlencode($text);
		$this->api->clear();
		$this->api->call('direct/messages/flag/set', compact('id', 'text', 'mailbox'), 'POST');
	}
}