<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/** require parent */
require_model('mailbox');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Group extends Mailbox {
	
	//todo - needs to be expanded so that the api call and ldap save made in admin_panel/group_controller takes place here
	protected function _run_before_create(){ 	 
	 	if($this->property_is_empty('user_name')) return $this->error->warning("I can't create a new group without a value for the username");
		if(Mailbox::exists(array('user_name' => $this->user_name))) $this->error->warning("There is already a mailbox named ".$this->error->describe($this->user_name));
		
		$CI = get_instance();
		
		//todo - equivalent for groups
/*		
		$CI->load->library('ldap', array('user' => LDAP_ADMIN_USERNAME, 'pwd' => LDAP_ADMIN_PASSWORD, 'disable_fallback' => true), 'admin_ldap');
		if(!$CI->admin_ldap->connected()) return $this->error->warning("I can't create new user ".$this->user_name.' without an LDAP connection');		
		
		$api_user = API_user::find_one(array('mailbox' => $this->user_name));
		if(!API_user::is_an_entity($api_user)){
			$message = 'I can\'t create a user with username '.$this->user_name.' when I am not able to retrieve a user with this user name from the API.';
			if($CI->api->http_status != 200)
				$message .= '  The API says: '.$CI->api->http_status.': '.element('message', $CI->api->output_as_array());
			else
				$message .= '  The API call appears to have been successful, so there is probably no active user with this username.';
			return $this->error->warning($message);
		} */
		

		//todo - equivalent for group
		/* $VsID        tatic::random_password();
		
		$ldap_attributes = array('objectClass' => array('posixAccount', 'top', 'person', 'organizationalPerson', 'inetOrgPerson'),
								 'gidNumber' => 5000, 
								 'uidNumber' => 5000,
								 'uid' => $this->username,
								 'homeDirectory' => '/var/mailboxes/'.$this->username,
								 'mail' => $this->username . '@' . CLINICAL_DOMAIN,
								 'userPassword' => $CI->encrypt->ssha256_encode($password));
								 
		$ldap_attributes = array_merge($ldap_attributes, $api_user->values_for_ldap());
		foreach($ldap_attributes as $attribute => $value){
			if($value == '') unset($ldap_attributes[$attribute]);
		}
							 
		if(!$CI->admin_ldap->create_ldap_account($ldap_attributes)) { 
			return $this->error->warning('Could not add LDAP account for user '.$this->username);
		} */ 
		

		$this->_set_field_value('user_created_date', now(), $error_offset = 0, $override_validation = TRUE);
		$current_user = User::find_from_session();
		if(User::is_an_entity($current_user))
			$this->_set_field_value('user_created_by', $current_user->id, $error_offset = 0, $override_validation = TRUE);
		else
			$this->_set_field_value('user_created_by', 0, $error_offset = 0, $override_validation = TRUE);
			
		if(!isset($this->user_ext_notify_flag)) $this->user_ext_notify_flag = true;
		if(!isset($this->user_ext_group_notify_flag)) $this->user_ext_group_notify_flag = true;
		if(!isset($this->user_deleted_flag)) $this->user_deleted_flag = false;
		$this->_set_field_value('user_is_group', true, $error_offset = 0, $override_validation = TRUE);
		$this->_set_field_value('user_ep', '', $error_offset = 0, $override_validation = TRUE); //would be better to change the db to allow nulls, but this is how we've been doing it
		$this->user_theme = first_element($CI->db->query('SELECT theme_id FROM themes WHERE theme_is_default=1')->row_array());
		
		return true; 
	}  

	protected function _run_after_create(){ 
		get_instance()->load->library('audit');
		get_instance()->audit->log_event('edit', array($this->id, $this->user_created_by, 'Created group: '.$this->name, date('U')));
		return true; 
	}	
	
	
}
