<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/** */
require_model('api_entity');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Facility extends API_entity {
	static $find_resource = '/admin/facilities';	


	public static function fields(){
		return array('id', 'name', 'active');  
    }	

	protected static function _results_from_api_output(){
		$output = parent::_results_from_api_output();
		if(!array_key_exists('facilities', $output)) 
			return array();
		
		$facilities = array();
		foreach($output['facilities'] as $facility){
			$facilities[$facility['id']] = $facility;
		}
		
		return $facilities;
	} 		
	
}
