<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

require_model('db_entity');

/**
* @author M. Gibbs <gibbs_margaret@bah.com>
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Contact extends DB_entity {
	static $table = 'contacts';	
	static $primary_key = 'contact_id';
	
	protected static $_relationships = array( 'user' => array( 'type' => 'belongs_to', 'key_for_relationship' => 'user_id' ));	

	public function values_for_search(){
		$values = array('type' => 'contact', 
						'cid' => $this->id,
						'displayname' => $this->last_name.', '.implode_nonempty(' ', array($this->first_name, $this->middle_name)),
						'mail' => $this->mail,
						'givenname' => $this->first_name,
						'sn' => $this->last_name,
						'initials' => $this->middle_name,
						'o' => $this->organization,
						'departmentnumber' => $this->department,
						'telephonenumber' => $this->telephone,
						'title' => $this->title);
								   
		foreach($values as $key => $value){
			if(!isset($value) || strlen($value) <= 0)
				unset($values[$key]);
		}						   
		
		return $values;
	}
	
}

