<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

require_model('db_entity');

/**
* @author B. Holt <brandon.holt@bylight.com>
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Announcement extends DB_entity {
	static $table = 'announcements';	
	static $primary_key = 'id';
	
	protected $_readonly_fields = array('updated_by', 'updated_at');
	
	protected $_property_validation_rules = array('enabled' => 'boolean',
												  'content' => 'string');
	
	protected static $_relationships = array();
	





////////////////////
// DATA MANAGEMENT
////////////////////
	
	/**
	* Sets the "updated_by" field to the current user id value.
	* Sets the "updated_at" field to the current timestamp to be stored when the site announcement is updated.
	* @return array
	*/
	protected function _values_for_save(){
		$values_for_save = parent::_values_for_save();
		
		$values_for_save['updated_by'] = User::find_from_session()->id;
		$values_for_save['updated_at'] = now();
		return $values_for_save;
	}
	
	protected function _run_after_create_and_update(){ 
		if(!$this->enabled || $this->property_is_empty('content'))
			return get_instance()->session->dismiss_banner('announcement');
	
		return get_instance()->session->display_banner('announcement', '<strong>Announcement:</strong> '.$this->content);	
	}  
	
	protected static function _run_after_delete($entity){
		return get_instance()->session->dismiss_banner('announcement');
	} 

}

