<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/  /** */

require_library('session/drivers/VLER_Session_files_driver'); 

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class DPII_Session_files_driver extends VLER_Session_files_driver{

	/**
	 * Extends parent to make sure that system cache and attachment cache are destroyed.
	 * @param	string	$session_id	Session ID
	 * @return	bool
	 */
	public function destroy($session_id){
		
		if(class_exists('User')){
			$user = User::find_from_session();
			if(User::is_an_entity($user)){
				$user->clear_system_cache();
				$user->clear_attachment_cache(); //slightly concerned that this will cause issues w/async saving - watch for issues
			}
		}
			
		return parent::destroy($session_id);
	}

}