<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
 * @package direct-project-innovation-initiative
 * @subpackage libraries
 * @todo - ASK ADAM ABOUT MAKING CONNECTION PUBLICLY ACCESSIBLE.  BETTER TO BE PRIVATE & PROVIDE ACCESSOR METHOD?
*/

class Ldap {

	public $conn;
	public $auth_error;
	private $anon;
	private $raw_conn;
	private $CI;
	
	public function __construct($credentials = array()){	

	    $this->CI =& get_instance();
		$this->error =& $this->CI->error;
		$this->is =& $this->CI->is;
		
		$VsID                       $credentials);
		$pwd = element('pwd', $credentials);
		$use_credential_fallback = !element('disable_fallback', $credentials, FALSE);
		$find_dn = TRUE;
		if($VsID        LDAP_ADMIN_USERNAME) {
            $find_dn = FALSE;
        }

		if(empty($username) || empty($pwd)){
			
			$user = User::find_from_session();
			if(!User::is_an_entity($user) && isset($this->authentication)
                && User::is_an_entity($this->authentication->user)
            ){
				$user = $this->authentication->user;
			}
			
			if(User::is_an_entity($user)){
				$VsID                       $user->ldap_credentials);
				$pwd = element('pwd', $user->ldap_credentials);
			}
		}

		// try logging in with the user account
		if(!empty($username) && $username != LDAP_SEARCH_USERNAME){
			$this->conn = $this->connect_to_ldap($username,$pwd,$find_dn);
		}
		
		// if we are not connected, try the default LDAP search user
		if(!$this->connected() && $use_credential_fallback){
			$this->conn = $this->connect_to_ldap(LDAP_SEARCH_USERNAME,LDAP_SEARCH_PASSWORD);
			if($this->conn) {
                // set a variable to indicate the connection is anonymous
				$this->anon = TRUE;
			}
		}
	}
        
        public function __destruct() {
            if($this->conn) {
                ldap_close($this->conn);
            }
        }
	
	public function authenticated() {
		return $this->connected() && !$this->anon;
	}
	
	public function connected() {
		if(!$this->conn) { return FALSE; }
		else { return TRUE; }
	}
	
	public function get_ldap_error() {
		return ldap_error($this->raw_conn);
	}
	
	public function has_ldap_error(){
		return ldap_errno($this->conn) != 0;
	}
	
	public function create_ldap_account($attributes) {
		return ldap_add($this->conn, "uid=" . $attributes["uid"] . "," . LDAP_ACCOUNTS_DN,$attributes);	
	}
	
	public function create_group($attributes) {
		$this->role_privilege_escalation('manage_groups_create');
		return ldap_add($this->conn, "ou=" . $attributes['ou'] . "," . LDAP_GROUPS_DN,$attributes);	
	}
	
	public function modify_ldap_account($uid,$attributes,$dn = NULL) {
		$this->role_privilege_escalation('manage_users');
        if(is_null($dn)) { $dn = LDAP_ACCOUNTS_DN; }
		// assumes you would like to remove attributes with no value specified
		foreach($attributes as $key => $attribute) {
			if(strlen(trim($attribute)) == 0) { 
				$attributes_to_remove[$key] = array();
                // remove blank attribute if it exists, ignore warnings when attribute doesn't exist
				$remove = @ldap_mod_del($this->conn,"uid=" . $uid . "," . $dn,$attributes_to_remove);
                // take it out of the list of attributes to update as blanks will cause the modify function to break
				unset($attributes[$key]);
			}
			$attributes_to_remove = array();
		}
		$modify = ldap_modify($this->conn, "uid=" . $uid . "," . $dn,$attributes);
		return $modify;
	}
	
	public function delete_ldap_account($uid) {
		$this->role_privilege_escalation('manage_users');
		if($this->conn) {
			$dn = 'uid='.$uid.','.LDAP_ACCOUNTS_DN;
			$sr = @ldap_search($this->conn, LDAP_BASE_DOMAIN, '(&(member='.$dn.'))', array('dn'));
			if($sr !== FALSE) {
				$info = ldap_get_entries($this->conn, $sr);
				for($i = 0; $i < $info['count']; $i++) {
					ldap_mod_del(
					    $this->conn,$info[$i]['dn'],
                        array("member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN)
                    );
				}
			}
			return ldap_rename(
			    $this->conn,
                "uid=" . $uid . "," . LDAP_ACCOUNTS_DN,
                "uid=" . $uid,LDAP_DELETED_ACCOUNTS_DN,
                TRUE
            );
		}
	}
	
	public function restore_ldap_account($uid) {
		$this->role_privilege_escalation('manage_users');
		return ldap_rename(
		    $this->conn,
            "uid=" . $uid . "," . LDAP_DELETED_ACCOUNTS_DN,
            "uid=" . $uid,LDAP_ACCOUNTS_DN,
            TRUE
        );
	}
	
	public function search(
	    $search = NULL,
        $sizelimit = NULL,
        $properties = NULL,
        $filter = NULL,
        $dn = NULL,
        $contain_all = NULL
    ) {
		if(is_null($search)) { $search = ""; }		
		if(is_null($dn)) { $dn = LDAP_ACCOUNTS_DN; }
		if(is_null($filter)) {  
			// Using Correct Filters
			if ($contain_all){
				if(is_null($properties)) {
				    $properties = array("mail","displayname","givenname","objectclass");
				}
				$filter = "(&(ObjectClass=person)(|(displayName=*" .
                    $search . "*)(mail=" . $search . "*)(givenname=" .
                    $search . "*)))";
			} else {
				if(is_null($properties)) {
				    $properties = array("mail","displayname","objectclass");
				}
				$filter="(&(ObjectClass=person)(|(displayName=" . $search . "*)(mail=" . $search . "*)))";
			}
		}

		$result_arr = array();
		if($this->conn) {
			$j = 0;
            $sr = @ldap_search($this->conn, $dn, $filter, $properties, NULL, $sizelimit);
            if($sr === FALSE) {
                get_instance()->error->warning('LDAP search failed: '.ldap_error($this->conn));
            }
            else {
                ldap_sort($this->conn, $sr, 'displayname');
                $info = ldap_get_entries($this->conn, $sr);
                for($i = $j; $i < $info["count"]; $i++) {
                    foreach($info[$i] as $key => $val) {
                        if(is_array($val) && $val['count'] == 1) {
                            $result_arr[$i][$key] = $val[0];
                        }
                        else if(is_array($val) && $val['count'] > 1) {
                            for($k = 0; $k < $val['count']; $k++) {
                                $result_arr[$i][$key][$k] = $val[$k];
                            }
                        }
                        else {
                            $result_arr[$i][$key] = $val;
                        }
                    }
                }
            }

			return $result_arr;
		}
		return false;
	}
	
	public function get_group_membership($dn) {
		if($this->conn) {
			//assume bind has already happened and we can do a search			
			$search = ldap_search($this->conn, LDAP_GROUPS_DN, '(&(member='.$dn.'))', array('ou','cn'));
			if(!is_resource($search)) return array();
			$entries = ldap_get_entries($this->conn, $search);
			$groups = array();
			foreach($entries as $entry) {
				for($i = 0; $i < $entry['ou']['count']; $i++) {
					$group = $entry['ou'][$i];
					$groups[$group] = $group;
				}
				for($i = 0; $i < $entry['cn']['count']; $i++) {
					$groups[$group] = $entry['cn'][$i];
				}
			}
			return $groups;
		}
	}
	
	public function get_admin_group_membership($dn) {
		if($this->conn) {
			//assume bind has already happened and we can do a search
			$search = ldap_search($this->conn, LDAP_ADMIN_GROUP1, "(&(member=" . $dn . "))", array("cn"));
			if(!is_resource($search)) return array();
			$entries = ldap_get_entries($this->conn, $search);
			return $entries;
		}
	}
	
	public function set_admin_group_membership($uid,$level) {
		if($this->conn) {
			if($level == 0) { 
				return ldap_mod_del(
				    $this->conn,
                    LDAP_ADMIN_GROUP1,
                    array(
                        "member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN
                    )
                );
			} else if($level == 1) {
				return ldap_mod_add(
				    $this->conn,
                    LDAP_ADMIN_GROUP1,
                    array(
                        "member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN
                    )
                );
			}
		}
	}
	
	public function add_group_membership($group,$uid,$dn = NULL) {
		$this->role_privilege_escalation('manage_groups');
		if(is_null($dn)) { $dn = LDAP_GROUPS_DN; }
		if($this->conn) {
			echo 'ou=' . $group . ','.$dn;
			return ldap_mod_add(
			    $this->conn,
                'ou='.$group .','.$dn,
                array(
                    "member" => "uid=".$uid.",".LDAP_ACCOUNTS_DN
                )
            );
		}
	}
	
	public function remove_group_membership($group,$uid,$dn = NULL) {
		$this->role_privilege_escalation('manage_groups');
		if(is_null($dn)) { $dn = LDAP_GROUPS_DN; }
		if($this->conn) {
			return ldap_mod_del(
			    $this->conn,
                'ou=' . $group . ','.$dn,
                array(
                    "member" => "uid=" . $uid . "," . LDAP_ACCOUNTS_DN
                )
            );
		}
	}
	
	public function modify_group($ou,$attributes,$dn = NULL) {
		$this->role_privilege_escalation('manage_groups');
        if(is_null($dn)) { $dn = LDAP_GROUPS_DN; }
		//assumes you would like to remove attributes with no value specified
		$attributes_to_remove = array();
		foreach($attributes as $key => $attribute) {
			if(strlen(trim($attribute)) == 0) { 
				$attributes_to_remove[$key] = array(); 
				unset($attributes[$key]);
			}
		}
		$remove = ldap_mod_del($this->conn,"ou=" . $ou . "," . $dn,$attributes_to_remove);
		$modify = ldap_modify($this->conn, "ou=" . $ou . "," . $dn,$attributes);
		return $remove && $modify;
	}
	
	public function remove_group($group) {
		$this->role_privilege_escalation('manage_groups');
		if($this->conn) {
			return ldap_rename(
			    $this->conn,
                "ou=" . $group . "," . LDAP_GROUPS_DN,
                "ou=" . $group,LDAP_DELETED_GROUPS_DN,
                TRUE
            );
		}
	}
	public function restore_group($group) {
		$this->role_privilege_escalation('manage_groups');
		if($this->conn) {
			return ldap_rename(
			    $this->conn,
                "ou=" . $group . "," . LDAP_DELETED_GROUPS_DN,
                "ou=" . $group,LDAP_GROUPS_DN,
                TRUE
            );
		}
	}

	public function get_formatted_entries($search_result_resource, $key_by = null){
		if(!is_null($key_by) && !$this->is->nonempty_string($key_by)) {
		    return $this->error->should_be_a_nonempty_string($key_by);
        }
		//if we're not given a resource, the ldap search query may have failed
		//it will have already triggered an error, so just return an empty array
		if(!is_resource($search_result_resource)) return array(); 
		
		$entries = ldap_get_entries($this->conn, $search_result_resource);
		if(!$this->is->nonzero_unsigned_integer(element('count', $entries, 0))) return array();
		
		$formatted_entries = array();
		foreach($entries as $entry){
			$entry = $this->format_entry($entry);
			if(empty($entry)) continue;
			if(!is_null($key_by)){
				if(!array_key_exists($key_by, $entry)){
					$this->error->notice(
					    'Skipping entry without a value for '.
                        $this->error->describe($key_by). ': '.
                        $this->error->describe($entry)
                    );
					continue;
				}
				$formatted_entries[$entry[$key_by]] = $entry;
			}elseif(!empty($entry)){
				$formatted_entries[] = $entry;
			}
		}
		return $formatted_entries;
	}
	
	// based on this php.net comment: http://us2.php.net/manual/en/function.ldap-get-entries.php#Hcom89508
	protected function format_entry( $entry ) {
	  $formatted_entry = array();
	  for ( $i = 0; $i < $entry['count']; $i++ ) {
		if (is_array($entry[$i])) {
		  $subtree = $entry[$i];
		  if ( ! empty($subtree['dn']) and ! isset($formatted_entry[$subtree['dn']])) {
			$formatted_entry[$subtree['dn']] = $this->format_entry($subtree);
		  }
		  else {
			$formatted_entry[] = $this->format_entry($subtree);
		  }
		}
		else {
		  $attribute = $entry[$i];
		  if ( $entry[$attribute]['count'] == 1 ) {
			$formatted_entry[$attribute] = $entry[$attribute][0];
		  } else {
			for ( $j = 0; $j < $entry[$attribute]['count']; $j++ ) {
			  $formatted_entry[$attribute][] = $entry[$attribute][$j];
			}
		  }
		}
	  }
	  return $formatted_entry;
	}
	
	protected function ldap_auth($username,$password,$find_dn = FALSE) {
		if($this->conn) {
			if($find_dn !== FALSE) {
				$ldap_bind = @ldap_bind($this->conn, LDAP_SEARCH_USERNAME, LDAP_SEARCH_PASSWORD);
				$search = @ldap_search($this->conn, LDAP_ACCOUNTS_DN, "(&(uid=" . $username . "))", array("uid","dn"));
				$entry = @ldap_get_entries($this->conn, $search);
				if($entry["count"] == 1) {
					$ldap_bind = @ldap_bind($this->conn, $entry[0]["dn"], $password); //bind with actual credentials
					if($ldap_bind) { 
						$groups = $this->get_admin_group_membership($entry[0]["dn"]);
						if($groups["count"] > 0) {
							$session_group_arr = array();
							for($i = 0; $i < $groups["count"]; $i++) {
								array_push($session_group_arr,$groups[$i]["dn"]);
							}
							$this->CI->session->set_userdata("groups",$session_group_arr);
						}
						return true; 
					}
					else { $this->auth_error = $this->get_ldap_error(); }
				}
				//return 'Invalid credentials' if the account does not exist, to keep
				//from revealing if the attempted login was for a real account or not
				else { $this->auth_error = 'Invalid credentials'; }
			}
			else { 
				$ldap_bind = @ldap_bind($this->conn, $username, $password);
				if($ldap_bind) { return true; }
				else { $this->auth_error = $this->get_ldap_error(); }
			}
		}
		return false;
	}
	
	public function ldap_escape ($str = '') {
		$metaChars = array ("\\00", "\\", "(", ")");
		$quotedMetaChars = array ();
		foreach ($metaChars as $key => $value) {
			$quotedMetaChars[$key] = '\\'. dechex (ord ($value));
		}
		$str = str_replace (
			$metaChars, $quotedMetaChars, $str
		); //replace them
		return ($str);
	}
	
	protected function win_filetime_to_timestamp($filetime) {
		$win_secs = substr($filetime,0,strlen($filetime)-7); // divide by 10 000 000 to get seconds
		$unix_timestamp = ($win_secs - 11644473600); // 1.1.1600 -> 1.1.1970 difference in seconds
		return $unix_timestamp;
	}
	
	protected function connect_to_ldap($username,$password,$find_dn = FALSE) {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
        // set raw LDAP connection, to check if the server is even listening
		$this->raw_conn = $ldap_conn;
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) {
		    return $this->error->warning(
		        'LDAP connection attempt failed for '.$username.': unable to set the LDAP protocol version'
            );
		}
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) {
		    return $this->error->warning(
		        'LDAP connection attempt failed for '.$username.': unable to set the referral option'
            );
		}
        // temporarily set the connection to the one we made so we can check if binding works
		$this->conn = $ldap_conn;
		if(!$this->ldap_auth($username, $password, $find_dn)) {
		    return $this->error->warning('LDAP connection attempt failed for '.$username.': '.$this->auth_error);
		}
		return $ldap_conn;
	}
	
	/**
	 * If the current user has the indicated permission, escalate their permissions using anonymous admin ldap user
	 * so they can perform the function.
	 */
	protected function role_privilege_escalation($permissions) {
		require_model('user');
		$user = User::find_from_session();
		
		if(User::is_an_entity($user) && !$user->is_admin()) {
			$user_entry = $user->ldap_entry();
			foreach($this->CI->role_model->user_permissions($user_entry['dn']) as $role_permission) {
				if(is_array($permissions)) { 
					foreach($permissions as $permission) {
						if($permission === $role_permission) {
							return $this->connect_to_ldap(LDAP_ADMIN_USERNAME,LDAP_ADMIN_PASSWORD);
						}
					}
				}
				else {
					if($permissions === $role_permission) {
						return $this->connect_to_ldap(LDAP_ADMIN_USERNAME,LDAP_ADMIN_PASSWORD);
					}
				}
			}
		}
		else { return $this->connected(); }
		return FALSE;
	}
}
