<?php

/**
* @package direct-project-innovation-initiative
* @subpackage core
*//** */

/**
* Extended from VLER to allow developers to skip logging 404 errors.* 	- Developers may opt to skip logging 404 errors
*
* @package direct-project-innovation-initiative
* @subpackage core
*/
class DPII_Exceptions extends VLER_Exceptions {	
	
	/**
	* Allows developers to opt to skip logging 404 errors.
	*/
	public function show_404($page = '', $log_error = TRUE){
		
		$heading = '404 Page Not Found';
		$message = 'The page you requested was not found.';
		
		if (is_cli()){
			$heading = 'Not Found';
			$message = 'The controller/method pair you requested was not found.';
		}
		
		include APPPATH . 'config/routes.php';

		// By default we log this, but allow a dev to skip it
		if ($log_error) { log_message('error', $heading.': '.$page); }
		
		if(!empty($route['404_override'])){
			$CI =& get_instance();
			$data["heading"] = "404 Page Not Found";
			$data["message"] = "The page you requested was not found.";
			
			$CI->load->view('errors/error_404',$data);
			echo $CI->output->get_output();
			exit(4);
		}
		
		$heading = "404 Page Not Found";
		$message = "The page you requested was not found.";
		echo $this->show_error($heading, $message, 'error_404', 404);
		exit(4);
	}
	

	

	
} 