<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/ /** */

require_once APPPATH.'controllers/restricted_controller.php';


/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Settings extends Restricted_controller {	
	public $help_video;
	
	public function __construct(){
		parent::__construct();
		require_library('video');
		$this->load->library('audit');
		
		try{ $this->help_video = new Video('how-to-set-up-va-direct'); } catch(Exception $e){ $this->error->warning($e->getMessage()); }
		
	}
	
	public function ajax_timezone_list($country = NULL) {
		if(!isset($country)) return; //could replace this with a 404 since country is clearly required, but that might break the js -- MG 2016-06-1
		echo $this->json->encode($this->timezone_options_for_country($country));
	}
	
	public function index(){	
		require_library('form_markup_generator/user_form_markup_generator');
		$markup_generator = new User_form_markup_generator($this->user);		
		
		if(empty($_POST) && !$markup_generator->load_saved_values() && $this->api->http_status != 200){
			$this->session->set_error_message('You have not granted this application permission to manage your account information.');
			redirect('settings/application');
			return $this->error->warning($this->user->username.' has not granted this application permission to manage account information'); //backup in case the redirect fails			
		}
		
		if(!empty($_POST)){
			$markup_generator->set_values_from_post();
			if(!$markup_generator->validates()){
				$error_message = '<strong>We need you to make a few changes to this form.</strong>&nbsp;&nbsp;'.ul_if_multiple($markup_generator->validation_messages);
			}elseif(!$markup_generator->save_values()){	
				$error_message = $this->lang->line('error_generic');
			}else{
				$success_message = '<strong>Success!</strong>&nbsp;&nbsp;Your account settings have been updated.';
				$markup_generator->load_saved_values();			
			}
		}
						
		$title = PORTAL_TITLE_PREFIX . 'Account Settings';
		$this->load->view('settings/index', compact('markup_generator','title', 'error_message', 'success_message'));
	}
	
	public function notifications(){	
		$data = $this->get_user_db_info();
			
		$data["title"] = PORTAL_TITLE_PREFIX . "User Settings";
		//pass group mailbox info if there is any
		$group_mailboxes = $this->session->userdata('group_mailboxes');
		if(is_array($group_mailboxes)) { $data['group_mailboxes'] = $group_mailboxes; }
		//pass personal mailbox hidden data
		$data['hide_personal_mailbox'] = FALSE;
		if(!is_null($this->session->userdata('hide_personal_mailbox')) && $this->session->userdata('hide_personal_mailbox') !== FALSE) { $data['hide_personal_mailbox'] = TRUE; }
		//load view
		$this->load->view("settings/notifications",$data);
	}
	
	
	public function application() {
		$title = PORTAL_TITLE_PREFIX . ' Application Settings';
		$countries = $this->locale->get_countries();
		
		if(!empty($_POST)){
			$country = $this->input->post('country', TRUE);
			$timezone = $this->input->post('timezone', TRUE);
			
			if(!array_key_exists($country, $countries) || !array_key_exists($timezone, $this->timezone_options_for_country($country))){
				unset($country, $timezone);
			}elseif($this->db->update('users', array('user_locale' => serialize(compact('country', 'timezone'))), array('user_id' => $this->user->id))){
				$this->session->set_success_message('Locale settings successfully updated.');
				redirect('settings/application');	
			}
			
			$error_message = $this->lang->line('error_generic');
		}
		
		if(!isset($country)) $country = $this->user->country;
		if(!isset($timezone)) $timezone = $this->user->timezone;
		$timezone_options = $this->timezone_options_for_country($country);
		
		$this->load->view('settings/application', compact('title', 'error_message', 'countries', 'country', 'timezone', 'timezone_options'));
	}
	
	
	public function automatic_replies(){
		require_model('automatic_reply');
		$data = array();
		
		//if the form hasn't been submitted yet, set it up
		if(empty($_POST)){		
			$reply = Automatic_reply::find_one( array('mailbox' =>$this->user->username) );
			if(Automatic_reply::is_an_entity($reply)){
				$data = array_merge($data, $reply->values(array('content', 'start_at', 'end_at')));
				$data['send_automatic_replies'] = true;
				$data['send_within_time_period'] = (!empty($data['start_at']) && !empty($data['end_at']));
			}
			
			if(empty($data['start_at']))
				$data['start_at'] = now();
			if(empty($data['end_at']))
				$data['end_at'] = strtotime('tomorrow');
				
			$data['start_date'] = date("D m/d/Y", $data['start_at']);
			
			
			//modify time to round down in half hour increments.
			$start_hour = date("H", $data['start_at']);
			$start_minutes = date("i", $data['start_at']);
			if($start_minutes < 30) { //if we're exactly at the hour, it's fine to just use that as the tmie
				$start_minutes = '00';
			}elseif($start_minutes >= 30){
				$start_minutes = '30';
			}

			$data['start_time'] = $start_hour.':'.$start_minutes;

			
			$data['end_date'] = date("D m/d/Y", $data['end_at']);
			$data['end_time'] = (empty($data['end_at'])) ? '' : date("H:i", $data['end_at']);		
		}else{ 
			//if the form has been submitted, validate and save
			
			$form_data = $this->input->post(array('send_automatic_replies', 'send_within_time_period', 'start_date', 'start_time', 'end_date', 'end_time', 'content'), TRUE);
			
			//SET UP FORM VALIDATION
			$this->form_validation->set_rules('send_automatic_replies','Automatic Replies','required|is_natural|in_list[0,1]|xss_clean');
			$this->form_validation->set_rules('send_within_time_period','Time Period', 'is_natural|greater_than[0]|less_than[2]|xss_clean');
			
			if(empty($form_data['send_automatic_replies'])){
				$form_data['content'] = ''; //diregard any value for content if we're not sending automatic replies
			}else{
				$this->form_validation->set_rules('content', 'Message Body', 'required|visible_content_required',
													array('visible_content_required' => 'The {field} is required.'));
				
				if(empty($form_data['send_within_time_period'])) {
					$form_data['start_date'] = $form_data['start_time'] = $form_data['end_date'] = $form_data['end_time'] = ''; //disregard all time values if we're not sending within a time period
				}else{
					
					$time_options = $this->options_for_time_dropdown();
					
					$this->form_validation->set_rules('start_date', 'Start Date', 'required|date_matches_format[D m/d/Y]|date_is_greater_than['.(strtotime('today') - 1).']', 
													  array('date_matches_format' => 'The {field} must be a date formatted MM/DD/YYYY.',
															'date_is_greater_than' => 'The {field} cannot be in the past.'));
															
					$this->form_validation->set_rules('start_time', 'Start Time', 'required|in_list['.implode(',', array_keys($time_options)).']', array('in_list' => 'The {field} is invalid.'));														
															
					$this->form_validation->set_rules('end_date', 'End Date', 'required|date_matches_format[D m/d/Y]|date_is_greater_than_or_equal_to['.$form_data['start_date'].']', 
													  array('date_matches_format' => 'The {field} must be a date formatted MM/DD/YYYY.',
															'date_is_greater_than_or_equal_to' => 'The Start Date must be before the {field}.')); 	
															
					$this->form_validation->set_rules('end_time', 'End Time', 'required|in_list['.implode(',', array_keys($time_options)).']', array('in_list' => 'The {field} is invalid.')); 																 			
				}
				
			}
			
			//SAVE THE DATA IF IT'S VALID	
			$data['validation_errors'] = array();
			if($this->form_validation->run() == true) {
				if(!empty($form_data['send_automatic_replies']) && !empty($form_data['send_within_time_period']) && strtotime($form_data['start_date'].' '.$form_data['start_time']) >= strtotime($form_data['end_date'].' '.$form_data['end_time'])){
					$data['validation_errors'][] = 'The End Date must be after the Start Date.';
				}else{
					require_model('automatic_reply');
					$reply = Automatic_reply::find_one( array('mailbox' => $this->user->username) );
					
					if(empty($form_data['send_automatic_replies']) && Automatic_reply::is_an_entity($reply)){
						Automatic_reply::delete($reply->id);
					}elseif(!empty($form_data['send_automatic_replies'])){
						if(!Automatic_reply::is_an_entity($reply)) $reply = new Automatic_reply();
						$reply->content = $form_data['content'];
						
						$reply->start_at = (!empty($form_data['start_date']) ? strtotime($form_data['start_date'].' '.$form_data['start_time']) : NULL);
						$reply->end_at = (!empty($form_data['end_date']) ? strtotime($form_data['end_date'].' '.$form_data['end_time']) : NULL);
			
		#TODO - WE SHOULD DISPLAYING A MESSAGE TELLING THE USER WHETHER OR NOT SAVE WAS SUCCESSFUL.					
						$success = $reply->save(); 		
					}
				
					redirect('settings/automatic_replies');
				}
			}
	
			$data = array_merge($data, $form_data);
			$data['validation_errors'] = array_merge(explode("\n", trim(validation_errors())), $data['validation_errors']);
		}
		
		$data['title'] = PORTAL_TITLE_PREFIX . ' Automatic Reply (Out of Office) Settings';		
		$data['time_options'] = $this->options_for_time_dropdown();
		$this->load->view('settings/automatic_replies',$data);
	}
	

	
	public function update_notifications() {
		$this->load->database();
		
		$this->form_validation->set_rules("ext_mail","External Email","required|callback_va_email","xss_clean");
		if($this->form_validation->run() == true) {
			$get_user_id = $this->db->query("SELECT user_id FROM users WHERE user_name=" . $this->db->escape($this->session->userdata("username")));
			if($get_user_id) { 
				if($get_user_id->num_rows() == 1) { 
					$row = $get_user_id->row_array();
					$user_id = $row["user_id"];
				}
			}
			if(isset($user_id)) {
				$ext_mail = $this->input->post("ext_mail",TRUE);
				if(array_key_exists("notify",$this->input->post(NULL,TRUE)) && array_key_exists('group_notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=1, user_ext_group_notify_flag=1 WHERE user_id=" . $this->db->escape($user_id));
				}
				else if(array_key_exists('notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=1, user_ext_group_notify_flag=0 WHERE user_id=" . $this->db->escape($user_id));
				}
				else if(array_key_exists('group_notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=0, user_ext_group_notify_flag=1 WHERE user_id=" . $this->db->escape($user_id));
				}
				else {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=0, user_ext_group_notify_flag=0 WHERE user_id=" . $this->db->escape($user_id));
				}
				
				//if we reach this point presumably it was successful
				$get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
				if($get_actor_id) {
					$actor_id_row = $get_actor_id->row_array();
					$actor_id = $actor_id_row["user_id"];
					$target_id = $actor_id;
					$this->load->library("audit");
					$this->audit->log_event("edit",array($target_id,$actor_id,"Update user information",date('U')));
				}
				$this->session->set_success_message('Settings successfully updated.');
				redirect('settings/notifications');
			}
			else {
				$this->session->set_error_message('Failed to update settings.');
				redirect('settings/notifications');
			}
		}
		else {
			$ext_mail_error = (strlen(form_error('ext_mail')) > 0) ? form_error('ext_mail') : null;
			$validation_errors = array('ext_mail'=>$ext_mail_error);
			$this->session->set_flashdata('validation_errors',$validation_errors);
			redirect('settings/notifications');
		}
	}
	
	protected function check_date($start, $end){
		$dates = array();	
		if(($st=strtotime($start)) == TRUE){ $dates['start'] = $st; }
		else{ $dates['start'] = null; }
		if(($en=strtotime($end)) == TRUE){ $dates['end'] = $en; }
		else { $dates['end'] = null; }
		return $dates;
	}
	

	
	protected function get_user_db_info() {
		$user = User::find_from_session();
		if(!User::is_an_entity($user)) return false;
		
		$data = array('ext_mail' => $user->user_mail,
					  'notify' => $user->user_ext_notify_flag,
					  'group_notify' => $user->user_ext_group_notify_flag);
		
		//pass group mailbox info if there is any
		$group_mailboxes = $this->session->userdata('group_mailboxes');
		if(is_array($group_mailboxes)) { $data['group_mailboxes'] = $group_mailboxes; }
		
		//pass personal mailbox hidden data
		$data['hide_personal_mailbox'] = FALSE;
		if(!is_null($this->session->userdata('hide_personal_mailbox')) && $this->session->userdata('hide_personal_mailbox') !== FALSE) { $data['hide_personal_mailbox'] = TRUE; }
		
		return $data;
	}
	
	protected function timezone_options_for_country($country){
		if(!$this->is->nonempty_string($country)) return $this->error->should_be_a_nonempty_string($country);
		$timezones = DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $country);
		$timezone_options = array();
		foreach($timezones as $timezone) {
			$timezone_obj = new DateTimeZone($timezone);
			$offset = $timezone_obj->getOffset(new DateTime('now', new DateTimeZone('GMT'))) / 3600;		
			$timezone_options[$timezone] = str_replace('_',' ',$timezone) . ' ' . '(GMT ' . ($offset < 0 ? $offset : '+'.$offset) . ':00) '. $this->locale->timezone_abbr_from_name($timezone);
		}
		
		uasort($timezone_options, array('Settings', 'timezone_cmp')); //sort timezone array
		
		return $timezone_options;
	}	
	
	protected function options_for_time_dropdown(){
		$time_options = array();
		
		$start = new DateTime;
		$start->setTime(0, 0, 0);
		
		$end = clone $start;
		$end->modify('+24 hour');

		while ($start <= $end) {
			$time_options[$start->format('H:i')] = $start->format('g:i a');
			$start->modify('+30 minute');
		}	
		
		return $time_options;
	}
	
	protected function timezone_cmp($a, $b) {
		$offset_a = substr($a, strpos($a, 'GMT ') + 4);
		$offset_a = substr($offset_a, 0, strpos($offset_a, ':'));
	
		$offset_b = substr($b, strpos($b, 'GMT ') + 4);
		$offset_b = substr($offset_b, 0, strpos($offset_b, ':'));
		
		if($offset_a > $offset_b) return -1; 
		if($offset_a < $offset_b) return 1; 
		
		//within an offset, show alphabetical order
		$timezones = array($a, $b);
		sort($timezones);
		if(current($timezones) == $a) return -1;
		return 1;
	}

        //2017-06-30 - Myke Carter - Apostrophe added to accommodate users with apostrophes in their names and/or external email addresses
        public function va_email($email) {
		$valid = (preg_match("/^([a-z0-9\'\+_\-]+)(\.[a-z0-9\'\+_\-]+)*@+((.*(\.va\.gov))|va\.gov)$/ix", $email)) ? TRUE : FALSE;
		
		if($valid) { return TRUE; }
		$this->form_validation->set_message('va_email', 'The %s field must contain a valid DOMAIN.EX email address.');
		return FALSE;
	}

	protected function get_facilities(){
		$facilities = array();
		$api_result = $this->api_model->webservice_call('/admin/facilities/format/json','GET');
		if($api_result->http_status === 200){
			foreach($api_result->response->facilities as $facility){
				$facilities[$facility->id] = $facility->name;
			}
		}
		return $facilities;
	}
	
}

/* End of file settings.php */
/* Location: ./application/controllers/settings.php */

?>
T