<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 

class Sandbox extends CI_Controller {
     
    // public function index() 
    // {
    // 	phpinfo();
    // }
    
    public function widget()
    {
    	$this->load->view('widget.html');
    }
    
    public function pills()
    {
    	$this->load->view('pills.html');
    }

    public function index(){
        $message_id = 2209;
        $testing = Message::find_one(array('id' => $message_id));
        prp($testing);
       
    

    }

    public function add_new_LDAP_role(){
        echo '<span style="color:green">OK</span>';
        echo '...Updating LDAP...';
        $ldap_conn = $this->prepare_ldap_conn();
        $ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
        if($ldap_bind) 
        {
            $dn = 'ou=accountgroupmaintenance,ou=roles,'.LDAP_BASE_RDN;
            
            $info['objectClass'] = "groupOfNames";
            $info['ou'] = "accountgroupmaintenance";
            $info["cn"] = "Account Group Maintenance";
            $info['member'] = LDAP_ANON_ADMIN_USERNAME;


            if(!$this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_add($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role '. $dn.' does exist!</span>';
            }
        }
        else 
        {
            echo '<span style="color:red">Error: Unable to bind to LDAP</span>';
        }
        
    }

    public function update_ldap_descriptions(){
        echo '<span style="color:green">OK</span>';
        echo '...Updating LDAP...';
        $ldap_conn = $this->prepare_ldap_conn();
        $ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
        if($ldap_bind) 
        {
            $dn = 'ou=accountgroupmaintenance,ou=roles,'.LDAP_BASE_RDN;
            
            $info['description'] = "Account Group Maintenance Description Placeholder";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }
            //////

            $dn = 'ou=facilityleader, ou=roles,'.LDAP_BASE_RDN;
            
            $info = [];
            
            $info['description'] = "1) Facility leaders are NVCC and VA Staff who are responsible for managing the facility they are assigned. Users with the facility leader role are leaders to the facility in their profile. The facility leader will have the default user role as well as access to some certain features of the Webmail. 2) A facility leader has all of the permissions as a non-administrative user.";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }

            //////

            $dn = 'ou=groupleader, ou=roles,'.LDAP_BASE_RDN;
            
            $info = [];
            
            $info['description'] = "Group leaders are NVCC and VA Staff who are responsible for managing groups to which they are assigned. Users who have been granted the group leader role are group leaders to any group they are a member of. The group leader has the default user role as well as access to some certain features of the Webmail.";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }

            //////

            $dn = LDAP_API_ADMIN_GROUP;
            
            $info = [];
            
            $info['description'] = "API Admins Description Placeholder";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }
            //////

            $dn = 'ou=admins, ou=VLER Direct API,'.LDAP_APPLICATION_GROUP;
            
            $info = [];
            
            $info['description'] = "The Direct Secure Messaging team will be the administrators and supervisors with privileges using DaaS web services. An administrative user can make any existing user a group leader or facility leader";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }

            //////

            $dn = 'ou=users, ou=VLER Direct API,'.LDAP_APPLICATION_GROUP;
            
            $info = [];
            
            $info['description'] = "A Direct Secure Messaging API Administration Panel user with PIV access.";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }

            //////

            $dn = 'ou=admins, ou=VLER Direct Webmail,'.LDAP_APPLICATION_GROUP;
            
            $info = [];
            
            $info['description'] = "Direct Secure Messaging team who will be the administrators of the system and supervisors with the ability to elevate the privileges of other users if needed. Administrative users have the permissions of all the previous users. Administrative users can assign the Group Leader and Facility Leader roles to another user.";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }

            //////

            $dn = 'ou=users, ou=VLER Direct Webmail,'.LDAP_APPLICATION_GROUP;
            
            $info = [];
            
            $info['description'] = "The non-administrative users are NVCC and VA Staff who are responsible for providing effective management of health care and benefits services to the Veterans and eligible family members in an effective and compassionate manner and have the default user role.";


            if($this->ldap_entry_exists($ldap_conn, $dn)) 
            {
                $success = ldap_modify($ldap_conn, $dn, $info);
                if($success) 
                {
                    echo '<br><span style="color:green">' . $dn . '</span>';
                    echo '<br><span style="color:green">OK</span>';
                }
                else 
                {
                    echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
                }
            }
            else 
            {
                echo '<span style="color:red">Error: LDAP role does exist!</span>';
            }
        }
        else 
        {
            echo '<span style="color:red">Error: Unable to bind to LDAP</span>';
        }
    }

    public function delete_ldap_account(){
        echo '<span style="color:green">OK</span>';
        echo '...Updating LDAP...';
        $ldap_conn = $this->prepare_ldap_conn();
        $ldap_bind = @ldap_bind($ldap_conn, LDAP_ADMIN_USERNAME, LDAP_ADMIN_PASSWORD);

        //For example, it has to be in the form the username tauser, 508Test.User2
        $user_to_delete = 'tisha.campbell';

        if($ldap_bind) 
        {
            //attempt to delete LDAP account from the API
            $dn = 'uid='.$user_to_delete.','.LDAP_ACCOUNTS_DN;
            echo '<br>';
            echo '...Deleting LDAP Webmail Account...'.$dn;
            echo '<br>';


            $success = ldap_delete($ldap_conn, $dn);
            if($success) 
            {
                echo '<br><span style="color:green">OK = SUCCESS</span>';
            }
            else 
            {
                echo '<br><span style="color:red">Error: Unable to delete LDAP account</span>';
            }

        }
        //If the bind was unsuccessfull...
        else 
        {
            echo '<span style="color:red">Error: Unable to bind/connect to LDAP</span>';
        }
    }


    public function create_ldap_entry($dn) {
        $dn = base64_decode(rawurldecode($dn));
        if(array_key_exists($dn, $this->ldap_schema)) {
            $this->_create_ldap_entry($dn);
        }
        redirect('install/ldap');
    }
    
    private function _create_ldap_entry($dn) {
        $ldap_conn = $this->prepare_ldap_conn();
        $ldap_bind = @ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD);
        if($ldap_bind) {
            ldap_add($ldap_conn, $dn, $this->ldap_schema[$dn]);
        }
        else {
        
        }
    }
    
    private function ldap_entry_exists($ldap_conn,$dn) {
        $search = @ldap_search($ldap_conn, $dn, '(objectClass=*)');
        $result = @ldap_get_entries($ldap_conn,$search);
        if($result['count'] > 0) { return TRUE; }
        return FALSE;
    }
    private function prepare_ldap_conn() {
        $ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
        if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
        if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
        return $ldap_conn;
    }




    	
    
    
}



?>