<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Auth extends CI_Controller {
	
	public function index(){		
		return $this->login();
	}

	//logs the user in
	public function login() {

		//make sure the authentication library has been loaded successfully
		if(!isset($this->authentication) || !is_a($this->authentication, 'Authentication')){
			#TODO - write to the audit log
			$title = 'An Error Has Occurred';
			$message = 'The system is currently unavailable.   Please try again in a moment and contact an administrator if the problem persists'; 
			$this->load->view('system_message',compact('title','message'));
			return;
		}	
		
		//if user is logged in already, redirect them to their inbox or wherever they were intending to go
		if(User::is_an_entity($this->authentication->user) && $this->authentication->user->is_logged_in())  
			return redirect($this->authentication->destination_after_login);
	
		
		//if ldap is not connected, we won't be able to log the user in
		$this->load->library('ldap');
		if(!$this->ldap->connected()){
			$user_ip_address = (isset($_SERVER['HTTP_X_REAL_IP'])) ? $_SERVER['HTTP_X_REAL_IP'] : $_SERVER['SERVER_ADDR'] ;
			$this->audit->log_event('login',array(session_id(),$this->authentication->user->username,$user_ip_address,date('U'),FALSE,$this->ldap->auth_error));
			$title = 'Login Error';
			$message = 'Login failed because a connection with the authentication server could not be established. Please try again in a moment and contact an administrator if the problem persists.'; 
			$this->load->view('system_message',compact('title','message'));
			return;
		}

		//if the user isn't active and with valid ldap credentials at this point, then we should assume that they are not registered or are not registered correctly
		if(!User::is_an_entity($this->authentication->user) || !$this->authentication->user->log_in()){
			redirect($this->authentication->url_for_registration_page);
			return $this->error->warning('Unable to log in '.$this->error->describe($this->authentication->user)); //backup in case the redirect doesn't work (e.g., if errors are already output to the page)
		}
	
		//if the user doesn't have a mailbox available, they don't have anywhere to go
		if(empty($this->authentication->user->mailbox_names())){
			session_destroy(); //note that as of CI 3.0, this destroys the CI session along with the PHP session
			$data = array(
				'title' => PORTAL_TITLE_PREFIX . 'Configuration Error',
				'message' => 'Your account is not configured for personal use, and you are not a member of any group accounts. Please contact an administrator to resolve the situation.',
			);
			$this->load->view('system_message',$data);
			return; //return so that we don't hit any more code in this controller
		}

		$data['title'] = PORTAL_TITLE_PREFIX . WARNING_TEXT_TITLE;
		$data['message'] = '<div id="dodwarning">'. WARNING_TEXT . '</div>' .
				'<script type="text/jaDNS  ipt">
					var item = $("#dodwarning").append(\'<div id="okbtn" style="margin:0 auto; text-align:center"><button class="minimal" id="ok_btn">OK</button></div>\');
					$("#okbtn").click(function() { document.location.href = \'' .$this->authentication->destination_after_login.'\'; });
					$("#dodwarning").css("position","absolute");
					$("#dodwarning").css("left","50%");
					$("#dodwarning").css("margin-left","-290px");
				</script>';
		$this->load->view('system_message',$data);
	}

	/**
	* Log the user out and display a message asking them to remove their CAC/PIV.
	* If they don't have their card inserted, just redirect back to the login page.
	*/
	function logout() {
		log_message('debug', 'Logging out '.$this->session->userdata('username'). ' via auth::logout');
		
		User::log_out();

		//No need for the redirects when SSOi is enabled...
		if ($this->authentication->type == 'SSO') {
			return redirect($this->authentication->url_for_logout);
		}


		//if we can still find the user's org id, their CAC or PIV card is still in the machine, so we'll suggest they remove it
		if($this->authentication->is_valid()){			
			$title = PORTAL_TITLE_PREFIX . "Logout";
			$message_class = 'error';

			if($this->authentication->type == 'CAC'){
				$message = '<p>Your session has been logged out. However, to ensure a complete logout please close ALL browser windows and remove your CAC.</p>';
			}
			else if($this->authentication->type == 'PIV'){
				$message = '<p>Your session has been logged out. However, to ensure a complete logout please close ALL browser windows and remove your PIV.</p>';
			}
			elseif ($this->authentication->type == 'SSO') {
				redirect($this->authentication->url_for_logout);
			}
			else {
				$message = '<p>Your session has been logged out. However, to ensure a complete logout please close ALL browser windows and remove your CAC or PIV.</p>';
			}
			
			$message .= '<p align="center" >If you would like to log back in, click below:</p>';
			$message .= '<div id="login_btn" style="vertical-align:center; text-align:center; "><button type="button" style="width:55px;" class="minimal" id="login_btn" name="login" aria-hidden="false">Login</button></div>';
			
//uncomment to have the logout page automatically redirect back to login for testing purposes
/*			if(is_on_local() && !IS_AJAX) $data['message'] .= '<script>$(document).ready(setTimeout(function(){window.location.href = "'.site_url('?'.$this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash()).'";}, 10000));</script>';  */
			return $this->load->view("system_message",compact('title','message_class','message'));
		}
		
		redirect(site_url('auth')); //redirect to login page
	}

}
