<?php 

require_once dirname(__FILE__) . '/../../CITestCase.php';

class Array_helper_test extends CITestCase{
	      
    public function test_flatten_array(){
	
		//First - test invalid parameters that we don't expect to work	
		$this->assertPhpError( function(){ 
			return flatten_array(); 
		}, 'No parameters provided'); 
		
		$this->assertPhpError( function(){ 
			return flatten_array(NULL); 
		}, 'Invalid parameters: Null');
		
		$this->assertPhpError( function(){
			return flatten_array(-1); 
		}, 'Invalid parameters: Scalar');
		
		$this->assertPhpError( function(){ 
			return flatten_array( (object) array('a', 'b', 'c') ); 
		}, 'Invalid Parameters: Object');
		
		$this->assertPhpError( function(){ 
			return flatten_array(array('a', 'b', 'c', 'd', 'e', 'f'), (object) array('a', 'b', 'c') ); 
		}, 'Invalid Parameters: Object as second parameter');
		
		//test an array that's already flat -  no changes should be made
		$this->assertSame(flatten_array(array('a','b','c','d','e')), array('a','b','c','d','e'), 'Flatten an array that is already flat');
		
		//test an array that has one array inside it
		$this->assertSame(flatten_array(array(array(1, 2), 3, 4, 5)), array(1, 2, 3, 4, 5), 'Flatten an array with one nested array');

		//test an array that has two arrays inside it
		$this->assertSame(flatten_array(array(array('A','B', array('C')), 'D', array('E'))), array('A','B','C','D','E'), 'Flatten an array with two nested arrays');

		//test an array that has nested arrays inside it
		$this->assertSame(flatten_array(array(array(1.1111,2.2222, array(3.3333, array(4.4444, 5.5555))))), array(1.1111, 2.2222, 3.3333, 4.4444, 5.5555), 'Flatten an array with multiple nested arrays');
		
		//test an array that has objects inside it
		$object = (object) array('a', 'b', 'c');
		$this->assertSame(flatten_array(array('a', 'b', 'c', $object, array('d', 'e'))), array('a', 'b', 'c', $object, 'd', 'e'), 'Flatten an array containing an object');			
    }
}
?>