-- ENVIRONMENT CHANGES FOR v1.9
-- Constants were changed for this release
-- VAD-2027: Two new additions to api.ini.  Local values are:
-- 	vap_uri="http://IP                /XACMLContextHandlerService/XACMLContextHandlerService?WSDL"
-- 	vap_home_community_id="2.16.840.1.113883.4.349"
-- VAD-2170 includes environment changes that everyone will need in order to support file transfers.  Instructions are in a comment on the ticket.
-- VAD-2168 includes environment changes to support the file transfer domain.  Instructions are in a comment on the ticket.
-- VAD-2251 includes instructions for changing the packet size for your SQL Server database on a comment on the ticket.  Packet size should be set to the maximum (16,383B).

--SQL FOR v1.9

--supporting VAD-2154 (Updating the "admin_account_list" Table for the new Global Contacts model)
ALTER TABLE direct.dbo.admin_contact_list
ADD modified_by bigint NULL;

ALTER TABLE direct.dbo.admin_contact_list
ADD modified_at bigint NULL;

ALTER TABLE direct.[dbo].[admin_contact_list]  
WITH CHECK ADD  CONSTRAINT [FK_modified_by_users] 
FOREIGN KEY([modified_by])
REFERENCES direct.[dbo].[users] ([user_id]);
			
ALTER TABLE direct.dbo.admin_contact_list
ALTER COLUMN sharing nDNS  ar(MAX) NULL;


--supporting VAD-2156 (large file transfers)
CREATE TABLE [mail].[dbo].[file_transfers](
	[id] [bigint] IDENTITY(1,1) NOT NULL CONSTRAINT PK_file_transfer PRIMARY KEY,
	[name] [nDNS  ar](260) NOT NULL,
	[type] [nDNS  ar](255) NOT NULL,
	[size] [bigint] NOT NULL,
	[hash] [nchar](40) NOT NULL,
	[content] [varbinary](max) NOT NULL,
	[recipient] [nDNS  ar](255) NOT NULL,
	[message_id] [bigint] NOT NULL CONSTRAINT FK_file_transfer_to_messages FOREIGN KEY references dbo.messages (id),	
	[note][nDNS  ar](max) NULL,
	[notify_on_download] [bit] NOT NULL DEFAULT 0,
	[downloaded_by] [bigint] NULL,
	[downloaded_at] [bigint] NULL,
	[created_by] [bigint] NOT NULL,
	[created_at] [bigint] NOT NULL DEFAULT DATEDIFF(s, '19700101', GETUTCDATE()), 
	[modified_by] [bigint] NOT NULL,
	[modified_at] [bigint] NOT NULL DEFAULT DATEDIFF(s, '19700101', GETUTCDATE()),
);

--supporting VAD-2172 (New database table to store shared global contacts data)
CREATE TABLE [direct].[dbo].[global_contacts_shared](
	[contact_id] [bigint] NOT NULL CONSTRAINT FK_shared_global_contacts FOREIGN KEY references dbo.admin_contact_list (contact_id),
	[user_id] [bigint] NOT NULL CONSTRAINT FK_global_contacts_shared_with_users FOREIGN KEY references dbo.users (user_id),	
	CONSTRAINT shared_global_contacts_unique UNIQUE(contact_id, user_id)
);

--supporting VAD-2229 (large file transfers via api)
ALTER TABLE [mail].[dbo].[file_transfers] ALTER COLUMN [recipient] [nDNS  ar](255) NULL;

--suporting VAD-2168 (add passcode to file tranfers)
ALTER TABLE mail.dbo.file_transfers
ADD passcode nDNS  ar(15) NULL;

ALTER TABLE mail.dbo.file_transfers
ADD downloaded_by_ip nDNS  ar(39) NULL;

-- allowing file transfer content to be deleted after it has expired
ALTER TABLE mail.dbo.file_transfers
ALTER COLUMN content [varbinary](max) NULL;

ALTER TABLE mail.dbo.file_transfers
ADD upload_progress tinyint DEFAULT 0;

UPDATE mail.dbo.file_transfers
SET upload_progress=100; -- existing file transfers are already uploaded and can be set to 100