-- SQL FOR 1.6 RELEASE
-- This SQL was prepared for the installation guide and added retroactively to this file, since we didn't start putting together migration files until v1.7.  If you run into any problems running it, shout out on Slack and let us know so that we can make the need adjustments.  After running all of the migrations files up until your version of the code, go to the /install pages for both sites to verify that you have the required database schema.

ALTER TABLE api.dbo.account_request
ADD domain nDNS  ar(253) NOT NULL DEFAULT 'dev.direct.DOMAIN.EX';

ALTER TABLE mail.dbo.mailboxes
ADD domain nDNS  ar(253) NOT NULL DEFAULT 'dev.direct.DOMAIN.EX';

USE [direct]
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[announcements]') AND type in (N'U'))
BEGIN
USE [direct]
CREATE TABLE [dbo].[announcements](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[enabled] [bit] NULL,
	[content] [nDNS  ar](1000) NULL,
	[updated_at] [bigint] NULL,
	[updated_by] [bigint] NULL,
 CONSTRAINT [PK_announcements] PRIMARY KEY NONCLUSTERED ([id] ASC) 
 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY])
 ON [PRIMARY]
END
SET ANSI_PADDING OFF
SET IDENTITY_INSERT [dbo].[announcements] ON
INSERT [dbo].[announcements] ([id], [content], [enabled], [updated_at], [updated_by]) VALUES (1,NULL,0,NULL,NULL)
SET IDENTITY_INSERT [dbo].[announcements] OFF
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_updated_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[announcements]'))
BEGIN
ALTER TABLE [dbo].[announcements]  WITH CHECK ADD  CONSTRAINT [FK_updated_by_users] FOREIGN KEY([updated_by])
REFERENCES [dbo].[users] ([user_id])
END



USE [mail]
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[automatic_replies]') AND type in (N'U'))
BEGIN
CREATE TABLE mail.dbo.automatic_replies(
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[mailbox_id] [bigint] NOT NULL,
	[start_at] [bigint] NULL,
	[end_at] [bigint] NULL,
	[content] [nDNS  ar](max) NOT NULL,
	[updated_at] [bigint] NULL,
	CONSTRAINT [PK_automatic_replies] PRIMARY KEY NONCLUSTERED ([id] ASC)
	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
	UNIQUE([mailbox_id]),
	CONSTRAINT [FK_automatic_replies_mailbox] FOREIGN KEY([mailbox_id])
		REFERENCES mail.dbo.mailboxes(id) ON DELETE CASCADE)
END


USE [mail]
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[automatic_reply_log](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[automatic_reply_id] [bigint] NOT NULL,
	[email_address] [nDNS  ar](max) NOT NULL,
	[sent_at] [bigint] NULL,
 CONSTRAINT [PK_automatic_reply_tracker] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
ALTER TABLE [dbo].[automatic_reply_log]  WITH CHECK ADD  CONSTRAINT [FK_automatic_reply_tracker_automatic_replies] FOREIGN KEY([automatic_reply_id])
REFERENCES [dbo].[automatic_replies] ([id])
ON DELETE CASCADE
ALTER TABLE [dbo].[automatic_reply_log] CHECK CONSTRAINT [FK_automatic_reply_tracker_automatic_replies]



DELETE FROM [nhindconfig].[dbo].[mailet_properties] WHERE name = 'mailet.domain';
INSERT INTO [nhindconfig].[dbo].[mailet_properties] (name, value) VALUES ('mailet.domain','dev.direct.DOMAIN.EX,patient.dev.direct.DOMAIN.EX');



TTTT