<?php
/**
* @package icarus
* @subpackage partials-lister
*/

#$lister->CI->load->restore_default_view_path();	//necessary whenever we're in a view in a non-standard location that calls on other views (BUT NOT AFTER CI 2.1.2)


$items = $lister->items_for_page();

$rows = array();
foreach($items as $item){
	$row = array();
	foreach($lister->columns as $column){
		$row[$column] = $lister->markup_for_table_column($column, $item);
	}
	$rows[] = $row;
}

$column_labels = array();
foreach($lister->columns as $column){
	$column_labels[$column] = $lister->markup_for_table_column_label($column);
}

$template = array( 'table_open' => '<table class="lister-table table table-bordered table-hover" cellpadding="2" cellspacing="2" border="0">',
                   'row_alt_start' => '<tr class="even">',
                   'heading_cell_start'  => '', //we're adding the th ourselves so that we can add attributes
                   'heading_cell_end'    => '', 
									);

if(empty($items)){
	echo '<p>No '.plural($lister->model->model_alias()).' have been created yet.</p>';
}
else{
	foreach($column_labels as $field => &$markup){
		$attributes = array('id' => str_replace('_', '-', $field).'-lister-table-column');
		if($field == array_first_key($column_labels))
			$attributes['class'] = 'first-column';
		elseif($field == array_last_key($column_labels))
			$attributes['class'] = 'last-column';
		$markup = open_tag('th', $attributes).$markup.'</th>';
	}	
	$lister->CI->load->library('table');
	$lister->CI->table->set_heading($column_labels);
	$lister->CI->table->set_template($template);
	echo $lister->CI->table->generate($rows); 
	$lister->CI->table->clear();
}


?>
