<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @package vler
 * @subpackage libraries
 */

require_library('authentication');

/**
 * @package vler
 * @subpackage libraries
 */ 
class SSO_authentication extends Authentication {
	protected $type = 'SSO';
	protected $_traits_info; //array of user information from the SSOi HTTP headers - see traits_info()	
	protected $organization_id_field_name; //the database field that corresponds to the user's organization id
	protected $email_address_field_name;  //the database field that corresponds to the user's email address
	protected $_url_for_logout = SSO_LOGOUT_PAGE;

	/**
	* Finds an array of information about the user based on the SSOi HTTP headers.
	*
	* Since the headers include the entirety of the HTTP headers sent back, we'll only * pull the values needed
	*
	*
	* @return array 
	*/
	protected function traits_info(){
		if(!isset($this->_traits_info)){
			$this->_traits_info = elements(array('HTTP_FIRSTNAME','HTTP_LASTNAME','HTTP_VAUID','HTTP_ADEMAIL'), $_SERVER);
		}
		return $this->_traits_info;
	}

	protected function email(){
		return element('HTTP_ADEMAIL', $this->traits_info);
	}

	protected function given_name(){
		return element('HTTP_FIRSTNAME', $this->traits_info);
	}

	protected function family_name(){
		return element('HTTP_LASTNAME', $this->traits_info);	
	}

	//TODO - Check with SSOi team if there are dedicated SSOi headers for this value 
	protected function middle_name(){
		return '';
	}

	//TODO - Check with SSOi team if there are dedicated SSOi headers for this value
	protected function suffix(){
		return '';
	}

	/**
	* The user's VAUID, if it can be determined and authenticated.
	* @return string|null
	*/
	function organization_id(){
		if(!isset($this->_organization_id) && !empty($this->traits_info())){
			
			$org_id = element('HTTP_VAUID', $this->traits_info);
	
			//VAUIDs are always numeric, so make sure that we didn't end up with the wrong thing
			if(is_numeric($org_id))
				$this->_organization_id = $org_id;
			else
				$this->error->warning('Attempted to identify VAUID via SSO HTTP Headers, but found '.$this->error->describe($org_id));			
			
		}
		return $this->_organization_id;
	}

	/**
	* The user corresponding to the current credentials.
	* Note that this user may or may not be authorized to use the site.  This just identifies the user based on the organization id (VA UID for SSO)
	* @return User
	*/
	protected function user(){
		if(empty($this->organization_id_field_name)) return $this->error->warning('I can\'t find the user when SSO_authentication::$organization_id_field_name has not been defined by the child class');
		
		//attempt to identify user based on organization id
		if(!isset($this->_user) && !$this->property_is_empty('organization_id')){
			$user = User::find_one(array($this->organization_id_field_name => $this->organization_id));			
			if(User::is_an_entity($user)){
				$this->_user = $user;
			}
		}

		//attempt to identify the user based on the email address since theres a chance that the VAUID hasn't been set for an existing Direct account
		if(!isset($this->_user) && !$this->property_is_empty('email')){
			$user = User::find_one(array($this->email_address_field_name => $this->email));			
			if(User::is_an_entity($user)){
				//TODO - Place this in a seprate method
				$user->user_va_uid = $this->organization_id;
				if (!$user->save()){
					return $this->error->warning('I can\'t save the user when i attempt to save the VAUID for an existing Direct account user.'. $this->error->describe($user));
				}
				$this->_user = $user;
			}
		}

		return $this->_user;
	}


}

?>