<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_library('attachments/XDM_attachment');

/**
 * Class XDM_attachment
 * Any changes to this library need to be made in both Webmail and the API.
 * @package vler
 * @subpackage libraries
 */
class XDM_attachment extends Zip_Attachment{

	/**
	* Checks the content of a file and casts it as the appropriate child class.
	* @param string Name of the file
	* @param string Content of the file
	* @param array Any additional metadata, formatted array('message_id' => $message_id, 'directory' => $directory)
	* @return XDM_attachment
	*/
	public static function create($name, $binary_string, $more_values = array()){
	    if ( !isset($more_values['is_xdm']) ) {
            if (!static::matches_file($name, $binary_string)) {
                return get_instance()->error->should_be_an_x('name of a ' . humanize(get_called_class()) . ' file', $name);
            }
        }
        $values = array(
            'name' => $name,
            'binary_string' => $binary_string,
        );
        $values = array_merge($values, $more_values);
		return new XDM_attachment($values);
	}

	/**
	* True if the given file can be cast as an instance of this class.
	* @param string Name of the file
	* @param string Content of the file
	* @return boolean
	*/
	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return XDM_SCORE_NOT_XDM;
		$tmp_file = tmpfile();
		$metadata = stream_get_meta_data($tmp_file);
		$tmp_filename = $metadata['uri'];
		fwrite($tmp_file, $binary_string);
		$validation_score = self::validate($tmp_filename);
		return $validation_score;
	}

    /**
     * @param $zipFile
     * @return bool
     */
	private static function validate($zipFile) {
		$zip = new ZipArchive;
		if ( $zip->open($zipFile) === false ) {
			return XDM_SCORE_NOT_XDM;
		}

		// no files to validate? that is bad.
		if ( $zip->numFiles == 0 ) {
			return XDM_SCORE_NOT_XDM;
		}

		// Step 1: Find the index file.
        $xdmIndex = null;
		for ( $i = 0; $i < $zip->numFiles; $i++ ) {
			$zipObject = $zip->statIndex($i);
			if ( false !== stripos($zipObject['name'], 'INDEX.') ) {
				$xdmIndex = $zip->getFromIndex($i);
			}
		}
		if (!$xdmIndex) {
                return XDM_SCORE_NOT_XDM;
        }

		// Step 2: validate each link found in index
        $docs_to_validate = array();
        if ( !preg_match_all('/href=["\'](.*?)["\']/', $xdmIndex, $links) ) {
            // no links found in the index
            return XDM_SCORE_INVALID;
        }
        if ( empty($links[1]) ) {
            // another check. this may catch issues with the regexp capturing
            return XDM_SCORE_INVALID;
        }
        foreach ($links[1] as $doc ) {
            if ( preg_match('/\/$/', $doc) ) {
                // Ignore directories
                continue;
            }
            $docs_to_validate []= $doc;
        }

		if ( empty($docs_to_validate) ) {
			return XDM_SCORE_INVALID;
		}

		// Then, for each document, check the file size to validate
		foreach( $docs_to_validate as $doc ) {
			$zipDoc = $zip->statName($doc);
			if ( false !== stripos($zipDoc['name'], $doc) ) {
				if ( $zipDoc['size'] <= 0 ) {
					// document is there. but, it appears to be empty. odd.
					return XDM_SCORE_INVALID;
				}
			} else {
				// document not founds. uh oh.
				return XDM_SCORE_INVALID;
			}
		}

		$zip->close();
		// If nothing failed, then we consider this a valid file
		return XDM_SCORE_VALID;
	}
}
