<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/

class Text_attachment extends Attachment{
	/**
	* There are cases where an invalid XML can still be rendered in preview.
	* So, we have the XML extension here for those cases.
	*/
	protected static $extensions = array('txt', 'css', 'html', 'htm', 'xml');

	protected $_use_lightbox_preview = true;

	public function download(){
		header('Content-Type: text/plain');
		header('Content-Disposition: attachment; filename="' . $this->name . '"');
		header('Content-Transfer-Encoding: binary');
		echo $this->binary_string;
	}

	public function view(){
		header('Content-Type: text/plain');
		header('Content-Disposition: inline; filename="' . $this->name . '"');
		echo nl2br($this->binary_string);
	}

///////////////////////
// PROTECTED FUNCTIONS
///////////////////////

///////////////////////
// STATIC FUNCTIONS
///////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(!static::matches_file($name, $binary_string)) {
		    return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
        }
        $values = array(
            'name' => $name,
            'binary_string' => $binary_string,
        );
        $values = array_merge($values, $more_values);
		return new Text_attachment($values);
	}

	public static function matches_file($name, $binary_string){
		return parent::matches_file($name, $binary_string);
	}

}
