<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
* @todo replace Message:: calls with something that checks for the model message class name first.
*/

class PDF_attachment extends Attachment{
    protected static $extensions = array('pdf');
	static $pdf_viewer_path = 'jscripts/pdfjs/web/viewer.html';
	protected $_use_lightbox_preview = false;	
	
	public function download(){
		header('Content-Type: application/download');
		header('Content-Disposition: attachment; filename="' . $this->name . '"');
		header('Content-Transfer-Encoding: binary');
		echo $this->binary_string;
	}
	
	public function url_for_download_as_pdf() {
		return $this->url_for_preview();
	}
	
	public function view(){
		header('Content-Type: application/pdf');
		header('Content-Disposition: inline; filename="' . $this->name . '"');
		echo $this->binary_string;
	}
	
	public function view_inline(){
		header('Content-type: application/pdf');
		header('Content-Disposition: inline; filename="' . $this->name . '"');
		header('Content-Transfer-Encoding: binary');
		header('Content-Length: ' . $this->bytes);
		header('Accept-Ranges: bytes');
		echo $this->binary_string;
	}

	//method for providing the "base url" needed to preview pdfs within pdf.js
	public function url_for_preview(){	
		if(!$this->use_pdf_preview) return $this->url_for_view();
		if(Message::formatted_like_an_id($this->message_id)){
			return site_url(static::$pdf_viewer_path) . "?file=" .
                rawurlencode(
                    site_url(
                        'inbox/message/' . $this->message_id .
                        '/attachments/view/inline/' . rawurlencode($this->name)
                    )
                );
	    }

		return site_url(static::$pdf_viewer_path) . "?file=" .
            rawurlencode(
                site_url(
                    'inbox/compose/draft/attachments/view/inline/' .
                    rawurlencode($this->name)
                )
            );
	}
	
	public function use_pdf_preview(){	
		return static::pdf_viewer_is_available();
	}		

////////////////////////
// PROTECTED FUNCTIONS
////////////////////////

	protected function _attributes_for_link($attributes = array()){		
		$attributes = parent::_attributes_for_link($attributes);
		if(!$this->use_lightbox_preview && !$this->use_pdf_preview){
			$attributes = merge_attributes($attributes, array('target' => '_blank'));
		}

		return $attributes;
	}

/////////////////////
// STATIC FUNCTIONS
/////////////////////

	// This static function checks if the if the users browser name is listed in the "approved browsers" array and if the the browser number is greater than or equal to the string provided in the function.
	// If the browser and version is eevualted within this function the attachment will not be previewed. - BH 01-05-2015
	public static function pdf_viewer_is_available(){

		//make sure that the viewer tool itself exists
		$pdf_viewer_path = strip_from_end('application/', APPPATH).static::$pdf_viewer_path;
		if(!file_exists($pdf_viewer_path)) return false;

		//make sure that the browser is compatible with the viewer tool
		$CI = get_instance();
		if(!$CI->agent->is_browser()) return false; //we can't detect the browser, so assume it's not compatible

		$browser = $CI->agent->browser();
		$browser_version = $CI->agent->version();

		if(!in_array($browser, array('Internet Explorer','Firefox','Chrome','Safari'))) 
			return false;

		if($browser == 'Internet Explorer' && $browser_version >='9')
			return true;
		elseif($browser == 'Firefox' && $browser_version >='6')
			return true;
		elseif($browser == 'Chrome' && $browser_version >='24')
			return true;
		elseif($browser == 'Safari' && $browser_version >='534')//agent class for Safari returns the "webkit version number"
			return true;

		return false; //if we make it here, we have a compatible browser but an incompatible version
	}	
	
	//workaround because Fortify doesn't like us calling $class::$variable, but for some reason $class::variable() works
	public static function pdf_viewer_path (){
		return static::$pdf_viewer_path;
	}

	public static function create($name, $binary_string, $more_values = array()){
		if(!static::matches_file($name, $binary_string)) {
		    return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()), $name);
        }
        $class = get_called_class();
        $values = array(
            'name' => $name,
            'binary_string' => $binary_string,
        );
        $values = array_merge($values, $more_values);
		return new $class($values);
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		return in_array(strtolower(pathinfo($name, PATHINFO_EXTENSION)), static::$extensions);
	}
	
}
