<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/

class CCDA_attachment extends Patient_document_attachment{
	protected $_schema = 'CCDA';
	
#TODO - THIS SHOULD HAVE ITS OWN PARSER CLASS	
	protected static $_parser_class = 'CCDA';											 
												 
////////////////////
// GETTERS
////////////////////
	
	function xsl_path(){
		if(!isset($this->_xsl_path)){
			$xml = new DOMDocument; //load xml
			$xml->loadXml($this->binary_string);
			//get template ids to check document type
			$template_ids = $xml->getElementsByTagName('templateId');
			//loop through template ids and find which oids are present
			foreach($template_ids as $id) {
				switch($id->getAttribute('root')) {
					//C32
					case '2.16.840.1.113883.3.88.11.32.1':
						$this->_xsl_path = 'views/xsl/cda2detail.xsl';
						break;
					//US Realm Code template, all C-CDAs must at LEAST have this per MU2
					case '2.16.840.1.113883.10.20.22.1.1':
						$this->_xsl_path = 'views/xsl/CCDA.xsl';
						break;
					//C-CDA document template
					case '2.16.840.1.113883.10.20.22.1.2':
						$this->_xsl_path = 'views/xsl/CCDA.xsl';
						break;
					//another type of C-CDA document template
					case '2.16.840.1.113883.10.20.22.1.2.2':
						$this->_xsl_path = 'views/xsl/CCDA.xsl';
						break;
					default:
						break;
				}
			}
		}
		return $this->_xsl_path;
	}

//////////////////////
// SETTERS
//////////////////////
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	/**
	* True if the given file is a CCDA file.
	*
	* @param string Name of the file 
	* @param string Contents of the file
	* @return boolean
	*/
	public static function matches_file($name, $binary_string){
		$extension = strtolower(pathinfo($name, PATHINFO_EXTENSION));
		if($extension != 'xml' || empty($binary_string) || !validates_as('xml_string', $binary_string)) return false;
		return validates_as('ccda_xml_string', $binary_string);
	}
	
}
