<?php
/**
* @package vler
* @subpackage libraries
*/

require_libraries('Object', 'form_markup_generator/Field_markup_generator');
load_helpers('array');

//deprecated to improve performance
/**
* Get the path to a field markup generator.
* Will return the correct path to any application-specific extensions.
* @deprecated
* @param string Field markup generator type.
*/
/*function field_markup_generator_path($type, $extension_directory=NULL){
	if(!validates_as('nonempty_string', $type)) return should_be('nonempty_string', $type);
	if(!is_null($extension_directory) && !validates_as('directory_path', $extension_directory)) return should_be('directory path', $directory_path);
	
	if(function_exists('require_library')){ //if we're in CI, use the loader to make sure we get any extensions
		return require_library('form_markup_generator/field_markup_generators/'.$type);
	}
	
	$form_markup_generator = new Form_markup_generator();
	if(!is_null($extension_directory))
		$form_markup_generator->extension_directory = $extension_directory;
	return $form_markup_generator->path_for_field_type($type);
} */

/**
* @package vler
* @subpackage libraries
*/
class Form_markup_generator extends Object{	
	/**
	* @var string Model class name (or default alias -- whatever you need to be able to access it via the controller)
	*/
	protected $_model_class; //if this is set, each field for this form will be considered to be from this model
	protected $_fields = array(); //$name => Field_markup_generator	
	
	//note that this has been deprecated for now in interest of perfDNS   e, and previously supported functionality for it may not work. //MG - 2016-05-04
	protected $_extension_directory; //add a setter to make sure that this is a real directory
	
	protected $_use_grid; 
	protected $_width_class; //a non-semantic class used to determine width - for example, using bootstrap this might be col-xs-6
	protected $_label_width_class; //a non-semantic class used to determine width - for example, using bootstrap this might be col-xs-6
	
	protected $_property_validation_rules= array(	'extension_directory' => 'directory_path', 'use_grid' => 'boolean', 'width_class' => 'nonempty_string',
													'label_width_class' => 'nonempty_string');			
	
	public $path_for_field_types = array();
	
	function __construct($fields = array(), $other_vars_to_set = array()){
		parent::__construct($other_vars_to_set);
		$this->is = $this->validator;
		if(!is_null($fields)){
			$this->fields = $fields;
		}
	}
	
	function label_width_class(){
		if(!isset($this->_label_width_class)){
			$this->_label_width_class = 'col-sm-4 col-md-3 col-lg-2';
		}
		return $this->_label_width_class;
	}
	
	function longest_inline_label_length(){
		$length = 0;
		foreach($this->_fields as $field){
			if(!$field->inline) continue;
			$label_length = mb_strlen($field->label_text);
			if($label_length > $length)
				$length = $label_length;
		}
		return $length;
	}
	
	function validates(){
		if(empty($this->_fields)) return $this->error->warning("I can't validate a form that has no fields.");
		$form_validates = true;
		foreach($this->_fields as $field){
			$form_validates = ($field->validates() && $form_validates);
		}
		return $form_validates;
	}
	
	function validation_messages(){
		$messages = array();
		foreach($this->_fields as $field){
			$message = $field->validation_messages();
			if(!empty($message)) $messages[] = $message;
		}
		return $messages;
	}
	
	function width_class(){
		if(!isset($this->_width_class) && !$this->property_is_empty('label_width_class')){
			$classes = explode(' ', $this->label_width_class);
			foreach($classes as $key => $class){
				$last_dash = strrpos($class, '-');
				$classes[$key] = substr($class, 0, $last_dash).'-'.(12 - (int)substr($class, $last_dash + 1));
			}
			
			$this->_width_class = implode(' ', $classes);
		}
		return $this->_width_class;
	}	
	
///////////////////////////
// GETTERS FOR CLASS VARS
////////////////////////////
	
	function extension_directory(){
		if(!isset($this->_extension_directory)){
			if(defined('CI_VERSION') && defined('VLERPATH') && file_exists(VLERPATH.'libraries/form_markup_generator'))
				$this->_extension_directory = VLERPATH.'libraries/form_markup_generator/';
			elseif(defined('CI_VERSION') && defined('APPPATH') && file_exists(APPPATH.'libraries/form_markup_generator')) 
				$this->_extension_directory = APPPATH.'libraries/form_markup_generator/';
		}
		
		return $this->_extension_directory;
	}

		
///////////////////////////
// SETTERS FOR CLASS VARS
///////////////////////////
	
	/**
	* Setter for {@link _model_class}.
	* @param string $model_name
	*/
	function set_model_class($model_name){
		if(!$this->is->model_class($model_name)) return $this->error->property_value_should_be_a_model_class_name('model_class', $this, $model_name);
		$this->_model_class = $model_name;
		if(!$this->property_is_empty('fields')){
			foreach($this->field_names as $name){
				$this->set_field_property($name, 'model_class', $this->model_class);
			}
		}
	}
	

	/**
	* Setter for {@link _fields}.
	* The parameter should be an array in which the keys are the field names and the values are either the field type or
	* an array containing the field type and additional field configuration options.
	* @param array $fields
	*/
	function set_fields($fields){
		if(!is_array($fields)) return $this->error->property_value_should_be_an_array('fields', $this, $fields);
		foreach($fields as $name => $type_or_values){
			$this->set_field($name, $type_or_values);
		}		
	}
	
/////////////////////////////////////
/// FIELD FUNCTIONS
/////////////////////////////////////	
	
	/**
	* Create a field markup generator and store it in {@_fields}.
	* @param name Name of the field (ie, the "name" HTML attribute of the form field tag.)
	* @param string|array Either the type of field markup generator, or an array that contains the type & other values for the field markup generator.
	*/
	function set_field($name, $type_or_values){			
		if(!$this->is->nonempty_string($name)) return $this->error->should_be_a_nonempty_string($name);
		if(!$this->is_a_valid_field_type($type_or_values) && !is_array($type_or_values))
			return should_be('a valid form field type or an array for the '.$name.' field', $type_or_values);

		$type = $type_or_values;
		$values = array();
		if(is_array($type_or_values)){
			$type = element('type', $type_or_values);
			$values = $type_or_values;
			unset($values['type']);
		}

		$field_markup_file = $this->path_for_field_type($type);
		if(empty($this->path_for_field_type($type)))
			return $this->error->should_be_a_valid_form_field_type($type);
		
		$extension_directory = $this->extension_directory;
		$width_class = $this->width_class;
		$label_width_class = $this->label_width_class;

 		$properties_to_pass_on = array('model_class', 'extension_directory');
		if($this->use_grid)
			array_push($properties_to_pass_on, 'width_class', 'label_width_class');
		
		foreach($properties_to_pass_on as $property){
				if(isset($this->$property) && !array_key_exists($property, $values)){
					if(method_exists(get_class($this), $property))
						$values[$property] = $this->$property();
					else
						$values[$property] = $this->$property;
				}
				if(array_key_exists($property, $values) && $values[$property] == null) unset($values[$property]);
		}

		require_once($field_markup_file);
		$class = ucfirst($type).'_markup_generator';
		$field_markup_generator = new $class($name, $values);
		$this->_fields[$name] = &$field_markup_generator; 
	}
	
	/**
	* Set the value for multiple fields at once.
	* Ideal for loading values into the form from $_POST or a db array.
	*
	* @uses set_field_property
	*
	* @param array The keys should be the field names, the values should be the field values.
	*/
	function set_values($values){
		if(!is_array($values)) return $this->error->should_be_an_array($values);
		$success = true;
		foreach($values as $field_name => $value){
			$success = $this->set_field_property($field_name, 'value', $value) && $success;
		}
		return $success;
	}
	
	/**
	* @return boolean
	*/
	function set_values_from_post(){	
		//for most values, we just need to figure out which fields from this markup generator are currently in POST and set them
		$values_from_post = array_intersect_key($_POST, $this->_fields);
		$success = $this->set_values($values_from_post);
		
		//field names with '[' in them won't show up correctly from the easy code above, so we'll handle them seperately
		foreach(array_diff($this->field_names(), array_keys($_POST)) as $field_name){
			if(!string_contains('[', $field_name)) continue;  //if a field doesn't have a ']', it wasn't in POST because it wasn't submitted
			
			//our field name is an actual string "field[subfield][any-number-of-subfields]" - take it apart so that we can figure out all the array keys that we need to grab		
			$pieces = explode('[', $field_name);
			$pieces = array_map('strip_from_end', array_fill(0, count($pieces), ']'), $pieces);
			
			//drill down to the level indicated by the field name - this is turning "field[subfield][any-number-of-subfields]" into $_POST['field']['subfield']['any-number-of-subfields']
			$value = $_POST;
			foreach($pieces as $piece)
				$value = element($piece, $value);
			
			$success = $this->set_field_property($field_name, 'value', $value) && $success;
		}		
		
		return $success;
	}
	
	function set_required_fields($field_names){
		if(!is_array($field_names)) return $this->error->should_be_an_array_of_field_names($field_names);
		foreach($field_names as $field_name){
			$this->set_field_property($field_name, 'required', true);
		}
	}
	
	/**
	* Sets a property on the markup generator for a given field of this form.
	* @param string The name of the form field (as listed in {@link _fields}
	* @param string The name of the property to set.
	* @param mixed The value of the property.
	* @return bool
	*/
	function set_field_property($field_name, $property, $value){
		if(!$this->field_exists($field_name)) return $this->error->should_be_the_name_of_an_existing_field($field_name);
		$this->_fields[$field_name]->$property = $value;
		return true;
	}
	
	function markup($fields = null){
		return implode("\n", $this->markup_for_fields($fields));
	}
	
	function markup_for_fields($fields = null){
		if(is_null($fields)) $fields = $this->field_names();
		if(!is_array($fields)) return $this->error->should_be_an_array_of_field_names($name);
		
		$markup = array();
		foreach($fields as $field_name){
			$markup[$field_name] = $this->_fields[$field_name]->markup();
		}
		
		return $markup;
	}
	
	function markup_for_field($name){
		if(!$this->field_exists($name)) return $this->error->should_be_the_name_of_an_existing_field($name);
		return $this->_fields[$name]->markup();
	}
	
	function &field($name, $offset=0){
		if(!$this->is->nonempty_string($name) || !$this->is->string_with_no_whitespace($name))
			return $this->error->should_be_a_nonempty_string_with_no_spaces($name, $offset+1);
		if(!array_key_exists($name, $this->_fields))	
			return $this->error->warning('There is no field named '.$name, $offset+1);
		
		return $this->_fields[$name];
	}
	
	/** 
	* @return boolean
	*/
	function field_exists($name){
		return array_key_exists($name, $this->_fields) && is_a($this->_fields[$name], 'Field_markup_generator');
	}
	
	function value($field_name, $offset=0){
		if(!$this->field_exists($field_name)) return $this->error->should_be_an_existing_form_field_name($field_name, $offset+1);
		return $this->_fields[$field_name]->value;
	}
	
	function values($just_these_names = null, $offset=0){
		if(is_null($just_these_names)) $just_these_names = $this->field_names();
		if(!is_array($just_these_names)) return $this->error->should_be_null_or_an_array_of_field_names($just_these_names, $offset+1);

		$values = array();
		foreach($just_these_names as $field_name){
			$values[$field_name] = $this->value($field_name, $offset+1);
		}
		return $values;
	}
		
	//field types used in this particular forms
	function field_types(){
		$types = array();
		foreach($this->_fields as $field){
			if(!in_array($field->type, $types))
				$types[] = $field->type;
		}
		return $types;
	}
	
	/**
	* Names of all the fields currently loaded into this field.
	* @return array
	*/
	function field_names(){
		return array_keys($this->_fields);
	}
	
	function field_names_for_markup(){
		$names_for_markup = array();
		foreach($this->_fields as $name => $field){
			$names_for_markup[$name] = $field->name_for_markup();
		}
		return $names_for_markup;
	}
	
	function fields_for_model($model_class=null){
		if(is_null($model_class) && !$this->property_is_empty('model_class')) $model_class = $this->model_class;
		if(!$this->is->model_class($model_class)) return $this->error->should_be_a_model_class($model_class);
		$fields_for_model = array();
		foreach($this->_fields as $field_name => $field){
			if(!$field->property_is_empty('model_class') && $field->model_class == $model_class)
				$fields_for_model[$field_name] = $field;
		}
		return $fields_for_model;
	}
	
	function field_names_for_model($model_class=null){
		return array_keys($this->fields_for_model);
	}
	

	function is_a_valid_field_type($type){
		return (bool)@$this->path_for_field_type($type);
	}
	
	function path_for_field_type($type){		
		if(!$this->is->nonempty_string($type)) return $this->error->should_be_a_field_type($type);

		if(empty($this->path_for_field_types[$type])){
			require APPPATH.'config/form_markup_generator.php';
			if(!is_array($field_types) || empty($field_types)) return $this->error->warning('No form field types have been configured');
			if(!in_array($type, $field_types)) return $this->error->should_be_a_valid_form_field_type($type);
		
			$this->path_for_field_types[$type] = require_library('form_markup_generator/field_markup_generators/'.$type);
		}

		return $this->path_for_field_types[$type];
	}
		
/////////
// OTHER FUNCTIONS
/////////
	function jaDNS  ipt_for_form(){
		if(in_array('rich_text_area', $this->field_types()) || in_array('tiny_rich_text_area', $this->field_types())){
			if(!file_exists('resources/js/ckeditor/ckeditor.js'))
				$this->error->warning("Ckeditor does not appear to be in the resources/js directory.  This means that rich text areas probably won't work.");
			
			return js_source_tag('resources/js/ckeditor/ckeditor.js');
		}
	}

	
}