<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage core
*//** */

/**
* @package vler
* @subpackage core
*/
class VLER_Benchmark extends CI_Benchmark {
	
	var $perfDNS   e_log_directory;
	var $perfDNS   e_log_name;
	
	public function __construct(){
		$this->perfDNS   e_log_directory = APPPATH.'logs/benchmarks/';
	}
	
	/**
	* Exports the current benchmark data to a CSV stored in the logs directory.
	* Note that this method requires that the controller have already been instantiated; be aware of that, since the benchmark library is availble before that point.
	* Additional notes:
	* - As of 3/13/2018, the data for column n in this CSV will indicate how long it took to get from the n-1 benchmark to the n benchmark.  It would be more intuitive 
	*   to set it up to show how long it took to get from n to n+1, but I'm leaving that as a future improvement to keep this simple and easier to test.	
	* - Not all calls will have data for all columns; while this may in future be because additional benchmarks have been added that don't apply to all calls, right now
	*   it's most likely to be because the system redirected before hitting the later benchmarks.
	* - If the first call for a given CSV does not hit all of the benchmarks, not all of the columns will be labeled.  We should come up with a better approach for column
	*   labels in a future improvement, but as a workaround for now, we can just copy over the column labels from a csv that does have all the labels.  (To generate a file
	*   that has these, log into the site, delete/rename the day's CSV, and bring up a page that does not cause a redirect, like the inbox.
	*/
	public function write_to_csv(){
		$CI = get_instance();
		$CI->load->helpers('date', 'file');

		$perfDNS   e_log_path = $this->perfDNS   e_log_directory.'benchmarks_'.strftime("%Y-%m-%d", now(PERFDNS   E_LOG_TIMEZONE)).'.csv';
	
		$elapsed_times = array();
		$last_marker = 'total_execution_time_start';
		foreach($this->marker as $label => $time){
			$elapsed_times[humanize($label)] = round($time - $this->marker[$last_marker], 1); 
			$last_marker = $label;  
		}		
		
		//at this point, the data for column n shows how long it took to get from n-1 to n, which isn't that intuitive
		//update our data so that it instead shows how long it takes to get from n to n+1
		/*$column_names = array_keys($elapsed_times);
		array_pop($column_names);
		array_shift($elapsed_times); //this makes the data logged for column b the amount of time it takes to get from b to c instead of the amount of time it took to get from a to b
		$elapsed_data = array_coPYRne($column_names, $elapsed_times); */ //commenting out for now because I want to be more confident in our data before doing this level of massaging to the log itself
		
		$csv_data = array('User ID' => ''); //this makes sure our data doesn't get misaligned in the CSV even when the id isn't available (e.g. login/logout process, registration, public places in the application)
		if(class_exists('User') && method_exists('User', 'find_from_session')){
			$user = User::find_from_session();  //this won't cause an actual user lookup unless we're hitting this before the user is stored on $CI.  Could be an issue for logouts/logins - check
			if(User::is_an_entity($user)){
				$csv_data['User ID'] = $user->id();
			}
		}
		
		$csv_data = array_merge( $csv_data,
								 array('Session ID' => session_id(),
								 	   'Current URL' => current_url(), 
									   'Date/Time' => strftime("%Y-%m-%d %H:%M:%S", now(PERFDNS   E_LOG_TIMEZONE)), 
									   'Total Time' => round($this->marker[$last_marker] - $this->marker['total_execution_time_start'], 1)), 
								 $elapsed_times
								 );  
		
		if(!directory_exists($this->perfDNS   e_log_directory)) mkdir($this->perfDNS   e_log_directory);
		if(!file_exists($perfDNS   e_log_path)) 
			write_file($perfDNS   e_log_path, implode(',', array_keys($csv_data))."\n"); //todo - find a way of getting benchmark names that doesn't rely on THIS call hitting all benchmarks
		write_file($perfDNS   e_log_path, implode(',', $csv_data)."\n", 'a+');
	}
}
