/*jslint devel: true, white: true, debug: true, nomen: true*/

//define namespaces for this file
var daas = daas || {}; //define a namespace for our js
var $ = $ || console.error('Jquery is not available for this script');

daas = (function() { 
	"use strict";
	
	return {
		_init: function(){
			//call on the _init method for any object inside of dpii.compose that has one
			for(var property in this){
				if(!this.hasOwnProperty(property) || property == '_init') 
					continue;
				if(typeof this[property] === 'object'){
					this[property].parent = this;
					if(this[property].hasOwnProperty('_init')){
						this[property]._init();
					}
				}
			}  
		},
	};
})();

///////////////////////////////////
// CSRF
///////////////////////////////////

daas.csrf = (function() { 
	var tokenIdentifier = 'input[name="dpii_api_token"]';
	
	return {
		name: function(){ 
			return $(tokenIdentifier).attr('name'); 
		},
		
		value: function(){
			return $(tokenIdentifier).val(); 
		},
		
		queryString: function(){
			return '?' + this.name() + '=' + this.value(); 
		},
		
		update: function(value){
			return $(tokenIdentifier).val(value);
		
		}
	};   
})();

///////////////////////////////////
// FILE TRANSFERS
// This should probably be moved to its own file once we have some more js in this file
///////////////////////////////////

daas.fileTransfers = (function() {
	var updateInProgress = false;
	
	return {
		
		formMeetsHtmlValidation: function(){
			var valid = true;
			$('input[required]').each(function(i, el){
				if(valid && $(el).val()=='' ) valid = false; 
			});
			return valid;
		},
		
		//the progress from the progressBar - for the progress of the file, see uploadProgress
		currentProgress: function(){
			return  parseInt($('.progress-bar').first().attr('aria-valuenow'));
		},
		
		file: function(){
			return $('#file-to-transfer-field').get(0).files[0];
		},
		
		maxProgress: 95, //max progress value to show to the user, in case we're guesstimating progress using time elapsed
		
		progressIncrement: function(){ 
			return 100 / (this.file().size/this.progressIncrementInBytes()); 
		},  
		
		progressIncrementInBytes: function(){ 
			return  parseInt($('#progress-increment-field').val()); 
		},
		
		
		setProgress: function(percent){
			var progressBar =  $('.progress-bar').first();
			$(progressBar).css('width', percent + '%');
			$(progressBar).attr('aria-valuenow', percent);
			$('.progress-container .percent').text(percent + '%');
		},
		
		showSaveNotice: function(){
			$('#file-transfer-save-notice').modal({backdrop: 'static', keyboard: false});
			
			var numberOfIncrements = Math.ceil(this.file().size/this.progressIncrementInBytes()); //how many db queries will it take to save this file?
			
			if(numberOfIncrements > 1){
				this.maxProgress = this.progressIncrement();
				if(this.maxProgress > 99)
					this.maxProgress = 99;
				
				//every thirty seconds, do a lookup of the actual progress
				this.updateProgressInterval = setInterval(function(){
					this.updateProgress();
				}.bind(this), 30000); 
			}
			
			//while we're waiting for actual progress, show as much progress as we can
			this.interval = setInterval(function() {
				var nextProgress = this.currentProgress() + 1;
				if(nextProgress < this.maxProgress)
					this.setProgress(nextProgress);
				
			}.bind(this), numberOfIncrements * 1000); 			
		},		
		
		updateProgress: function(){
			if(updateInProgress){
				return;
			}
			
			$.ajax({ 
				async: false,
				url: '/file_transfer/ajax_upload_progress/' + btoa(this.file().name) + this.parent.csrf.queryString(),
				beforeSend: function(jqxhr){
					updateInProgress = true;
				},
				success: function(data) {
					try{data = $.parseJSON(text); } catch(e){ data = {upload_progress: this.current_progress };}
					
					//once a minute, check for the actual progress
					if(data.upload_progress >= this.currentProgress()){
						this.setProgress(data.upload_progress);
						this.maxProgress += this.progressIncrement();
					}
					
					if(this.maxProgress > 99)
						this.maxProgress = 99;
				}.bind(this),
				error:  function(data){
					console.error('Unable to look up upload progress for file ' + this.file().name + '.  Progress for this upload will be estimated based on time elapsed.');
					this.maxProgress = 99;
					clearInterval(this.updateProgressInterval); //stop trying to look this up if we get an error
				}.bind(this),
				complete: function(xhr){
					updateInProgress = false;
				},		
			});
		},	
			
		
		_init: function(){
			$('.controller-file-transfer.action-upload form').submit(function(){
				if(!this.formMeetsHtmlValidation())
					return false;
				
				this.showSaveNotice();
				
				return true;
			}.bind(this));				
		},
	};   
})();

////////////////////////////////////////////////////////////////////////////////////////////////////////////
// PATIENT DISCLOSURES
// This needs to be available whenever we're using the patient disclosures form markup generator field type
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
daas.patientDisclosures = (function() {	
	return {
		addRow: function(rowToClone){
			if(event.preventDefault) event.preventDefault(); else event.returnValue = false;
			var newRow = rowToClone.clone();
			var patientNumber = rowToClone.closest('table').find('tr').length;
			newRow.find(':text').val('');
			newRow.find('.has-error').removeClass('has-error');
			newRow.find('th:first').text(patientNumber);
			newRow.find('[name]').each(function(){
				$(this).attr('name', $(this).attr('name').replace(/patient-\d*/g, 'patient-' + patientNumber));
			});
			newRow.find('label[title]').each(function(){
				$(this).text($(this).text().replace(/Patient #\d*/g, 'Patient #' + patientNumber));
			});
			newRow.find('label[title]').each(function(){
				$(this).attr('title', $(this).attr('title').replace(/Patient #\d*/g, 'Patient #' + patientNumber));
			});
			rowToClone.after(newRow);
			rowToClone.find('a.btn').remove();
		},
	};   
})();