<?PHP 
/**
* @package direct-as-a-service
* @subpackage views
*/

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
	$this->load->helper('form');
	$count = 0;
?>
				<h1>Authorized Application List</h1>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div class="message">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>
							<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/user_settings/application_list">Authorized Application List</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/user_settings/account_edit">Account</a></li>
							<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
						</ul>
						<div class="tab-content" id="active">
							<p>This table lists the authorized applications.</p>
							
							<?php if (sizeof($active_list) == 0) { ?>
								<div class="message">You currently have no active applications.</div>
							<?php }else{ ?>
								<br/>
								<table id="application_table" class="display">
									<caption class="hidden_context">Authorized Applications</caption>									
									<thead>
										<tr class="gridheader">
											<th width="90%" scope="col">Name</th>
											<th width="10%" scope="col">Action</th>											
										</tr>
									</thead>
									<?php $count = 0; foreach($active_list as $app){ ?>
										<tr>
											<td>
												<a href="/user_settings/webservice_access_edit/null/<?php echo $app->id; ?>/"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
													<?PHP echo form_hidden('app_id',$app->id,'app_id'.$count); ?>
													<div class="center">
														<a href="/user_settings/webservice_access_edit/null/<?php echo $app->id; ?>/" title="Edit Web Service Access: <?php echo $app->name; ?>"><img src="/images/icons/application_edit.png" alt="Edit Application: <?php echo $app->name; ?>" /></a>
													</div>
											</td>
										</tr>
									<?php $count++; } ?>
								</table>
							<?php } ?>
						</div>
						
						
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
			<script type='text/jaDNS  ipt'>
				$(document).ready(function() {
					$('#application_table').dataTable({
						"fnDrawCallback": function(oSettings) {
							if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
								$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
								$(oSettings.nTableWrapper).find('.dataTables_length').hide();
							}
						},
						"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
						"bSort" : false,
						//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
						"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1]},
						                 { 'bSearchable': false, 'aTargets': [1]},
						                 { "sClass": "center", 'aTargets': [1]}],
						//set default sorting to Last Modified 2nd column, ascending
						//"aaSorting": [[0,"asc"]],
						//"bPaginate": false,
						//set search box text
						"oLanguage": {
							"sSearch": "Find Application: ",
							"sEmptyTable":    "No applications were found",
							"sZeroRecords":   "No applications were found",
							"sInfo": "_TOTAL_ results",
							"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
								if(iTotal == 1) { return iTotal + " result"; }
								return iTotal + " results";
							},
							"sLengthMenu": "Records per page _MENU_",
							"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
						}
					});
				});
			</script>
		</div>
	</body>
</html>
