<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header');
	$this->load->view('api/nav');
	$this->load->helper('form');
?>
<script>
	var which_report = 'tickets';
	$(function() {
		$('[id^=details-modal]').dialog({ autoOpen: false })
		$('[id^=details-link]').click(function(e){
			e.preventDefault();
			var id = $(e.target).attr('id').replace('details-link','');
			$('[id^=details-modal]').dialog({
				modal:true,
				width:460,
				height:500
			});
			$('[id=details-modal'+id+']').dialog('open');
		});

		$('[id^=details-modal]').on('click', '#close_pop_up', function(){
			$(this).closest('[id^=details-modal]').dialog('close');
		});
	});
</script>
				<h1>Reports</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<?php echo $tabs;?>
						</ul>
					<div class="tab-content">
						<p>This report shows the submitted support tickets.</p>
						<?PHP $this->load->view('api/reports/adhoc_Reports/adhoc_report_info'); ?>
						<?PHP echo form_open('/reports/tickets',array('id'=>'reports_form','onsubmit'=>"jaDNS  ipt:submitPaginationForm('', 1, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form" role="presentation">
								<tr class="form_row">
									<td><label for="ticket_category">Category:</label></td>
									<td>
										<select class="fill_row" id="ticket_category" name="ticket_category" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<?php foreach($categories as $cat){ ?>
											<option value="<?php echo $cat->id;?>" <?php if (isset($form_data['ticket_category']) && $cat->id==$form_data['ticket_category']){echo "selected";}?>><?php echo $cat->category;?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="ticket_id">ID:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="ticket_id_help">Table ID of Tickets</p>
										<input class="ttFocus" aria-describedby="ticket_id_help" title="Table ID of Tickets" id="ticket_id" name="ticket_id" type="text" value="<?php if(isset($form_data['ticket_id'])) { echo htmlentities($form_data['ticket_id']); } ?>" onkeydown = "if(event.keyCode == 13){$('#ticket_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="ticket_id_type" class="hidden_context">Compare options for ID</label>
										<select id="ticket_id_type" name="ticket_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_id_type']) && $key == $form_data['ticket_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td><label for="ticket_parent">Parent:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="ticket_parent_help">The ID of the parent ticket</p>
										<input class="ttFocus" aria-describedby="ticket_parent_help" title="The ID of the parent ticket" id="ticket_parent" name="ticket_parent" type="text" value="<?php if(isset($form_data['ticket_parent'])) { echo htmlentities($form_data['ticket_parent']); } ?>" onkeydown="if(event.keyCode == 13){$('#ticket_parent').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="ticket_parent_type" class="hidden_context">Compare options for Parent</label>
										<select id="ticket_parent_type" name="ticket_parent_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_parent_type']) && $key == $form_data['ticket_parent_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="ticket_user">User:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="ticket_user_help">The user who submitted the support ticket</p>
										<input class="ttFocus" aria-describedby="ticket_user_help" title="The user who submitted the support ticket" id="ticket_user" name="ticket_user" type="text" value="<?php if(isset($form_data['ticket_user'])) { echo htmlentities($form_data['ticket_user']); } ?>" onkeydown="if(event.keyCode == 13){$('#ticket_user').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="ticket_user_type" class="hidden_context">Compare options for User</label>
										<select id="ticket_user_type" name="ticket_user_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_user_type']) && $key==$form_data['ticket_user_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td><label for="ticket_message">Message:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="ticket_message_help">The content of the support ticket</p>
										<input class="ttFocus" aria-describedby="ticket_message_help" title="The content of the support ticket" id="ticket_message" name="ticket_message" type="text" value="<?php if(isset($form_data['ticket_message'])) { echo htmlentities($form_data['ticket_message']); } ?>" onkeydown="if(event.keyCode == 13){$('#ticket_message').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="ticket_message_type" class="hidden_context">Compare options for Message</label>
										<select id="ticket_message_type" name = "ticket_message_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['ticket_message_type']) && $key == $form_data['ticket_message_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="open_start_date">Start Open Date:</label></td>
									<td><input type="text" id="open_start_date" name="open_start_date" class="date" value="<?php if(isset($form_data['open_start_date'])) { echo htmlentities($form_data['open_start_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#open_start_date').onfocus=function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('open_start_date', 'open_end_date', 'End Open Date cannot be before Start Open Date.');"/></td>
									<td>&nbsp;</td>
									<td><label for="open_end_date">End Open Date:</label></td>
									<td><input type="text" id="open_end_date" name="open_end_date" class="date" value="<?php if(isset($form_data['open_end_date'])) { echo htmlentities($form_data['open_end_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#open_end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('open_start_date', 'open_end_date', 'End Open Date cannot be before Start Open Date.');"/></td>
								</tr>
								<tr class="form_row">
									<td><label for="close_start_date">Start Close Date:</label></td>
									<td><input type="text" id="close_start_date" name="close_start_date" class="date" value="<?php if(isset($form_data['close_start_date'])) { echo htmlentities($form_data['close_start_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#close_start_date').onfocus=function(){this.form.submit();return false;}}"  onchange="checkBeforeAfterDates('close_start_date', 'close_end_date', 'End Close Date cannot be before Start Close Date.');"/></td>
									<td>&nbsp;</td>
									<td><label for="close_end_date">End Close Date:</label></td>
									<td><input type="text" id="close_end_date" name="close_end_date" class="date" value="<?php if(isset($form_data['close_end_date'])) { echo htmlentities($form_data['close_end_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#close_end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('close_start_date', 'close_end_date', 'End Close Date cannot be before Start Close Date.');"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt", timeSuffix: ' '+timezone_abbr});</script>
							</table>
							<?PHP
								$export_file_name = 'Ticket Report';
								if (isset($form_data['report_name'])){
									$export_file_name = $form_data['report_name'];
								}
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'export_pdf' => '0',
									'print_page' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
									'export_file_name' => $export_file_name,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="details-link" name="details-link" type="submit" value="Save Report"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<div id="date_error_message" class="message_error" style="display: none;"></div>
							<?php if (sizeof($ticket_list) == 0) { ?>
								<div class="message">There are currently no submitted support tickets.</div>
							<?php }
							    {
								if(!empty($form_data['date_warning_message'])) { ?>
								<div class="message"><?php echo $form_data['date_warning_message']; ?></div>
								<?PHP } ?>
								<?php if(sizeof($ticket_list) > 0) { ?>
									<div class="pagination">
										<?php echo $form_data['pages']->display_result_num();?>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
										<?php echo $form_data['pages']->display_items_per_page('top');?>
										<div class="pagination-options">
											<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
												<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP }
											else { ?>
												<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } ?>
											<a id="export_pdf_top" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
											<a href="#"  onclick="printByElementId('result_div');"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
											<label for="page_select_top" class="hidden_context">Page Selector</label>
											<input id="page_select_top" class="page_selector_input" name="page_select" onchange="jaDNS  ipt:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
											<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
										</div>
									</div>
								<?php } ?>
							<?php } ?>
						<?PHP echo form_close(); ?>
						<a name="reportContent" id="reportContent" class="hidden_context hidden_link">Report Content</a>
						<?PHP echo form_open('/reports/tickets',array('id'=>'clear_form')); ?><?PHP echo form_close();
							  if(sizeof($ticket_list) > 0) {
								$this->load->view('api/reports/result_tables/result_tickets');
						?>
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page('bottom');?>
								<div class="pagination-options">
									<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
										<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP }
									else { ?>
										<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } ?>
									<a id="export_pdf_top" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
									<a href="#"  onclick="printByElementId('result_div');"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
									<label for="page_select_bottom" class="hidden_context">Page Selector</label>
									<input id="page_select_bottom" class="page_selector_input" name="page_select" onchange="jaDNS  ipt:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							<?php } ?>
						</div>
						<div id="details-modal" title="Save Current Report">
								<div class="adhoc_report">
									<?PHP
										$this->load->view('api/reports/adhoc_reports/adhoc_tickets');
									?>
								</div>
						</div>
					</div>
				</div>
			</div>
			<?php $this->load->view('api/reports/result_tables/file_downloading_window');?>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>