<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header');
	$this->load->view('api/nav');
	$this->load->helper('form');

?>
<script>
	var which_report = 'requests';
	$(function() {
		$('[id^=details-modal]').dialog({ autoOpen: false })
		$('[id^=details-link]').click(function(e){
			e.preventDefault();
			var id = $(e.target).attr('id').replace('details-link','');
			$('[id^=details-modal]').dialog({
				modal:true,
				width:460,
				height:500
			});
			$('[id=details-modal'+id+']').dialog('open');
		});

		$('[id^=details-modal]').on('click', '#close_pop_up', function(){
			$(this).closest('[id^=details-modal]').dialog('close');
		});
	});
</script>
				<h1>Requests</h1>
				<div class = "column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<?php echo $tabs;?>
						</ul>
					<div class="tab-content">
						<p>This table lists the requests.</p>
						<?PHP $this->load->view('api/reports/adhoc_Reports/adhoc_report_info'); ?>
						<?PHP echo form_open('/reports/requests',array('id'=>'reports_form','class'=>'fileDownloadForm','onsubmit'=>"jaDNS  ipt:submitPaginationForm('', 1, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form" role="presentation">
								<tr class="form_row">
									<td><label for="whichapp">Application:</label></td>
									<td>
										<select class="fill_row" id="whichapp" name="whichapp" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<?php foreach($apps as $app){ ?>
											<option value="<?php echo $app->id;?>" <?php if (isset($form_data['whichapp']) && $app->id==$form_data['whichapp']){echo "selected";}?>><?php echo $app->name;?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="request_id">ID:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="request_id_help">Table ID of request</p>
										<input class="ttFocus" aria-describedby="request_id_help" title="Table ID of request" id="request_id" name="request_id" type="text" value="<?php if(isset($form_data['request_id'])) { echo htmlentities($form_data['request_id']); } ?>" onkeydown="if(event.keyCode == 13){$('#request_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="request_id_type" class="hidden_context">Compare options for ID</label>
										<select id="request_id_type" name="request_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_id_type']) && $key == $form_data['request_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>

									<td><label for="request_call">Call:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="request_call_help">The API service being called by the application</p>
										<input class="ttFocus" aria-describedby="request_call_help" title="The API service being called by the application" id="request_call" name="request_call" type="text" value="<?php if(isset($form_data['request_call'])) { echo htmlentities($form_data['request_call']); } ?>" onkeydown="if(event.keyCode == 13){$('#request_call').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="request_call_type" class="hidden_context">Compare options for Call</label>
										<select id="request_call_type" name="request_call_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_call_type']) && $key == $form_data['request_call_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="request_code">Response Code:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="request_code_help">HTTP response code that denotes the success or error of the request</p>
										<input class="ttFocus" aria-describedby="request_code_help" title="HTTP response code that denotes the success or error of the request" id="request_code" name="request_code" type="text" value="<?php if(isset($form_data['request_code'])) { echo htmlentities($form_data['request_code']); } ?>" onkeydown = "if(event.keyCode == 13){$('#request_code').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="request_code_type" class="hidden_context">Compare options for Response Code</label>
										<select id="request_code_type" name="request_code_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_code_type']) && $key==$form_data['request_code_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td><label for="request_response">Response:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="request_response_help">The JSON response from the API</p>
										<input class="ttFocus" aria-describedby="request_response_help" title="The JSON response from the API" id="request_response" name="request_response" type="text" value="<?php if(isset($form_data['request_response'])) { echo htmlentities($form_data['request_response']); } ?>" onkeydown="if(event.keyCode == 13){$('#request_response').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="request_response_type" class="hidden_context">Compare options for Response</label>
										<select id="request_response_type" name="request_response_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_response_type']) && $key == $form_data['request_response_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="start_date">Start Date:</label></td>
									<td><input type="text" id="start_date" name="start_date" class="date dpDate" value="<?php if(isset($form_data['start_date'])) { echo htmlentities($form_data['start_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
									<td>&nbsp;</td>
									<td><label for="end_date">End Date:</label></td>
									<td><input type="text" id="end_date" name="end_date" class="date dpDate" value="<?php if(isset($form_data['end_date'])) { echo htmlentities($form_data['end_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt", timeSuffix: ' '+timezone_abbr});</script>
							</table>
							<?PHP
								$export_file_name = 'Request Report';
								if (isset($form_data['report_name'])){
									$export_file_name = $form_data['report_name'];
								}
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'export_pdf' => '0',
									'print_page' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
									'export_file_name' => $export_file_name,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="details-link" name="details-link" type="submit" value="Save Report"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<div id="date_error_message" class="message_error" style="display: none;"></div>
							<?php if(sizeof($request_list) == 0) { ?>
								<div class="message">There are currently no web service requests.</div>
							<?php }
							    {
								if(!empty($form_data['date_warning_message'])) { ?>
								<div class="message"><?PHP echo $form_data['date_warning_message']; ?></div>
								<?PHP } ?>
								<?php if(sizeof($request_list) > 0) { ?>
									<div class="pagination">
										<?php echo $form_data['pages']->display_result_num();?>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
										<?php echo $form_data['pages']->display_items_per_page('top');?>
										<div class="pagination-options">
											<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
												<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP }
											else { ?>
												<a href="#" class="export" ><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } ?>
											<a id="export_pdf_top" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
											<a href="#"  onclick="submitPaginationForm('<?php echo $form_data['cur_page'];?>', '', '<?php echo $form_data['items_per_page'];?>', '', '', 1);"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
											<label for="page_select" class="hidden_context">Page Selector</label>
											<input id="page_select" class="page_selector_input" name="page_select" onchange="jaDNS  ipt:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
											<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
										</div>
									</div>
								<?php  } ?>
							<?php  } ?>
						<?PHP echo form_close(); ?>
						<a name="reportContent" id="reportContent" class="hidden_context hidden_link">Report Content</a>
						<?PHP echo form_open('/reports/requests',array('id'=>'clear_form')); echo form_close();
							if (sizeof($request_list) > 0) {
								$this->load->view('api/reports/result_tables/result_requests');
						?>
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page('bottom');?>
								<div class="pagination-options">
									<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
										<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP }
									else { ?>
										<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } ?>
									<a id="export_pdf_bottom" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
									<a href="#"  onclick="submitPaginationForm('<?php echo $form_data['cur_page'];?>', '', '<?php echo $form_data['items_per_page'];?>', '', '', 1);"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
									<label for="page_select_bottom" class="hidden_context">Page Selector</label>
									<input id="page_select_bottom" class="page_selector_input" name="page_select" onchange="jaDNS  ipt:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							<?php  } ?>
						</div>

						<div id="details-modal" title="Save Current Report">
							<div class="adhoc_report">
								<?PHP
									$this->load->view('api/reports/adhoc_reports/adhoc_requests');
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php $this->load->view('api/reports/result_tables/file_downloading_window');?>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>