<?php
/**
* Footer to be included on messages that have file transfers associated with them.
* @package direct-as-a-service
* @subpackage views
*/ /** */

//expects $mailbox, $file_transfers

?>
<hr />
<p><i><?= $mailbox->display_name() ?> has included <?= number_as_text(count($file_transfers)) ?> <?= pluralize_if_necessary('file', count($file_transfers)) ?> that <?= (count($file_transfers) > 1) ?  'are' :  'is' ?> too large to be attached to this message. To retrieve these files, use the links and passcodes below to access these files on our file transfer site.  The files will be available until <?= unix_to_display(first_element($file_transfers)->expires_at()) ?>.  If you are a VA Direct user, you can find a list of all files available for you to download using your VA credentials instead of individual passcodes on the <?= link_to(admin_url('file_transfer/available_for_download'), PRODUCT_NAME) ?> site.</i></p>
<ul>
<?php foreach($file_transfers as $file_transfer): ?>
	<li><?= link_to($file_transfer->url_for_view(), $file_transfer->name) ?> (<?= byte_format($file_transfer->size) ?>) <strong>Passcode:</strong> <?= $file_transfer->passcode ?></li>
<?php endforeach ?>
</ul>