<?php
/**
 * @package direct-as-a-service
 * @subpackage views
 * @filesource
 */ /** */
?>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div id="message_info" class="message">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					<script>
						$(function() {
							$("#tabs").tabs();
							$("#active_link").removeAttr("tabindex");
							$("#create_link").removeAttr("tabindex");
							$('[id^=public-modal]').dialog({ autoOpen: false })
							$('[id^=public-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('public-link','');
								$('[id^=public-modal]').dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id=public-modal'+id+']').dialog('open');
							});
							$('[id^=private-modal]').dialog({ autoOpen: false })
							$('[id^=private-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('private-link','');
								$( "[id^=private-modal]" ).dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id^=private-modal'+id+']').dialog('open');
							});
						});
					</script>
					
					<?PHP
						echo form_open('/administration/manage/facilities',array('id'=>'app_list_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'active_page_on_bar' => '',
							'active_page_select' => '',
							'active_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'inactive_page_on_bar' => '',
							'inactive_page_select' => '',
							'inactive_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div id="tabs" class="column">
						<ul>
							<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>
							<li><a id="active_link" href="#active" onclick="jaDNS  ipt:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Facilities</a></li>
							<li><a id="create_link" href="#create" onclick="jaDNS  ipt:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Create Facility</a></li>
							<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
						</ul>
						<div id="active">
							<p>This table lists the existing facilities.</p>
							
							<?php 
							 	//echo form_open('/administration/manage/facilities',array('id'=>'app_list_form')); 
								echo '<br/>';
								?>
									
								<?PHP //echo form_close(); ?>
								<table id="facility_table" class="display">
									<caption class="hidden_context">Facilities</caption>
									<thead>
										<tr class="gridheader">
											<th scope="col">Name</th>
											<th scope="col">Active</th>											
											<th scope="col">Action</th>
										</tr>
									</thead>
								</table>
								<?PHP //echo form_open('/administration/manage/facilities',array('id'=>'app_list_form')); ?>
									
								<?PHP //echo form_close(); ?>
						</div>
						<div id ="create" class="column">		
							<p>This form allows an administrator to create a facility.</p>
							<?PHP echo form_open('/administration/facility_create',array('id'=>'createFacilityForm')); ?>
								<div class="form" style="width:100%;">
									<label for="fac_name">Facility Name:</label> 
									<p class="hidden_context">Help Text for Facility Name: Please enter the name of the facility.</p>
									<input class="ttFocus" title="Please enter the name of the facility." type="text" name="fac_name" id="fac_name" <?PHP if(isset($fac_name)) { echo 'value="'.$this->security->xss_clean($fac_name).'"'; }?>/>
									
									<label for="is_active" style="width: 180px;">Active:</label>
									<p class="hidden_context">Help Text for Facility active attribute: Please determine the facility is active.</p> 
									<input class="ttHover" title="Please determine if the facility is active." type="checkbox" name="is_active" id="is_active" <?php if(isset($is_active) && $is_active){?> checked <?php }?>/>&nbsp;&nbsp;
								</div>
								<div class="text-right" style="width:100%;"><input class="blue-button" type="submit" value="Submit"/></div> 
							<?PHP echo form_close(); ?>
						</div>	
					</div>
				</div>
			</div>
		</div>
	</body>
</html>

<script type='text/jaDNS  ipt'>
	goToSubTab(<?PHP if(isset($anchor)){echo get_instance()->json->encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo get_instance()->json->encode($form_values); ?>);

	$(document).ready(function() {
		$('#facility_table').dataTable( {
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
					$(oSettings.nTableWrapper).find('.dataTables_length').hide();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
	    	"bProcessing": true,
	        "bServerSide": true,
	        "bStateSave": true,
	         "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
	            $('td:eq(1),td:eq(2),td:eq(3)', nRow).addClass('gridrow');
	          },
          	"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2]},
        		             { 'bSearchable': false, 'aTargets': [1,2]},
        		             { "sClass": "center break-word", 'aTargets': [1,2]}],
	        "sAjaxSource": '/administration/admin_facility_search/?active=true&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
	        "oLanguage": {
	        	"sEmptyTable": "No facilities were found",
	        	"sZeroRecords": "No facilities were found",
				"sInfo": "_TOTAL_ results",
				"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
					if(iTotal == 1) { return iTotal + " result"; }
					return iTotal + " results";
				},
				"sLengthMenu": "Records per page _MENU_",
				"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
	        	},
	    } );
	} );   
</script>