<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	if(!$admin_show['application_requests']) { show_error('Forbidden',403); }
	$this->load->view('api/header'); 
	$this->load->view('api/nav');

?>
				<div id="success">&nbsp;</div>
				<div id="error">&nbsp;</div> 

				<div class="breadcrumb-header-block">
					<h1>Administration</h1><span class="seperator">&#9658;</span><h2>Application Requests</h2>
				</div>
				<div class="column">
					<?PHP if(!empty($message)) { echo '<div id="message_info" class="message_info">'.$message.'</div>'; } ?>
					<?PHP if(!empty($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(!empty($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					
					<script>
						$(function() {
							$("#tabs").tabs();
							$("#pending_link").removeAttr("tabindex");
							$("#approved_link").removeAttr("tabindex");
							$("#denied_link").removeAttr("tabindex");

							$("[id^=dialog-form]").dialog({
								autoOpen: false,
								width: 600,
								height: 300,
								modal: true,
								buttons: {
									Submit: function(){
										var id = $(this).attr('id').replace('dialog-form','');
										$('#denyForm'+id).submit();
									},
									Cancel: function(){
										$(this).dialog("close");
									}
								}
							});
							$("[id^=deny-app]").click(function(e) {
								var id = 0;
								if($(e.target).attr('id')){
									id = $(e.target).attr('id').replace('deny-app',''); 
								}
								else{
									id = $(e.target).parent().attr('id').replace('deny-app',''); //get parent id since click is on image
								}
								$("#dialog-form"+id).dialog("open");
							});
						});
					</script>
					<?PHP
						echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'pending_page_on_bar' => '',
							'pending_page_select' => '',
							'pending_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'approved_page_on_bar' => '',
							'approved_page_select' => '',
							'approved_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'denied_page_on_bar' => '',
							'denied_page_select' => '',
							'denied_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div id="tabs" class="column">					
						<ul>
							<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>						
							<li><a id="pending_link" href="#pending" onclick="jaDNS  ipt:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Pending Approval</a></li>
							<li><a id="approved_link" href="#approved" onclick="jaDNS  ipt:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Approved</a></li>
							<li><a id="denied_link" href="#denied" onclick="jaDNS  ipt:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Denied</a></li>
							<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
						</ul>	
						<?php echo $this->load->view('api/administration/application_requests/_pending', compact('pending_list'), TRUE) ?>	
						<?php echo $this->load->view('api/administration/application_requests/_approved', compact('approved_list'), TRUE) ?>					
						<?php echo $this->load->view('api/administration/application_requests/_denied', compact('denied_list'), TRUE) ?>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
		<script type='text/jaDNS  ipt'>
			goToSubTab(<?PHP if(isset($anchor)){echo get_instance()->json->encode($anchor);} ?>);
			assignPaginationFormValues(<?PHP echo get_instance()->json->encode($form_values); ?>);
			$(document).ready(function() {
				$('#pending_table').dataTable({
					"fnDrawCallback": function(oSettings) {
						if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
							$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
							$(oSettings.nTableWrapper).find('.dataTables_length').hide();
						}
					},
					"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
					"bSort" : false,
					//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
					"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
									 { 'bSearchable': false, 'aTargets': 4},
									 { "sClass": "center", 'aTargets': []}],
					//set default sorting to Last Modified 2nd column, ascending
					"aaSorting": [[0,"asc"]],
					//"bPaginate": false,
					//set search box text
					"oLanguage": {
						"sSearch": "Find Application: ",
						"sEmptyTable":    "No applications were found",
						"sZeroRecords":   "No applications were found",
						"sInfo": "_TOTAL_ results",
						"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
							if(iTotal == 1) { return iTotal + " result"; }
							return iTotal + " results";
						},
						"sLengthMenu": "Records per page _MENU_",
						"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
					}
				});
		
				$('#approved_table, #denied_table').dataTable({
					"fnDrawCallback": function(oSettings) {
						if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
							$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
							$(oSettings.nTableWrapper).find('.dataTables_length').hide();
						}
					},
					"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
					"bSort" : false,
					//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
					"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
									 { "sClass": "center", 'aTargets': []}],
					//set default sorting to Last Modified 2nd column, ascending
					"aaSorting": [[0,"asc"]],
					//"bPaginate": false,
					//set search box text
					"oLanguage": {
						"sSearch": "Find Application: ",
						"sEmptyTable":    "No applications were found",
						"sZeroRecords":   "No applications were found",
						"sInfo": "_TOTAL_ results",
						"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
							if(iTotal == 1) { return iTotal + " result"; }
							return iTotal + " results";
						},
						"sLengthMenu": "Records per page _MENU_",
						"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
					}
				});
			});
		
		</script>
	</body>
</html>

