<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models-folder
* @filesource
*/

/** */
require_model('entity');

/**
* @package direct-as-a-service
* @subpackage models
*/
class Ticket extends DAAS_Entity {
	static $table = 'tickets';
	protected static $_relationships = array( 'user' => array( 'type' => 'belongs_to', 'key_for_relationship' => 'user_id'),
											  'parent' => array('type' => 'belongs_to', 'model' => 'ticket', 'related_foreign_key' => 'parent_id'),
											  'child' => array('type' => 'has_many', 'model' => 'ticket', 'foreign_key' => 'parent_id'),
											  'category' => array('type' => 'belongs_to', 'model' => 'ticket_category', 'related_foreign_key' => 'category_id'));
											  
	protected $_property_validation_rules = array( 'user_id' => 'nonzero_unsigned_integer',
												   'parent_id' => 'nonzero_unsigned_integer', 
												   'close_date' => 'unix_timestamp',
												   'message' => 'string' );		
	
	protected $_readonly_fields = array( 'open_date' ); 			
	
	public function human_readable_open_date(){
		if($this->property_is_empty('open_date')) return '';
		return date('m/d/Y h:i:s A', $this->open_date);
	}
	
	public function human_readable_close_date(){
		if($this->property_is_empty('close_date')) return '';
		return date('m/d/Y h:i:s A', $this->close_date);
	}
	
	public function values_for_report(){
		$values = $this->values();
		$values['user_id'] = $this->username;
		$values['category_id'] = $this->category_name;
		$values['open_date'] = $this->human_readable_open_date;
		$values['close_date'] = $this->human_readable_close_date;
	}	
	
	//set the open_date value on creation
	protected function _run_before_create(){
		$this->_set_field_value('open_date', date('U'), 0, TRUE);
		return parent::_run_before_create();
	}	

	public static function find_for_reports($id_or_conditions=array(), $key_by=null){
		Ticket::db()->select(Ticket::$table.'.*');
		Ticket::db()->select(User::$table.'.username');
		Ticket::db()->select(Ticket_category::$table.'.category AS category_name');
		Ticket::db()->join(User::$table, Ticket::$table.'.'.Ticket::related_foreign_key('user').' = '.User::$table.'.'.User::key_for_relationship('ticket'));
		Ticket::db()->join(Ticket_category::$table, Ticket::$table.'.'.Ticket::related_foreign_key('category').' = '.Ticket_category::$table.'.'.Ticket_category::key_for_relationship('ticket'));
		return static::find($id_or_conditions, $key_by);
	}
}