<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*/

/** */
require_model('direct_message');

/**
* @package direct-as-a-service
* @subpackage models
*/
class Message extends Direct_message {
	
//////////////////
// STATIC VARS
///////////////////	
	protected static $_relationships = array( 'disclosure' => array('type' => 'has_many', 'foreign_key' => 'messages_table_id'),
											  'attachment_disclosure' => array('type' => 'has_many', 'foreign_key' => 'messages_table_id', 'condition' => 'accounting_disclosure.hash IS NOT NULL'),
											  'message_disclosure' => array('type' => 'has_many', 'model' => 'disclosure',  'foreign_key' => 'messages_table_id', 'condition' => 'accounting_disclosure.hash IS NULL'),
											  'file_transfer' => array('type' => 'has_many'),
											  'folder' => array('type' => 'belongs_to'),
											  'patient' => array('type' => 'has_many', 'order_by' => 'family_name ASC, given_name ASC, date_of_birth ASC, organization ASC'));
	

///////////////////////////
// INSTANCE VARS
///////////////////////////

	//validation rules for settable properties on the method - these correspond to Validator methods		
	protected $_property_validation_rules = array('to' => 'comma_and_whitespace_separated_list_of_string_like_an_email_addresses', //MG, make your peace with the poor linguistic syntax of this rule.
												  'cc' => 'comma_and_whitespace_separated_list_of_string_like_an_email_addresses', //It is too much trouble to change
												  'bcc' => 'comma_and_whitespace_separated_list_of_string_like_an_email_addresses',
												  'archived' => 'boolean',
												  'protected_data' => 'unsigned_integer_or_null',
                                                                                                  'non_va_referral' => 'unsigned_integer',
												  'is_automated' => 'boolean');



////////////////////////
// INSTANCE METHODS
///////////////////////	

	/**
	* Archives this message.
	* @return boolean True on success
	*/										  
	public function archive(){
		$this->archived = true;
		return $this->save();
	}											  
	
	/**
	* Creates a file transfer that is associated with this message.
	* Note that file transfers can only be added to drafts.
	* @param array The values that should be passed to the file transfer
	* @return boolean
	*/
	public function add_file_transfer($values = array()){
		if(!is_array($values)) return $this->error->should_be_an_array($values);
		if(!$this->draft) return $this->error->warning('File transfers cannot be added to '.$this->describe().' because it is not a draft');
		$values[static::foreign_key('file_transfer')] = $this->id;		
		return File_transfer::create($values);
	}
	
	/**
	* Moves this message to a custom folder.
	* @return boolean True on success
	*/	
	public function move_to_folder($folder_id){
		if(!Folder::formatted_like_an_id($folder_id))  return $this->error->should_be_a_folder_id($folder_id, 1);		
#TODO - CHECK TO MAKE SURE THAT WE HAVE SEND, DRAFT, ARCHIVED VALUES LOADED
		if($this->sent) return $this->error->warning($this->model_alias.'#'.$this->id().' is a sent message and may not be moved to folder#'.$folder_id, 1);	
		if($this->draft) return $this->error->warning($this->model_alias.'#'.$this->id().' is a draft and may not be moved to folder#'.$folder_id, 1);
		if($this->archived && !$this->restore()) return $this->error->warning($this->model_alias.'#'.$this->id().' could not be moved to folder#'.$folder_id.' because it could not be restored from the archive', 1);
		
		$foreign_key = static::related_foreign_key('folder');
		$this->$foreign_key = $folder_id;
		return $this->save();
	}
	
	/**
	* Moves this message to the inbox.
	*
	* Only received messages may be moved to the inbox - attempting to move drafts or sent messages will trigger an error. 
	*
	* @return boolean True on success
	*/	
	public function move_to_inbox(){
#TODO - CHECK TO MAKE SURE THAT WE HAVE SEND, DRAFT, ARCHIVED VALUES LOADED	
		if($this->sent) return $this->error->warning($this->model_alias.'#'.$this->id().' is a sent message and may not be moved to the inbox', 1);	
		if($this->draft) return $this->error->warning($this->model_alias.'#'.$this->id().' is a draft and may not be moved to the inbox', 1);
		if($this->archived && !$this->restore()) return $this->error->warning('Could not restore archived message '.$this->model_alias.'#'.$this->id());
		$folder_foreign_key = static::related_foreign_key('folder');
		$this->$folder_foreign_key = null;
		return $this->save();
	}
		
	/**
	* Restores an archived message to its previous location (sent messages, drafts, inbox, folder, etc.).
	* @return boolean True on success
	*/
	public function restore(){
		$this->archived = false;
		return $this->save();
	}

	/**
	* Changes the message state to 'sent' and sends the message using the CI Email Library.
	*
	* Note that the raw_mime value is derived using the Mime_generator class, a descendent of the CI Email library, and will be configured in exactly the same way as the CI Email Library using 
	* {@link _configure_mail_object}.
	*
	* @return boolean 
	*/
	public function send(){
		if(!isset($this->id)) return $this->error->warning('Please save '.$this->describe().' before sending'); //saving will validate a number of values, so we need to do this first	
		
		//make sure that the mailbox is active & we're allowed to send mail
		$mailbox = $this->mailbox;
		if(!$mailbox->is_active) return $this->error->warning('Cannot send '.$this->describe().'; '.$mailbox->describe().' is not active');
		
		//make sure that the message values are valid for send	
		if(!$this->draft) return $this->error->warning(ucfirst($this->describe()).' is not a draft and may not be sent');
		if($this->archived) return $this->error->warning(ucfirst($this->describe()).' has been archived and may not be sent until it has been restored.');
		if($this->property_is_empty('sender')) return $this->error->warning('Please specify a sender for '.$this->describe().' before sending');
		if(!$this->has_recipients()) return $this->error->warning('Please specify at least one recipient for '.$this->describe());
		
		$recipients = get_instance()->json->decode($this->recipients);	
	
		//check to see if there are file transfers that are not already referenced in the message
		//if there are, add a footer to the message
		if($this->has_file_transfers()){
			
				
			$file_transfers_to_add = array();
			foreach($this->file_transfers as $id => $file_transfer){
				if(!string_contains($file_transfer->url_for_view(), $this->body()) && !string_contains($file_transfer->url_for_view(true), $this->body())){
					$file_transfers_to_add[$id] = $file_transfer;
				}	
				$file_transfer->populate_recipients(get_instance()->json->decode($this->recipients));
			}
			if(!empty($file_transfers_to_add)){
				$this->body = $this->body.get_instance()->load->view('api/file_transfer/emails/_footer', array('mailbox' => $this->mailbox, 'file_transfers' => $file_transfers_to_add), TRUE); 
			}
		}
		
		//note - for business team reasons, we're letting applications self-enforce whether or not disclosures are required for patient documents.					
		/*
		if(!$this->has_required_attachment_disclosures()){
			return $this->error->warning('Unable to send '.$this->describe().'; missing required attachment disclosures');
		}*/
		
		//first, make sure we can record the change for this in the database
		$this->_set_field_value('draft', false, 0, TRUE); //draft is usually readonly, so override the validation in this case only
		$this->_set_field_value('sent', true, 0, TRUE); //sent is usually readonly, so override the validation in this case only
		$this->_set_field_value('timestamp', now(), 0, TRUE); //timestamp is usually readonly, so override the validation in this case only
		$this->save();
		if(!$this->sent || $this->draft){
			return $this->error->warning('Unable to send '.$this->describe().'; unable to change message state from draft to sent'); //don't try to actually send the message if we couldn't update it in the db
		}
		
		$this->attachment_files(); //make sure that attachment files is populated			
		
		//configure the CI email library && use it to send the message
		$CI = get_instance();
		$CI->load->library('email'); 
		$CI->email->clear(); //clear just in case the email library was used elsewhere & not cleared
		if(!$this->_configure_mail_object($CI->email)) return $this->error->warning('Unable to configure email library for '.$this->describe());
		$success = $CI->email->send();
		if(!$success) $this->error->warning('Unable to send '.$this->describe().'; reverting the message to draft state.');
		$CI->email->clear();
		
		//if we weren't able to send, restore the message to draft state
		if(!$success){
			$this->_set_field_value('draft', true, 0, TRUE); //draft is usually readonly, so override the validation in this case only
			$this->_set_field_value('sent', false, 0, TRUE); //sent is usually readonly, so override the validation in this case only
			$this->_set_field_value('timestamp', now(), 0, TRUE); //timestamp is usually readonly, so override the validation in this case only
			if(!$this->save() || $this->sent || !$this->draft){
				$this->error->warning('Unable to revert '.$this->describe().' to draft state, but the message was not sent.  Please correct this database entry manually if possible.');
			}
			return false;
		}		
		
		//clear any disclosures made for attachments that were not a part of the message when it's been finalized and sent
		Attachment_disclosure::mop_up_the_headless_chickens($this);

		foreach($this->disclosures as $disclosure){			
			//for sent messages, we want a disclosure for every recipient
			$values = $disclosure->writeable_values();
			$success = true;
			
			foreach(get_instance()->json->decode($this->recipients) as $recipient){
				$values['recipient'] = $recipient;
				$values['disclosed'] = time();
				$values['sent_to'] = substr($recipient, strpos($recipient, '@') + 1);
				if($disclosure->property_is_empty('hash')){
					$success = Disclosure::create($values) && $success;
				}else{
					$values['hash'] = $disclosure->hash;
					$success = Attachment_disclosure::create($values) && $success;
				}
			}
			
			if($success)
				Disclosure::delete($disclosure->id);
			else
				$this->error->warning('Unable to populate disclosures for each recipient of '.$disclosure->describe().'; preserving '.$disclosure->describe().' with no recipients');	
		}
		
		return $success;	
	}


/////////////////////////////////////////////////////////////////////////////////////////////////////////
// GETTERS
// These are accessors for class variables prefaced by a _ and for database field values for this row 
// of the message table.  You can access these values by just treating them as normal variables, and
// {@link __get()} will obtain the value for you.  
///////////////////////////////////////////////////////////////////////////////////////////////////////////
	


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SETTERS
// These methods will be called by __set() when the corresponding class variable or database field 
// value is set: e.g., calling $this->sender = 'gibbs_margaret@bah.com' calls $this->set_sender('gibbs_margaret@bah.com').
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	

//////////////////////
// DATA MANAGEMENT
//////////////////////

	
	
	//this method is run after data has been saved to the database and the object has been reloaded with the updated database values
	//it will only be run if the data has been saved successfully
	protected function _run_after_create_and_update(){ 
	
		//For any attached documents that contain patient information, set up instances of the Patient model
		if(!empty($this->_attachment_files)) {
			Patient::populate_for_message($this);
		}
		
		//note - keeping this here instead of on parent because system-wide messages should never be incoming
		//MANAGE MDNS / READ RECEIPTS
		//send a read receipt if this message is marked as read but not marked as having been displayed (i.e., the first time that this message is successfully marked as read)
		if($this->seen && $this->is_incoming() && ($this->property_is_empty('flags') || !string_contains('\\Displayed', $this->flags))){ //if the mdn has not been set
				
			//the seen toggle may be set to seen/unseen depending on whether the user wants it to appear to be marked as read
			//in contrast, the "\\Displayed" flag will be set once and not changed afterwards				
			$this->flags .= "\\Displayed"; 
			
			if($this->save()){ //note - we're re-saving after changing the flags value, so this isn't an infinite loop.
				//check to ensure that they requested delivery (dispatched) MDN, if they did not request dispatched don't give them displayed
				$headers = get_instance()->json->decode($this->headers, TRUE);
				$headers_check = array_change_key_case(get_instance()->json->decode($this->headers, TRUE), CASE_LOWER);
				if(!empty($headers_check['disposition-notification-options']) && strtolower($headers_check['disposition-notification-options']) === 'x-direct-final-destination-delivery=optional,true') {
					//if we succeeded in marking the flag so that the message is marked as displayed, send a read receipt to the sender
					$CI = get_instance();
					if($this->is->string_like_a_direct_address($this->sender)){ //for local senders, we can just do this in the db
						$CI->load->model('messagestatusmodel');
						$CI->messagestatusmodel->message_displayed($this->message_id, $this->mailbox->email_address());
					}
					elseif(SEND_DISPLAY_MDN){//for non-local senders, we'll send an actual MDN via email
						$boundary = 'B_RPT_'.uniqid('');
						$local_address = $this->mailbox->email_address();
		
						$body = '--'.$boundary . "\r\n" .
								'Content-Type: text/plain'  . "\r\n" . "\r\n" .
						
								'Your message:'  . "\r\n" .
								'    From.....: ' . $this->sender . "\r\n" .
								'    Subject..: ' . $this->subject . "\r\n" .
								' was read on ' . gmdate('m/d/Y') . ' at ' . gmdate('H:i') . "(GMT)\r\n" .
								'--'.$boundary . "\r\n" .
								'Content-Type: message/disposition-notification' . "\r\n" . "\r\n" .
						
								'Reporting-UA: ' . $this->mailbox->domain . '; VLER Direct \r\n' .
								'Final-Recipient: rfc822;' . $local_address . "\r\n" .
								'Original-Message-Id: ' . $this->message_id . "\r\n"  .
								'Disposition: automatic-action/MDN-sent-automatically; displayed' . "\r\n" .
								'--'.$boundary.'--';
						
						$headers['From'] = $local_address;
						$headers['Content-Type'] = 'multipart/report; boundary="'.$boundary.'"; report-type=disposition-notification';
						$headers['Mime-Version'] = '1.0';
						$headers['To'] =  $this->sender;
						$headers['Subject'] = 'Read: ' . $this->subject;
						
						// Determine the method we're using to send the mdn
						$params['host'] = GATEWAY_SMTP_HOSTNAME;
						$params['port'] = GATEWAY_SMTP_PORT;
						$params['helo'] = 'HELO';
						$mail_object = & Mail::factory('smtp', $params);
						$result = $mail_object->send($this->sender,$headers,$body);					
					}
				}			
			}			
		}
	
		return true;
	}		

////////////////////
// STATIC
////////////////////	

	protected static function _set_conditions($id_or_conditions=array(), $offset=0){
		return (static::db()->where("([to]!='".ALL_USERS_MOCK_ADDRESS."' OR [to] = '' OR [to] IS NULL OR (draft!=1 AND sent!=1))") && parent::_set_conditions($id_or_conditions, $offset));
	}												  

	
}
