<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*/

/**
* @package direct-as-a-service
* @subpackage models
*/
class AdhocReportsModel extends CI_Model {

  /*
  *Save adhoc reports
  *
  */
  //note - you might want to check out the active record insert method, it's a lot easier just to pass an array of values than having to escape them all individually -- MG
    function create_adhoc_report($report_name, $report_description, $report_access, $adhoc_report_between, $adhoc_report_selector, $adhoc_report_order, $adhoc_report_direction,	$adhoc_report_type, $user_id, $report_status,  $adhoc_report_start_date, $adhoc_report_end_date, $adhoc_report_selector_option, $adhoc_report_time_field){
		if ($report_name){
		$query = $this->db->query('INSERT INTO adhoc_reports (report_name,report_description,report_access_type,report_time_period,report_query_generator,report_order_by_direction, report_order_by,report_type,report_created_time,report_created_by, report_status, report_start_date, report_end_date, report_selector, report_time_field) VALUES ('.$this->db->escape($report_name).','.$this->db->escape($report_description).','.$this->db->escape($report_access).','.$this->db->escape($adhoc_report_between).','.$this->db->escape($adhoc_report_selector).','.$this->db->escape($adhoc_report_order).','.$this->db->escape($adhoc_report_direction).','.$this->db->escape(mb_strtolower($adhoc_report_type)).','.$this->db->escape(time()).','.$user_id.','.$report_status.','.$this->db->escape(mb_strtolower($adhoc_report_start_date)).','.$this->db->escape(mb_strtolower($adhoc_report_end_date)).','.$this->db->escape(mb_strtolower($adhoc_report_selector_option)).','.$this->db->escape($adhoc_report_time_field).')');
		if($query) {
				if($query == '1') {
					return $query;
				}
			}
			return 'error';
		}	
	}
	
	/*
	 *Copy adhoc report from message view
	*
	*/
	//note - you might want to check out the active record insert method, it's a lot easier just to pass an array of values than having to escape them all individually -- MG
	function copy_adhoc_report($old_id ,$report_name, $report_description, $report_access, $user_id, $status){
		if ($report_name){
			$query = $this->db->query('INSERT INTO adhoc_reports (report_name,report_description,report_access_type,report_time_period,report_query_generator,report_order_by_direction, report_order_by,report_type,report_created_time,report_created_by, report_status, report_start_date, report_end_date, report_selector, report_time_field) SELECT '.$this->db->escape($report_name).','.$this->db->escape($report_description).','.$this->db->escape($report_access). " ,report_time_period,report_query_generator,report_order_by_direction, report_order_by,report_type, ".$this->db->escape(time()). "," .$this->db->escape($user_id). ", ".$this->db->escape($status).", report_start_date, report_end_date, report_selector, report_time_field FROM adhoc_reports where report_id = ".$this->db->escape($old_id));
			if($query) {
				if($query == '1') {
					return $query;
				}
			}
			return 'error';
		}
	}
  /*
  *Delete Report by report_ID
  *
  */
	function delete_adhoc_report($report_id){
		//note - if you're not going to escape the report id, it's critical to make sure that it's actually a number -- MG 2014/05/27
		if(!$this->is->nonzero_unsigned_integer($report_id)) return $this->error->should_be_a_nonzero_unsigned_integer($report_id); 
		
		$query = $this->db->query('UPDATE adhoc_reports SET report_status = 2 WHERE report_id = '.$report_id);
		if($query) {
			if($query == '1') {
					return $query;
			}
		} else {
			$error = "error";
			return $error;
		}
	}
	
	function edit_adhoc_report_attributes($report_id, $report_name) {
		if(!$this->is->nonzero_unsigned_integer($report_id)) 
			return $this->error->should_be_a_nonzero_unsigned_integer($report_id);
		$current_time = time();
		//Don't forget to escape your variables!  If you have questions about this, please ask. If you're having trouble remembering, consider using the Active Record methods, which always escape values as needed. - MG 2014/06/23		
		$query = $this->db->query("UPDATE adhoc_reports SET report_name = " . $this->db->escape($report_name) . ", report_created_time = " . $this->db->escape($current_time) . " WHERE report_id = ".$report_id);
		if($query) {
			if($query == '1') {
				//return array('report_id'=>$report_id, 'report_name'=>$report_name,'report_created_time'=>date('m/d/y h:i:s A',$current_time));
				return array('report_created_time'=>date('m/d/y h:i:s A',$current_time));
			}
		} else {
			$error = "error";
			return $error;
		}
	}
	
	/*
  *Delete report access to user by user_id and report_id
  *
  */
	function delete_user_access_to_report($report_id, $user_id){
		//developers - validate the values or escape them in your db queries, this is a security issue.
		if(!$this->is->nonzero_unsigned_integer($report_id)) 
			return $this->error->should_be_a_nonzero_unsigned_integer($report_id);
		if(!$this->is->nonzero_unsigned_integer($user_id)) 
			return $this->error->should_be_a_nonzero_unsigned_integer($user_id);		
	
		$current_time = time();
		$query = $this->db->query('DELETE FROM adhoc_reports_access WHERE report_id = '.$report_id.' AND user_id='.$user_id);
		$query_updae_time = $this->db->query("UPDATE adhoc_reports SET report_created_time = " . $this->db->escape($current_time) . " WHERE report_id = ".$report_id);
		if($query) {
			if($query == '1') {
				return array('report_created_time'=>date('m/d/y h:i:s A',$current_time));
			}
		} else {
			$error = "error";
			return $error;
		}
	}
	
	function add_user_access_to_report($report_id, $selected_items){
		//developers - validate the values or escape them in your db queries, this is a security issue.
		$session_id = $this->encrypt->decode($this->session->userdata('user_id'));
		$user_session_id = $this->usersmodel->get_user_id_from_org_id($session_id);
		
		if(!$this->is->nonzero_unsigned_integer($report_id)) {
			return $this->error->should_be_a_nonzero_unsigned_integer($report_id);
		}
		$current_time = time();
		
		$delete_query = $this->db->query('DELETE FROM adhoc_reports_access WHERE report_id = '.$this->db->escape($report_id) . ' and user_id != ' . $this->db->escape($user_session_id));
		if(empty($selected_items)) {
			return array('report_created_time'=>date('m/d/y h:i:s A',$current_time));
		}
		else {
			$selected_items = explode(',', $selected_items);
			foreach($selected_items as $user_id) {
				if(!$this->is->nonzero_unsigned_integer($user_id)) {
					return $this->error->should_be_a_nonzero_unsigned_integer($user_id);
				}
				$insert_query = $this->db->query('INSERT INTO adhoc_reports_access (report_id, user_id, time) VALUES (' . $this->db->escape($report_id) . ',' . $this->db->escape($user_id) . ',' . $this->db->escape($current_time) . ')');
			}
			
			$query_update_time = $this->db->query("UPDATE adhoc_reports SET report_created_time = " . $this->db->escape($current_time) . " WHERE report_id = ". $this->db->escape($report_id));
			if($insert_query) {
				if($insert_query == '1') {
					return array('report_created_time'=>date('m/d/y h:i:s A',$current_time));
				}
			} else {
				$error = "error";
				return $error;
			}
		}
	}
	
  /*
  *Get report type by report_ID
  *
  */
	function get_report_type_by_id($report_id){
		//note - if you're not going to escape the report id, it's critical to make sure that it's actually a number and not malicious sql of some sort -- MG 2014/05/27
		if(!$this->is->nonzero_unsigned_integer($report_id)) {
			//return $this->error->should_be_a_nonzero_unsigned_integer($report_id); 	
			show_404();	
		}
		return $this->db->query("SELECT report_access_type FROM [api].[dbo].[adhoc_reports] WHERE report_id = ".$report_id);
	}
 /*
  *Get report name by report_ID
  *
  */
	function get_report_name_by_id($report_id){
		//note - if you're not going to escape the report id, it's critical to make sure that it's actually a number and not malicious sql of some sort -- MG 2014/05/27
		if(!$this->is->nonzero_unsigned_integer($report_id)) return $this->error->should_be_a_nonzero_unsigned_integer($report_id); 		
		
		return $this->db->query("SELECT report_name FROM [api].[dbo].[adhoc_reports] WHERE report_id = ".$report_id);
	}
	
  /*
  *get Report by report_ID
  *
  */
	function get_adhoc_report_by_id($report_id, $report_type = null){
		//note - if you're not going to escape the report id, it's critical to make sure that it's actually a number and not malicious sql of some sort -- MG 2014/05/27
		if(!$this->is->nonzero_unsigned_integer($report_id)) return $CI->error->should_be_a_nonzero_unsigned_integer($report_id); 
		
		return $this->db->query("SELECT report_id,report_type,report_name,report_description,LEFT(report_description, 50) as small_description,report_created_by,report_access_type,report_created_time,report_query_generator,report_order_by,report_order_by_direction,report_time_period,report_status, US.username, report_end_date, report_start_date, report_selector, report_time_field FROM [api].[dbo].[adhoc_reports] AR INNER JOIN [api].[dbo].[users] US ON AR.report_created_by =  US.user_id WHERE report_id = '".$report_id."' AND report_status != 2 ".($report_type?"AND report_type = ".$this->db->escape($report_type):"")." ORDER BY report_created_time DESC");
	}
  /*
  *get Private Report per user
  *
  */
	function get_private_reports($user_id, $report_all = null){
		//note - if you're not going to escape the report id, it's critical to make sure that it's actually a number and not malicious sql of some sort -- MG 2014/05/27
		if(!$this->is->nonzero_unsigned_integer($user_id)) return $this->error->should_be_a_nonzero_unsigned_integer($user_id); 
		
		//Only show All Adhoc reports to Admin's
		$extra_report_info = '';
		if(!$report_all){
			$extra_report_info = " AND (report_type = 'user_activity_summary' OR report_type = 'facility')";
		}
		
		return $this->db->query("SELECT report_id,report_type,report_name,report_description,LEFT(report_description, 50) as small_description,report_created_by,report_access_type,report_created_time,report_query_generator,report_order_by,report_order_by_direction,report_time_period,report_status, US.username, report_end_date, report_start_date, report_selector, report_time_field FROM [api].[dbo].[adhoc_reports] AR INNER JOIN [api].[dbo].[users] US ON AR.report_created_by =  US.user_id WHERE report_created_by = '".$user_id."' AND report_status != 2 AND report_access_type = 'private'  ". $extra_report_info ."ORDER BY report_created_time DESC");
	}
  
  /*
  *get Global Report per user
  *
  */
	function get_global_reports($report_all = null){
		//Only show All Adhoc reports to Admin's
		$extra_report_info = '';
		if(!$report_all){
			$extra_report_info = " AND (report_type = 'user_activity_summary' OR report_type = 'facility')";
		}
		
		return $this->db->query("SELECT report_id,report_type,report_name,report_description,LEFT(report_description, 50) as small_description,report_created_by,report_access_type,report_created_time,report_query_generator,report_order_by,report_order_by_direction,report_time_period,report_status, US.username, report_end_date, report_start_date, report_selector, report_time_field FROM [api].[dbo].[adhoc_reports] AR INNER JOIN [api].[dbo].[users] US ON AR.report_created_by =  US.user_id WHERE report_access_type = 'everyone' AND report_status != 2 ". $extra_report_info ."ORDER BY report_created_time DESC");
	}
  
 
  /*
  *get Shared Report per user
  *
  */
	function get_shared_reports($user_id, $report_all = null){
		//Only show All Adhoc reports to Admin's
		$extra_report_info = '';
		if(!$report_all){
			$extra_report_info = " AND (report_type = 'user_activity_summary' OR report_type = 'facility')";
		}
		return $this->db->query("SELECT AR.report_id,report_type,report_name,report_description,\n" .
								"LEFT(report_description, 50) as small_description,report_created_by,\n" .
								"report_access_type,report_created_time,report_query_generator,\n" .
								"report_order_by,report_order_by_direction,report_time_period,\n" .
								"report_status, US.username, report_end_date,\n" . 
								"report_start_date, report_selector \n" .
								"FROM [api].[dbo].[adhoc_reports] AR " . 
								"INNER JOIN [api].[dbo].[adhoc_reports_access] ARA ON AR.report_id = ARA.report_id " .
								"INNER JOIN [api].[dbo].[users] US ON AR.report_created_by =  US.user_id " .
								"WHERE report_access_type = 'shared' AND AR.report_status != 2  AND ARA.user_id = '".$user_id."' " .
								"".$extra_report_info."ORDER BY report_created_time DESC");
	}
	
	/*
	*Share Report per user
	*
	*/
	function share_report($report_id, $user_id) {
		return $this->db->query('INSERT INTO adhoc_reports_access (report_id,user_id,time) VALUES ('.$this->db->escape($report_id).','.$this->db->escape($user_id).','.$this->db->escape(time()).')');
	}
	
	function get_latest_report_id() {		
		return $this->db->query('SELECT TOP(1) report_id FROM adhoc_reports ORDER BY report_id DESC')->result()[0]->report_id; //what if there are no results?
	}
	
	/*
	*Select shared user ids
	*
	*/
	function shared_users_ids($report_id) {
		return $this->db->query('SELECT report_access_id,report_id,AR.user_id,time, username FROM [api].[dbo].[adhoc_reports_access] AR JOIN [api].[dbo].[users] U ON U.user_id = AR.user_id where report_id = '.$this->db->escape($report_id).'');
	}
	
	
	/*
	*Security_check
	*
	*/
	function security_check($report_id, $userID){
		if(!$this->is->nonzero_unsigned_integer($report_id)) return $CI->error->should_be_a_nonzero_unsigned_integer($report_id); 
		return $this->db->query("SELECT report_access_id FROM [api].[dbo].[adhoc_reports_access] WHERE report_id = '".$report_id."' AND user_id =".$userID);
	}
	
	
	/*
	*Security_check_private
	*
	*/
	function security_check_private($report_id, $userID){
		if(!$this->is->nonzero_unsigned_integer($report_id)) return $CI->error->should_be_a_nonzero_unsigned_integer($report_id); 
		return $this->db->query("SELECT report_id FROM [api].[dbo].[adhoc_reports] WHERE report_id = '".$report_id."' AND report_created_by =".$userID);
	}
	
	public function get_selected_filter_array_from_db($report_selector){
		$array_report_selector = explode("<=>", $report_selector);
		$new_array = array();
		foreach ($array_report_selector  as $filters){
			$filter_value = explode(">>", $filters);
			if(sizeof($filter_value) > 1) {
				$new_array[trim($filter_value[0])] = trim($filter_value[1]);
			}
			else {
				$new_array[trim($filter_value[0])] = '';
			}
			
		}
		return $new_array;
    }
}